/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.CFContentLoader;
import coldfusion.document.spi.core.URLConnectionSettings;
import ice.net.Authentication;
import ice.net.proxy.Proxy;
import ice.storm.ContentLoader;
import ice.storm.ContentLoaderFactory;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ContentLoaderFactoryImpl
implements ContentLoaderFactory {
    private Proxy proxy;
    private URLConnectionSettings conSettings;

    public ContentLoaderFactoryImpl() {
    }

    public ContentLoaderFactoryImpl(URLConnectionSettings conSettings) {
        this.conSettings = conSettings;
        String proxyHost = conSettings.getProxyHost();
        if (proxyHost != null) {
            this.proxy = new Proxy(proxyHost, conSettings.getProxyPort());
            if (conSettings.getProxyUser() != null) {
                Authentication authentication = new Authentication(null);
                authentication.setIsProxyAuth(true);
                authentication.setUserName(conSettings.getProxyUser());
                authentication.setPassword(conSettings.getProxyPassword());
                this.proxy.setAuthentication(authentication);
            }
        }
    }

    public ContentLoader createContentLoader(URL url, String contentType) {
        return new CFContentLoader(url, contentType, this.proxy, this.conSettings);
    }

    public ContentLoader createContentLoader(String url, String contentType) {
        return new CFContentLoader(url, contentType, this.proxy, this.conSettings);
    }

    public ContentLoader createContentLoader(URL base, String loc, String contentType) {
        return new CFContentLoader(base, loc, contentType, this.proxy, this.conSettings);
    }

    public ContentLoader createContentLoader(URLConnection urlConnection, String contentType) {
        return new CFContentLoader(urlConnection, contentType, this.proxy, this.conSettings);
    }

    public ContentLoader createContentLoader(URL base, InputStream in, String contentType) {
        return new CFContentLoader(base, in, contentType, this.proxy, this.conSettings);
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

