/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingSettingsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingSettingsDescription> {
    private static final SdkField<Long> MINIMUM_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AutoScalingSettingsDescription.getter(AutoScalingSettingsDescription::minimumUnits)).setter(AutoScalingSettingsDescription.setter(Builder::minimumUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumUnits").build()}).build();
    private static final SdkField<Long> MAXIMUM_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AutoScalingSettingsDescription.getter(AutoScalingSettingsDescription::maximumUnits)).setter(AutoScalingSettingsDescription.setter(Builder::maximumUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumUnits").build()}).build();
    private static final SdkField<Boolean> AUTO_SCALING_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AutoScalingSettingsDescription.getter(AutoScalingSettingsDescription::autoScalingDisabled)).setter(AutoScalingSettingsDescription.setter(Builder::autoScalingDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingDisabled").build()}).build();
    private static final SdkField<String> AUTO_SCALING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingSettingsDescription.getter(AutoScalingSettingsDescription::autoScalingRoleArn)).setter(AutoScalingSettingsDescription.setter(Builder::autoScalingRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingRoleArn").build()}).build();
    private static final SdkField<List<AutoScalingPolicyDescription>> SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingSettingsDescription.getter(AutoScalingSettingsDescription::scalingPolicies)).setter(AutoScalingSettingsDescription.setter(Builder::scalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingPolicyDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_UNITS_FIELD, MAXIMUM_UNITS_FIELD, AUTO_SCALING_DISABLED_FIELD, AUTO_SCALING_ROLE_ARN_FIELD, SCALING_POLICIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long minimumUnits;
    private final Long maximumUnits;
    private final Boolean autoScalingDisabled;
    private final String autoScalingRoleArn;
    private final List<AutoScalingPolicyDescription> scalingPolicies;

    private AutoScalingSettingsDescription(BuilderImpl builder) {
        this.minimumUnits = builder.minimumUnits;
        this.maximumUnits = builder.maximumUnits;
        this.autoScalingDisabled = builder.autoScalingDisabled;
        this.autoScalingRoleArn = builder.autoScalingRoleArn;
        this.scalingPolicies = builder.scalingPolicies;
    }

    public Long minimumUnits() {
        return this.minimumUnits;
    }

    public Long maximumUnits() {
        return this.maximumUnits;
    }

    public Boolean autoScalingDisabled() {
        return this.autoScalingDisabled;
    }

    public String autoScalingRoleArn() {
        return this.autoScalingRoleArn;
    }

    public List<AutoScalingPolicyDescription> scalingPolicies() {
        return this.scalingPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettingsDescription)) {
            return false;
        }
        AutoScalingSettingsDescription other = (AutoScalingSettingsDescription)obj;
        return Objects.equals(this.minimumUnits(), other.minimumUnits()) && Objects.equals(this.maximumUnits(), other.maximumUnits()) && Objects.equals(this.autoScalingDisabled(), other.autoScalingDisabled()) && Objects.equals(this.autoScalingRoleArn(), other.autoScalingRoleArn()) && Objects.equals(this.scalingPolicies(), other.scalingPolicies());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingSettingsDescription").add("MinimumUnits", (Object)this.minimumUnits()).add("MaximumUnits", (Object)this.maximumUnits()).add("AutoScalingDisabled", (Object)this.autoScalingDisabled()).add("AutoScalingRoleArn", (Object)this.autoScalingRoleArn()).add("ScalingPolicies", this.scalingPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumUnits()));
            }
            case "MaximumUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumUnits()));
            }
            case "AutoScalingDisabled": {
                return Optional.ofNullable(clazz.cast(this.autoScalingDisabled()));
            }
            case "AutoScalingRoleArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingRoleArn()));
            }
            case "ScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingSettingsDescription, T> g) {
        return obj -> g.apply((AutoScalingSettingsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long minimumUnits;
        private Long maximumUnits;
        private Boolean autoScalingDisabled;
        private String autoScalingRoleArn;
        private List<AutoScalingPolicyDescription> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSettingsDescription model) {
            this.minimumUnits(model.minimumUnits);
            this.maximumUnits(model.maximumUnits);
            this.autoScalingDisabled(model.autoScalingDisabled);
            this.autoScalingRoleArn(model.autoScalingRoleArn);
            this.scalingPolicies(model.scalingPolicies);
        }

        public final Long getMinimumUnits() {
            return this.minimumUnits;
        }

        @Override
        public final Builder minimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
            return this;
        }

        public final void setMinimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
        }

        public final Long getMaximumUnits() {
            return this.maximumUnits;
        }

        @Override
        public final Builder maximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
            return this;
        }

        public final void setMaximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
        }

        public final Boolean getAutoScalingDisabled() {
            return this.autoScalingDisabled;
        }

        @Override
        public final Builder autoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
            return this;
        }

        public final void setAutoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
        }

        public final String getAutoScalingRoleArn() {
            return this.autoScalingRoleArn;
        }

        @Override
        public final Builder autoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
            return this;
        }

        public final void setAutoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
        }

        public final Collection<AutoScalingPolicyDescription.Builder> getScalingPolicies() {
            return this.scalingPolicies != null ? (Collection)this.scalingPolicies.stream().map(AutoScalingPolicyDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingPolicies(Collection<AutoScalingPolicyDescription> scalingPolicies) {
            this.scalingPolicies = AutoScalingPolicyDescriptionListCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(AutoScalingPolicyDescription ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<AutoScalingPolicyDescription.Builder> ... scalingPolicies) {
            this.scalingPolicies(Stream.of(scalingPolicies).map(c -> (AutoScalingPolicyDescription)((AutoScalingPolicyDescription.Builder)AutoScalingPolicyDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingPolicies(Collection<AutoScalingPolicyDescription.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = AutoScalingPolicyDescriptionListCopier.copyFromBuilder(scalingPolicies);
        }

        public AutoScalingSettingsDescription build() {
            return new AutoScalingSettingsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingSettingsDescription> {
        public Builder minimumUnits(Long var1);

        public Builder maximumUnits(Long var1);

        public Builder autoScalingDisabled(Boolean var1);

        public Builder autoScalingRoleArn(String var1);

        public Builder scalingPolicies(Collection<AutoScalingPolicyDescription> var1);

        public Builder scalingPolicies(AutoScalingPolicyDescription ... var1);

        public Builder scalingPolicies(Consumer<AutoScalingPolicyDescription.Builder> ... var1);
    }
}

