/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

class JRLongCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRLongCountIncrementer mainInstance = new JRLongCountIncrementer();

    private JRLongCountIncrementer() {
    }

    public static JRLongCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRLongIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRLongIncrementerFactory.ZERO;
        }
        return new Long(value.longValue() + 1L);
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null) {
            value = calculable.getValue() == null ? (Number)JRLongIncrementerFactory.ZERO : (Number)((Number)calculable.getValue());
        }
        if (combineValue == null) {
            return value;
        }
        if (value == null || calculable.isInitialized()) {
            value = JRLongIncrementerFactory.ZERO;
        }
        return new Long(value.longValue() + combineValue.longValue());
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRLongIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

