/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.retry.conditions;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.RetryUtils;
import software.amazon.awssdk.core.retry.conditions.MaxNumberOfRetriesCondition;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnStatusCodeCondition;

@FunctionalInterface
@SdkPublicApi
public interface RetryCondition {
    public boolean shouldRetry(RetryPolicyContext var1);

    public static RetryCondition defaultRetryCondition() {
        return OrRetryCondition.create(RetryOnStatusCodeCondition.create(SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES), RetryOnExceptionsCondition.create(SdkDefaultRetrySetting.RETRYABLE_EXCEPTIONS), c -> RetryUtils.isClockSkewException(c.exception()), c -> RetryUtils.isThrottlingException(c.exception()));
    }

    public static RetryCondition none() {
        return MaxNumberOfRetriesCondition.create(0);
    }
}

