/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkStandardLogger;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.ApiCallAttemptTimeoutException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.Response;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.awssdk.core.internal.http.async.SimpleHttpContentPublisher;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.core.internal.http.timers.TimeoutTracker;
import software.amazon.awssdk.core.internal.http.timers.TimerUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class MakeAsyncHttpRequestStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> {
    private static final Logger log = Logger.loggerFor(MakeAsyncHttpRequestStage.class);
    private final SdkAsyncHttpClient sdkAsyncHttpClient;
    private final TransformingAsyncResponseHandler<OutputT> responseHandler;
    private final TransformingAsyncResponseHandler<? extends SdkException> errorResponseHandler;
    private final Executor futureCompletionExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final Duration apiCallAttemptTimeout;

    public MakeAsyncHttpRequestStage(TransformingAsyncResponseHandler<OutputT> responseHandler, TransformingAsyncResponseHandler<? extends SdkException> errorResponseHandler, HttpClientDependencies dependencies) {
        this.responseHandler = responseHandler;
        this.errorResponseHandler = errorResponseHandler;
        this.futureCompletionExecutor = dependencies.clientConfiguration().option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR);
        this.sdkAsyncHttpClient = dependencies.clientConfiguration().option(SdkClientOption.ASYNC_HTTP_CLIENT);
        this.apiCallAttemptTimeout = dependencies.clientConfiguration().option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT);
        this.timeoutExecutor = dependencies.clientConfiguration().option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<Response<OutputT>> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        return this.executeHttpRequest(request, context);
    }

    private CompletableFuture<Response<OutputT>> executeHttpRequest(SdkHttpFullRequest request, RequestExecutionContext context) {
        CompletableFuture<OutputT> preparedTransformFuture = context.asyncResponseTransformerFuture() != null ? context.asyncResponseTransformerFuture() : this.responseHandler.prepare();
        CompletableFuture<? extends SdkException> preparedErrorTransformFuture = this.errorResponseHandler == null ? null : this.errorResponseHandler.prepare();
        CompletableFuture responseFuture = new CompletableFuture();
        ResponseHandler handler = new ResponseHandler(responseFuture, preparedTransformFuture, preparedErrorTransformFuture);
        CompletableFuture preparedWrapperTransformFuture = handler.prepare();
        Object requestProvider = context.requestProvider() == null ? new SimpleHttpContentPublisher(request) : new SdkHttpContentPublisherAdapter(context.requestProvider());
        SdkHttpFullRequest requestWithContentLength = this.getRequestWithContentLength(request, (SdkHttpContentPublisher)requestProvider);
        AsyncExecuteRequest executeRequest = AsyncExecuteRequest.builder().request((SdkHttpRequest)requestWithContentLength).requestContentPublisher((SdkHttpContentPublisher)requestProvider).responseHandler((SdkAsyncHttpResponseHandler)handler).fullDuplex(this.isFullDuplex(context.executionAttributes())).build();
        CompletableFuture httpClientFuture = this.sdkAsyncHttpClient.execute(executeRequest);
        TimeoutTracker timeoutTracker = this.setupAttemptTimer(responseFuture, context);
        context.apiCallAttemptTimeoutTracker(timeoutTracker);
        responseFuture.whenComplete((r, t) -> {
            if (t != null) {
                httpClientFuture.completeExceptionally((Throwable)t);
            }
        });
        preparedWrapperTransformFuture.whenCompleteAsync((r, t) -> {
            if (t == null) {
                responseFuture.complete(r);
            } else {
                responseFuture.completeExceptionally((Throwable)t);
            }
        }, this.futureCompletionExecutor);
        return responseFuture;
    }

    private boolean isFullDuplex(ExecutionAttributes executionAttributes) {
        return executionAttributes.getAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX) != null && executionAttributes.getAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX) != false;
    }

    private SdkHttpFullRequest getRequestWithContentLength(SdkHttpFullRequest request, SdkHttpContentPublisher requestProvider) {
        if (this.shouldSetContentLength(request, requestProvider)) {
            return request.toBuilder().putHeader("Content-Length", String.valueOf(requestProvider.contentLength().get())).build();
        }
        return request;
    }

    private boolean shouldSetContentLength(SdkHttpFullRequest request, SdkHttpContentPublisher requestProvider) {
        if (request.method() == SdkHttpMethod.GET || request.method() == SdkHttpMethod.HEAD || request.firstMatchingHeader("Content-Length").isPresent()) {
            return false;
        }
        return Optional.ofNullable(requestProvider).flatMap(SdkHttpContentPublisher::contentLength).isPresent();
    }

    private TimeoutTracker setupAttemptTimer(CompletableFuture<Response<OutputT>> executeFuture, RequestExecutionContext ctx) {
        long timeoutMillis = TimerUtils.resolveTimeoutInMillis(ctx.requestConfig()::apiCallAttemptTimeout, this.apiCallAttemptTimeout);
        Supplier<SdkClientException> exceptionSupplier = () -> ApiCallAttemptTimeoutException.create(timeoutMillis);
        return TimerUtils.timeAsyncTaskIfNeeded(executeFuture, this.timeoutExecutor, exceptionSupplier, timeoutMillis);
    }

    private static SdkHttpFullResponse toFullResponse(SdkHttpResponse response) {
        SdkHttpFullResponse.Builder builder = SdkHttpFullResponse.builder().statusCode(response.statusCode()).headers(response.headers());
        response.statusText().ifPresent(arg_0 -> ((SdkHttpFullResponse.Builder)builder).statusText(arg_0));
        return builder.build();
    }

    private class ResponseHandler
    implements TransformingAsyncResponseHandler<Response<OutputT>> {
        private final CompletableFuture<Response<OutputT>> responseFuture;
        private final CompletableFuture<OutputT> transformFuture;
        private final CompletableFuture<? extends SdkException> errorTransformFuture;
        private CompletableFuture<SdkHttpResponse> headersFuture;
        private volatile SdkHttpFullResponse response;

        ResponseHandler(CompletableFuture<Response<OutputT>> responseFuture, CompletableFuture<OutputT> transformFuture, CompletableFuture<? extends SdkException> errorTransformFuture) {
            this.responseFuture = responseFuture;
            this.transformFuture = transformFuture;
            this.errorTransformFuture = errorTransformFuture;
        }

        public void onHeaders(SdkHttpResponse response) {
            this.headersFuture.complete(response);
            if (response.isSuccessful()) {
                SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received successful response: " + response.statusCode());
                MakeAsyncHttpRequestStage.this.responseHandler.onHeaders(response);
            } else {
                SdkStandardLogger.REQUEST_LOGGER.debug(() -> "Received error response: " + response.statusCode());
                MakeAsyncHttpRequestStage.this.errorResponseHandler.onHeaders(response);
            }
            this.response = MakeAsyncHttpRequestStage.toFullResponse(response);
        }

        public void onError(Throwable error) {
            this.responseFuture.completeExceptionally(error);
            this.headersFuture.completeExceptionally(error);
        }

        public void onStream(Publisher<ByteBuffer> publisher) {
            if (this.response.isSuccessful()) {
                MakeAsyncHttpRequestStage.this.responseHandler.onStream(publisher);
            } else {
                MakeAsyncHttpRequestStage.this.errorResponseHandler.onStream(publisher);
            }
        }

        @Override
        public CompletableFuture<Response<OutputT>> prepare() {
            this.headersFuture = new CompletableFuture();
            return this.headersFuture.thenCompose(headers -> {
                if (headers.isSuccessful()) {
                    return this.transformFuture.thenApply(r -> Response.fromSuccess(r, this.response));
                }
                if (this.errorTransformFuture != null) {
                    return this.errorTransformFuture.thenApply(e -> Response.fromFailure(e, this.response));
                }
                return CompletableFuture.completedFuture(Response.fromFailure(null, this.response));
            });
        }
    }

    private static final class SdkHttpContentPublisherAdapter
    implements SdkHttpContentPublisher {
        private final AsyncRequestBody asyncRequestBody;

        private SdkHttpContentPublisherAdapter(AsyncRequestBody asyncRequestBody) {
            this.asyncRequestBody = asyncRequestBody;
        }

        public Optional<Long> contentLength() {
            return this.asyncRequestBody.contentLength();
        }

        public void subscribe(Subscriber<? super ByteBuffer> s) {
            this.asyncRequestBody.subscribe(s);
        }
    }
}

