/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.endpointdiscovery;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class EndpointDiscoveryRequest
implements ToCopyableBuilder<Builder, EndpointDiscoveryRequest> {
    private final Optional<String> operationName;
    private final Optional<Map<String, String>> identifiers;
    private final Optional<String> cacheKey;
    private final boolean required;
    private final URI defaultEndpoint;

    private EndpointDiscoveryRequest(BuilderImpl builder) {
        this.operationName = builder.operationName;
        this.identifiers = builder.identifiers;
        this.cacheKey = builder.cacheKey;
        this.required = builder.required;
        this.defaultEndpoint = builder.defaultEndpoint;
    }

    public Optional<String> operationName() {
        return this.operationName;
    }

    public Optional<Map<String, String>> identifiers() {
        return this.identifiers;
    }

    public Optional<String> cacheKey() {
        return this.cacheKey;
    }

    public boolean required() {
        return this.required;
    }

    public URI defaultEndpoint() {
        return this.defaultEndpoint;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    implements Builder {
        private Optional<String> operationName = Optional.empty();
        private Optional<Map<String, String>> identifiers = Optional.empty();
        private Optional<String> cacheKey = Optional.empty();
        private boolean required = false;
        private URI defaultEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDiscoveryRequest request) {
            this.operationName = request.operationName;
            this.identifiers = request.identifiers;
            this.cacheKey = request.cacheKey;
            this.required = request.required;
        }

        @Override
        public Builder operationName(String operationName) {
            this.operationName = Optional.ofNullable(operationName);
            return this;
        }

        @Override
        public Builder identifiers(Map<String, String> identifiers) {
            this.identifiers = Optional.ofNullable(identifiers);
            return this;
        }

        @Override
        public Builder cacheKey(String cacheKey) {
            this.cacheKey = Optional.ofNullable(cacheKey);
            return this;
        }

        @Override
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public Builder defaultEndpoint(URI defaultEndpoint) {
            this.defaultEndpoint = defaultEndpoint;
            return this;
        }

        public EndpointDiscoveryRequest build() {
            return new EndpointDiscoveryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointDiscoveryRequest> {
        public Builder operationName(String var1);

        public Builder identifiers(Map<String, String> var1);

        public Builder cacheKey(String var1);

        public Builder required(boolean var1);

        public Builder defaultEndpoint(URI var1);
    }
}

