/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.handler;

import java.net.URI;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.RequestBody;

@SdkProtectedApi
@NotThreadSafe
public final class ClientExecutionParams<InputT extends SdkRequest, OutputT> {
    private InputT input;
    private RequestBody requestBody;
    private AsyncRequestBody asyncRequestBody;
    private Marshaller<InputT> marshaller;
    private HttpResponseHandler<OutputT> responseHandler;
    private HttpResponseHandler<? extends SdkException> errorResponseHandler;
    private boolean fullDuplex;
    private String hostPrefixExpression;
    private String operationName;
    private URI discoveredEndpoint;

    public Marshaller<InputT> getMarshaller() {
        return this.marshaller;
    }

    public ClientExecutionParams<InputT, OutputT> withMarshaller(Marshaller<InputT> marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public InputT getInput() {
        return this.input;
    }

    public ClientExecutionParams<InputT, OutputT> withInput(InputT input) {
        this.input = input;
        return this;
    }

    public HttpResponseHandler<OutputT> getResponseHandler() {
        return this.responseHandler;
    }

    public ClientExecutionParams<InputT, OutputT> withResponseHandler(HttpResponseHandler<OutputT> responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public HttpResponseHandler<? extends SdkException> getErrorResponseHandler() {
        return this.errorResponseHandler;
    }

    public ClientExecutionParams<InputT, OutputT> withErrorResponseHandler(HttpResponseHandler<? extends SdkException> errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public ClientExecutionParams<InputT, OutputT> withRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public AsyncRequestBody getAsyncRequestBody() {
        return this.asyncRequestBody;
    }

    public ClientExecutionParams<InputT, OutputT> withAsyncRequestBody(AsyncRequestBody asyncRequestBody) {
        this.asyncRequestBody = asyncRequestBody;
        return this;
    }

    public boolean isFullDuplex() {
        return this.fullDuplex;
    }

    public ClientExecutionParams<InputT, OutputT> withFullDuplex(boolean fullDuplex) {
        this.fullDuplex = fullDuplex;
        return this;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ClientExecutionParams<InputT, OutputT> withOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public String hostPrefixExpression() {
        return this.hostPrefixExpression;
    }

    public ClientExecutionParams<InputT, OutputT> hostPrefixExpression(String hostPrefixExpression) {
        this.hostPrefixExpression = hostPrefixExpression;
        return this;
    }

    public URI discoveredEndpoint() {
        return this.discoveredEndpoint;
    }

    public ClientExecutionParams<InputT, OutputT> discoveredEndpoint(URI discoveredEndpoint) {
        this.discoveredEndpoint = discoveredEndpoint;
        return this;
    }
}

