/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ConfigManager;
import coldfusion.orm.ORMSettings;
import coldfusion.orm.hibernate.HibernateConfiguration;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.util.CaseInsensitiveMap;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationManager
implements ConfigManager {
    public static final String DATASOURCE = "datasource";
    private static final String ORMSETTING = "ormsettings";
    private static ConfigurationManager instance = new ConfigurationManager();
    private Map<String, HibernateConfiguration> configMap = new HashMap<String, HibernateConfiguration>();

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return instance;
    }

    public static HibernateConfiguration getCurrentConfiguration() {
        String appName = FusionContext.getCurrent().getApplicationName();
        return ConfigurationManager.getInstance().getConfiguration(appName);
    }

    @Override
    public void initConfiguration(String appName, String appLocation) {
        Map appSetting = ApplicationScopeTracker.getApplicationScope((String)appName).getApplicationSettingsMap();
        Map ormSetting = (Map)appSetting.get(ORMSETTING);
        if (ormSetting == null) {
            ormSetting = new CaseInsensitiveMap();
        }
        if (!ormSetting.containsKey(DATASOURCE)) {
            ormSetting.put(DATASOURCE, appSetting.get(DATASOURCE));
        }
        HibernateConfiguration config = new HibernateConfiguration(new ORMSettings(ormSetting), appLocation, appName);
        this.configMap.put(appName, config);
    }

    public void buildSearchMetadata(String appName) {
        HibernateConfiguration config = this.configMap.get(appName);
        if (config != null && config.getORMSettings().isSearchEnabled()) {
            config.buildSearchMetadata();
        }
    }

    @Override
    public HibernateConfiguration getConfiguration(String appName) {
        return this.configMap.get(appName);
    }

    public HibernateConfiguration removeConfiguration(String appname) {
        return this.configMap.remove(appname);
    }
}

