/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.orm.EntityQueryTable;
import coldfusion.orm.ORMConfiguration;
import coldfusion.orm.ORMProvider;
import coldfusion.orm.PersistenceManager;
import coldfusion.orm.hibernate.HibernateSessionManager;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.util.RuntimeWrapper;
import jakarta.servlet.jsp.PageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;

public class ORMUtils {
    private static final String DATASOURCE = "datasource";

    public static PersistenceManager getPersistenceManager() {
        PersistenceManager pm = ORMProvider.getDefault().getCurrentPersistenceManager();
        if (pm == null) {
            throw new ORMNotConfiguredException();
        }
        return pm;
    }

    public static Object getSearchManager() {
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            return ormSearchService.getSearchManager();
        }
        return null;
    }

    public static Object entityLoadByPK(String componentName, Object id) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoadByPK");
        Object entity = ORMUtils.getPersistenceManager().loadByPK(componentName, id);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoadByPK");
        return entity;
    }

    private static Object entityLoadByPK(String componentName, Object id, boolean unique) {
        Object entity = ORMUtils.getPersistenceManager().loadByPK(componentName, id);
        if (!unique) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            if (entity != null) {
                list.add(entity);
            }
            return list;
        }
        return entity;
    }

    public static List entityLoad(String componentName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoad");
        List list = ORMUtils.getPersistenceManager().load(componentName);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoad");
        return list;
    }

    public static List entityLoad(String componentName, Object idOrFilter) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoad");
        List result = idOrFilter instanceof Map ? ORMUtils.getPersistenceManager().load(componentName, (Map)idOrFilter) : (List)ORMUtils.entityLoadByPK(componentName, idOrFilter, false);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoad");
        return result;
    }

    public static Object entityLoad(String componentName, Object idOrNameVsValue, Object orderByOrUniqueOrOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoad");
        Object result = ORMUtils._entityLoad(componentName, idOrNameVsValue, orderByOrUniqueOrOptions);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoad");
        return result;
    }

    private static Object _entityLoad(String componentName, Object idOrNameVsValue, Object orderByOrUniqueOrOptions) {
        boolean unique;
        Map options = null;
        Boolean uniqueObj = null;
        String orderBy = null;
        if (orderByOrUniqueOrOptions instanceof Map) {
            options = (Map)orderByOrUniqueOrOptions;
        } else {
            uniqueObj = ORMUtils.getBoolean(orderByOrUniqueOrOptions);
        }
        if (options == null && uniqueObj == null && orderByOrUniqueOrOptions != null) {
            orderBy = orderByOrUniqueOrOptions.toString();
        }
        boolean bl = unique = uniqueObj != null && uniqueObj != false;
        if (idOrNameVsValue instanceof Map) {
            if (orderBy != null) {
                return ORMUtils.getPersistenceManager().load(componentName, (Map)idOrNameVsValue, orderBy, null);
            }
            if (options != null) {
                return ORMUtils.getPersistenceManager().load(componentName, (Map)idOrNameVsValue, null, options);
            }
            return ORMUtils.getPersistenceManager().load(componentName, (Map)idOrNameVsValue, unique);
        }
        return ORMUtils.entityLoadByPK(componentName, idOrNameVsValue, unique);
    }

    private static Boolean getBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        String str = obj.toString().toLowerCase();
        if (str.equals("true") || str.equals("yes")) {
            return Boolean.TRUE;
        }
        if (str.equals("false") || str.equals("no")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Object entityLoad(String componentName, Object idOrNameVsValue, String orderByOrUnique, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoad");
        Object result = ORMUtils._entityLoad(componentName, idOrNameVsValue, orderByOrUnique, options);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoad");
        return result;
    }

    private static Object _entityLoad(String componentName, Object idOrNameVsValue, String orderByOrUnique, Map options) {
        boolean unique;
        Boolean uniqueObj = ORMUtils.getBoolean(orderByOrUnique);
        boolean bl = unique = uniqueObj != null && uniqueObj != false;
        if (idOrNameVsValue instanceof Map) {
            if (uniqueObj == null && !orderByOrUnique.isEmpty()) {
                return ORMUtils.getPersistenceManager().load(componentName, (Map)idOrNameVsValue, orderByOrUnique, options);
            }
            return ORMUtils.getPersistenceManager().load(componentName, (Map)idOrNameVsValue, null, options, unique);
        }
        return ORMUtils.entityLoadByPK(componentName, idOrNameVsValue, unique);
    }

    public static List entityLoadByExample(Object obj) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoadByExample");
        List list = ORMUtils.getPersistenceManager().loadByExample(obj);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoadByExample");
        return list;
    }

    public static Object entityLoadByExample(Object obj, boolean unique) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoadByExample");
        Object result = ORMUtils.getPersistenceManager().loadByExample(obj, unique);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoadByExample");
        return result;
    }

    public static Object entityLoadByExample(Object obj, boolean unique, String option) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityLoadByExample");
        Object result = ORMUtils.getPersistenceManager().loadByExample(obj, option, unique);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityLoadByExample");
        return result;
    }

    public static void entitySave(Object obj, boolean insert) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntitySave");
        ORMUtils.getPersistenceManager().save(obj, insert);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntitySave");
    }

    public static void entityDelete(Object obj) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityDelete");
        ORMUtils.getPersistenceManager().delete(obj);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityDelete");
    }

    public static Object getSession() {
        return ORMUtils.getSessionManager().getSession();
    }

    public static Object getSession(String datasource) {
        return ORMUtils.getSessionManager().getSession(datasource);
    }

    private static HibernateSessionManager getSessionManager() {
        return HibernateSessionManager.getInstance();
    }

    public static void closeSession() {
        ORMUtils.getSessionManager().closeSession(false);
    }

    public static void closeAllSessions() {
        ORMUtils.getSessionManager().closeAllCurrentSessions(false);
    }

    public static void closeSession(String datasource) {
        ORMUtils.getSessionManager().closeSession(datasource, false);
    }

    public static void closeSession(Session session) {
        ORMUtils.getSessionManager().closeSession(session, false);
    }

    public static void flushSession() {
        ORMUtils.getSessionManager().flushSession();
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.onFlush();
        }
    }

    public static void flushSession(String datasource) {
        ORMUtils.getSessionManager().flushSession(datasource);
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.onFlush();
        }
    }

    public static void flushAllSessions() {
        ORMUtils.getSessionManager().flushAllCurrentSessions();
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.onFlush();
        }
    }

    public static void flushSession(Session session) {
        ORMUtils.getSessionManager().flushSession(session);
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService();
        if (ormSearchService != null) {
            ormSearchService.onFlush();
        }
    }

    public static void clearSession() {
        ORMUtils.getSessionManager().clearCurrentSession();
    }

    public static void clearSession(String datasource) {
        ORMUtils.getSessionManager().clearCurrentSession(datasource);
    }

    public static void entityReload(Object obj) {
        RequestMonitorEventProcessor.onFunctionStart((String)"EntityReload");
        ORMUtils.getPersistenceManager().reload(obj);
        RequestMonitorEventProcessor.onFunctionEnd((String)"EntityReload");
    }

    public static Object executeQuery(String queryString) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMExecuteQuery");
        Object result = ORMUtils.getPersistenceManager().executeQuery(queryString, null, false, null);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMExecuteQuery");
        return result;
    }

    public static Object executeQuery(String hql, Object paramsOrUnique) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMExecuteQuery");
        Object result = ORMUtils._executeQuery(hql, paramsOrUnique);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMExecuteQuery");
        return result;
    }

    private static Object _executeQuery(String hql, Object paramsOrUnique) {
        if (paramsOrUnique instanceof List || paramsOrUnique instanceof Map) {
            return ORMUtils._executeQuery(hql, paramsOrUnique, false, null);
        }
        return ORMUtils.executeQuery(hql, null, Cast._boolean((Object)paramsOrUnique), null);
    }

    public static Object executeQuery(String hql, Object paramsOrUnique, Object uniqueOrQueryOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMExecuteQuery");
        Object result = ORMUtils._executeQuery(uniqueOrQueryOptions, hql, paramsOrUnique);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMExecuteQuery");
        return result;
    }

    private static Object _executeQuery(Object uniqueOrQueryOptions, String hql, Object paramsOrUnique) {
        if (uniqueOrQueryOptions instanceof Map) {
            if (paramsOrUnique instanceof List || paramsOrUnique instanceof Map) {
                return ORMUtils._executeQuery(hql, paramsOrUnique, false, (Map)uniqueOrQueryOptions);
            }
            return ORMUtils._executeQuery(hql, null, Cast._boolean((Object)paramsOrUnique), (Map)uniqueOrQueryOptions);
        }
        return ORMUtils._executeQuery(hql, paramsOrUnique, Cast._boolean((Object)uniqueOrQueryOptions), null);
    }

    public static Object executeQuery(String hql, Object params, boolean unique, Map queryOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMExecuteQuery");
        Object result = ORMUtils._executeQuery(hql, params, unique, queryOptions);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMExecuteQuery");
        return result;
    }

    public static Object _executeQuery(String hql, Object params, boolean unique, Map queryOptions) {
        String datasource;
        String string = datasource = queryOptions == null ? null : (String)queryOptions.get(DATASOURCE);
        if (params instanceof List) {
            return ORMUtils.getPersistenceManager().executeQuery(hql, datasource, (List)params, unique, queryOptions);
        }
        if (params instanceof Map) {
            return ORMUtils.getPersistenceManager().executeQueryWithNamedParams(hql, datasource, (Map)params, unique, queryOptions);
        }
        return ORMUtils.getPersistenceManager().executeQuery(hql, datasource, unique, queryOptions);
    }

    public static Object getTypedValue(Object obj, Class typeClass) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof TemplateProxy) && !typeClass.isAssignableFrom(obj.getClass())) {
            if (obj instanceof JavaProxy) {
                obj = ((JavaProxy)obj).getObject();
            }
            obj = Cast._cast((Object)obj, (Class)typeClass);
        }
        return obj;
    }

    public static Object getTypedList(List list, Class type) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (type.isInstance(list.get(0))) {
            return list;
        }
        ArrayList newList = new ArrayList();
        for (Object obj : list) {
            if (obj instanceof JavaProxy) {
                obj = ((JavaProxy)obj).getObject();
            }
            obj = Cast._cast(obj, (Class)type);
            newList.add(obj);
        }
        return newList;
    }

    public static void reloadORM() {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMReload");
        ORMProvider.getDefault().reloadORMForApplication(FusionContext.getCurrent().getApplicationName());
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMReload");
    }

    public static void evictEntity(String componentName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictEntity");
        ORMUtils.getPersistenceManager().evictEntity(componentName);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictEntity");
    }

    public static void evictEntity(String componentName, Object id) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictEntity");
        ORMUtils.getPersistenceManager().evictEntity(componentName, id);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictEntity");
    }

    public static void evictCollection(String componentName, String relationName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictCollection");
        ORMUtils.getPersistenceManager().evictCollection(componentName, relationName);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictCollection");
    }

    public static void evictCollection(String componentName, String relationName, Object id) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictCollection");
        ORMUtils.getPersistenceManager().evictCollection(componentName, relationName, id);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictCollection");
    }

    public static void evictQueries() {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictQueries");
        ORMUtils.getPersistenceManager().evictQueries();
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictQueries");
    }

    public static void evictQueries(String cacheName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictQueries");
        ORMUtils.getPersistenceManager().evictQueries(cacheName);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictQueries");
    }

    public static void evictQueries(String cacheName, String datasource) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMEvictQueries");
        ORMUtils.getPersistenceManager().evictQueries(cacheName, datasource);
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMEvictQueries");
    }

    public static Object entityMerge(Object obj) {
        return ORMUtils.getPersistenceManager().merge(obj);
    }

    public static Object getSessionFactory() {
        ORMConfiguration config = ORMProvider.getDefault().getCurrentConfiguration();
        if (config == null) {
            throw new ORMNotConfiguredException();
        }
        return config.getSessionFactory();
    }

    public static Object getSessionFactory(String datasource) {
        ORMConfiguration config = ORMProvider.getDefault().getCurrentConfiguration();
        if (config == null) {
            throw new ORMNotConfiguredException();
        }
        return config.getSessionFactory(datasource);
    }

    public static String getCFCName(String entityName) {
        ORMConfiguration config = ORMProvider.getDefault().getCurrentConfiguration();
        if (config == null) {
            throw new ORMNotConfiguredException();
        }
        return config.getCFCName(entityName);
    }

    public static Object entityNew(String entityName) {
        return ORMUtils.getPersistenceManager().entityNew(entityName);
    }

    public static Object entityNew(String entityName, Map properties) {
        return ORMUtils.entityNew(entityName, properties, false);
    }

    public static Object entityNew(String entityName, Map properties, boolean ignoreExtra) {
        Object o = ORMUtils.entityNew(entityName);
        if (o instanceof TemplateProxy && properties != null) {
            TemplateProxy cfc = (TemplateProxy)o;
            for (Map.Entry prop : properties.entrySet()) {
                String propName = (String)prop.getKey();
                Object propValue = prop.getValue();
                String setterMethod = "set" + propName;
                if (ignoreExtra && cfc.resolveMethod(setterMethod, false) == null) continue;
                try {
                    cfc.invoke(setterMethod, new Object[]{propValue}, (PageContext)FusionContext.getCurrent().pageContext);
                }
                catch (Throwable th) {
                    throw new RuntimeWrapper(th);
                }
            }
        }
        return o;
    }

    public static void ORMIndex() {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMIndex");
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            ormSearchService.ORMIndex();
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMIndex");
    }

    public static void ORMIndex(Object entityNameOrInstance) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMIndex");
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            ormSearchService.ORMIndex(entityNameOrInstance);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMIndex");
    }

    public static void ORMIndexPurge() {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMIndexPurge");
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            ormSearchService.ORMIndexPurge();
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMIndexPurge");
    }

    public static void ORMIndexPurge(String entityName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMIndexPurge");
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            ormSearchService.ORMIndexPurge(entityName);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMIndexPurge");
    }

    public static Object ORMSearch(String query, String entityName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMSearch");
        Object resultObj = null;
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            resultObj = ormSearchService.ORMSearch(query, entityName);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMSearch");
        return resultObj;
    }

    public static Object ORMSearch(String query, String entityName, Object fieldNames) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMSearch");
        Object resultObj = null;
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            resultObj = ormSearchService.ORMSearch(query, entityName, fieldNames);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMSearch");
        return resultObj;
    }

    public static Object ORMSearch(String query, String entityName, Object fieldNames, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMSearch");
        Object resultObj = null;
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            resultObj = ormSearchService.ORMSearch(query, entityName, fieldNames, options);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMSearch");
        return resultObj;
    }

    public static Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMSearchOffline");
        Object resultObj = null;
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            resultObj = ormSearchService.ORMSearchOffline(query, entityName, fieldTobeSelected);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMSearchOffline");
        return resultObj;
    }

    public static Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected, Object fieldNames) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMSearchOffline");
        Object resultObj = null;
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            resultObj = ormSearchService.ORMSearchOffline(query, entityName, fieldTobeSelected, fieldNames);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMSearchOffline");
        return resultObj;
    }

    public static Object ORMSearchOffline(String query, String entityName, Object fieldTobeSelected, Object fieldNames, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"ORMSearchOffline");
        Object resultObj = null;
        ORMSearchService ormSearchService = ServiceFactory.getOrmSearchService((boolean)true);
        if (ormSearchService != null) {
            resultObj = ormSearchService.ORMSearchOffline(query, entityName, fieldTobeSelected, fieldNames, options);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"ORMSearchOffline");
        return resultObj;
    }

    public static QueryTable entityToQuery(Object obj) {
        return new EntityQueryTable(obj);
    }

    public static QueryTable entityToQuery(Object entity, String entityName) {
        return new EntityQueryTable(entity, entityName);
    }

    public static String getCFCName(Object obj) {
        String cfcName = null;
        if (obj instanceof TemplateProxy) {
            TemplateProxy cfc = (TemplateProxy)obj;
            cfcName = cfc.getName();
        }
        return cfcName;
    }

    public static class ORMNotConfiguredException
    extends ApplicationException {
    }

    public static class ORMNotConfiguredForDatasourceException
    extends ApplicationException {
        public String datasource;

        public ORMNotConfiguredForDatasourceException(String datasource) {
            this.datasource = datasource;
        }
    }
}

