/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ConfigManager;
import coldfusion.orm.ORMConfiguration;
import coldfusion.orm.PersistenceManager;
import coldfusion.orm.hibernate.HibernateProvider;

public abstract class ORMProvider {
    private static ORMProvider defaultProvider = new HibernateProvider();

    public abstract PersistenceManager getPersistenceManager(ORMConfiguration var1);

    public abstract ConfigManager getConfigManager();

    public abstract void reloadORMForApplication(String var1);

    public ORMConfiguration getCurrentConfiguration() {
        String appName = FusionContext.getCurrent().getApplicationName();
        return this.getConfigManager().getConfiguration(appName);
    }

    public PersistenceManager getCurrentPersistenceManager() {
        ORMConfiguration currentConfiguration = this.getCurrentConfiguration();
        if (currentConfiguration != null) {
            return this.getPersistenceManager(currentConfiguration);
        }
        return null;
    }

    public static ORMProvider getDefault() {
        return defaultProvider;
    }

    public static void setDefault(ORMProvider provider) {
        defaultProvider = provider;
    }

    public static void init() {
    }
}

