/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.request;

import coldfusion.cloud.gcp.config.AbstractGCPServiceConfig;
import coldfusion.cloud.gcp.config.RetrySettingsBuilder;
import coldfusion.gcp.storage.config.ConfigUtil;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.TransportOptions;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import java.util.Map;
import java.util.Objects;

public class StorageConfigBuilder
extends AbstractGCPServiceConfig {
    private String host;
    private StorageRetryStrategy storageRetryStrategy;
    private TransportOptions transportOptions;
    private StorageOptions.Builder storageOptions = StorageOptions.newBuilder();

    public StorageRetryStrategy getStorageRetryStrategy() {
        return this.storageRetryStrategy;
    }

    public void setStorageRetryStrategy(StorageRetryStrategy storageRetryStrategy) {
        this.storageRetryStrategy = storageRetryStrategy;
        this.storageOptions.setStorageRetryStrategy(storageRetryStrategy);
    }

    public TransportOptions getTransportOptions() {
        return this.transportOptions;
    }

    public void setTransportOptions(TransportOptions TransportOptionsVal) {
        this.storageOptions.setTransportOptions(TransportOptionsVal);
    }

    public void setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        this.storageOptions.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers));
    }

    public void setRetrySettings(RetrySettingsBuilder retrySettings) {
        super.setRetrySettings(retrySettings);
        this.storageOptions.setRetrySettings(ConfigUtil.buildRetrySettings(retrySettings));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.storageOptions.setHost(host);
    }

    public StorageOptions.Builder getStorageOptions() {
        return this.storageOptions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StorageConfigBuilder that = (StorageConfigBuilder)((Object)obj);
        return Objects.equals(this.getStorageRetryStrategy(), that.getStorageRetryStrategy()) && Objects.equals(this.getTransportOptions(), that.getTransportOptions()) && Objects.equals(this.getStorageOptions(), that.getStorageOptions()) && Objects.equals(this.getHost(), that.getHost());
    }

    public int hashCode() {
        return Objects.hash(this.getHost(), this.getStorageOptions(), this.getTransportOptions(), this.getStorageRetryStrategy());
    }
}

