/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFPositiveIntegerValidator;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.filter.FusionContext;
import coldfusion.gcp.storage.consumer.BlobInfoConsumer;
import coldfusion.gcp.storage.consumer.BlobWriteOptionConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.request.BlobWriteOptionBuilder;
import coldfusion.gcp.storage.request.UploadFileRequest;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UploadFileRequestConsumer
extends ConsumerMap<UploadFileRequest> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static UploadFileRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadFileRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<UploadFileRequestConsumer> clazz = UploadFileRequestConsumer.class;
        synchronized (UploadFileRequestConsumer.class) {
            if (instance != null) return instance;
            instance = new UploadFileRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UploadFileRequestConsumer() {
        this.put("srcfile", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"srcfile");
            String srcFile = Optional.ofNullable(FusionContext.getCurrent()).isPresent() && Optional.ofNullable(FusionContext.getCurrent().pageContext).isPresent() ? Utils.getFileFullPath((String)input, (PageContext)FusionContext.getCurrent().pageContext, (boolean)true) : input;
            File f = VFSFileFactory.getFileObject((String)srcFile);
            if (!f.isFile()) {
                throw new CFStorageException("File path is not valid : " + input);
            }
            uploadFileRequest.setSrcFile(srcFile);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("blobInfo", new ConsumerValidator((uploadFileRequest, value) -> {
            Map blobInfoReq = this.cast.getMapProperty(value);
            BlobInfo.Builder builder = BlobInfo.newBuilder((String)"", (String)"");
            ValidatorFiller.INSTANCE.fillObject((Object)builder, blobInfoReq, (ConsumerMap)BlobInfoConsumer.getInstance());
            BlobInfo blobInfo = builder.build();
            uploadFileRequest.setBlobInfo(blobInfo);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("bufferSize", new ConsumerValidator((uploadFileRequest, value) -> {
            int bufferSize = this.cast.getIntegerProperty(value);
            uploadFileRequest.setBufferSize(bufferSize);
        }, Collections.singletonList(new CFPositiveIntegerValidator("bufferSize"))));
        this.put("blobWriteOption", new ConsumerValidator((uploadFileRequest, value) -> {
            List obj = this.cast.getListProperty(value);
            ArrayList<Storage.BlobWriteOption> list = new ArrayList<Storage.BlobWriteOption>();
            for (int i = 0; i < obj.size(); ++i) {
                Map storageBlobWriteOpt = this.cast.getStringObjectMapProperty(obj.get(i));
                BlobWriteOptionBuilder blobWriteOptionBuilder = new BlobWriteOptionBuilder();
                ValidatorFiller.INSTANCE.fillObject((Object)blobWriteOptionBuilder, storageBlobWriteOpt, (ConsumerMap)BlobWriteOptionConsumer.getInstance());
                list.addAll(blobWriteOptionBuilder.getBlobWriteOption());
            }
            uploadFileRequest.setBlobWriteOption(list);
        }, Collections.singletonList(new EmptyListValidator("blobWriteOption"))));
    }
}

