/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.gcp.storage.consumer.AclEntityRoleConsumer;
import coldfusion.gcp.storage.consumer.CorsConsumer;
import coldfusion.gcp.storage.consumer.IamConfigurationConsumer;
import coldfusion.gcp.storage.consumer.LifecycleRulesRequestConsumer;
import coldfusion.gcp.storage.consumer.LoggingConsumer;
import coldfusion.gcp.storage.request.AclEntityRoleRequest;
import coldfusion.gcp.storage.request.LifecycleRulesRequest;
import coldfusion.gcp.storage.util.Validator;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.Rpo;
import com.google.cloud.storage.StorageClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UpdateBucketInfoConsumer
extends ConsumerMap<BucketInfo.Builder> {
    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static UpdateBucketInfoConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateBucketInfoConsumer getInstance() {
        if (instance != null) return instance;
        Class<UpdateBucketInfoConsumer> clazz = UpdateBucketInfoConsumer.class;
        synchronized (UpdateBucketInfoConsumer.class) {
            instance = new UpdateBucketInfoConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UpdateBucketInfoConsumer() {
        this.put("enable", new ConsumerValidator((builder, value) -> {
            boolean versionEnabled = Validator.getBooleanProperty(value, "enable");
            builder.setVersioningEnabled(Boolean.valueOf(versionEnabled));
        }, Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((builder, value) -> {
            String storageClass = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)storageClass, (String)"storageClass");
            builder.setStorageClass(StorageClass.valueOfStrict((String)storageClass));
        }, Collections.emptyList()));
        this.put("indexPage", new ConsumerValidator((builder, value) -> {
            String indexPage = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)indexPage, (String)"indexPage");
            builder.setIndexPage(indexPage);
        }, Collections.emptyList()));
        this.put("notFoundPage", new ConsumerValidator((builder, value) -> {
            String notFoundPage = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)notFoundPage, (String)"notFoundPage");
            builder.setNotFoundPage(notFoundPage);
        }, Collections.emptyList()));
        this.put("requesterPays", new ConsumerValidator((builder, value) -> {
            boolean requesterPays = Validator.getBooleanProperty(value, "requesterPays");
            builder.setRequesterPays(Boolean.valueOf(requesterPays));
        }, Collections.emptyList()));
        this.put("defaultEventBasedHold", new ConsumerValidator((builder, value) -> {
            boolean defaultEventBasedHold = Validator.getBooleanProperty(value, "defaultEventBasedHold");
            builder.setDefaultEventBasedHold(Boolean.valueOf(defaultEventBasedHold));
        }, Collections.emptyList()));
        this.put("retentionPeriod", new ConsumerValidator((bucketInfoBuilder, value) -> {
            if (value == null) {
                bucketInfoBuilder.setRetentionPeriod(null);
            } else {
                Long retentionPeriod = this.cast.getLongProperty(value);
                bucketInfoBuilder.setRetentionPeriod(retentionPeriod);
            }
        }, Collections.emptyList()));
        this.put("rpo", new ConsumerValidator((builder, value) -> {
            String rpo = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)rpo, (String)"rpo");
            builder.setRpo(Rpo.valueOfStrict((String)rpo));
        }, Collections.emptyList()));
        this.put("defaultKmsKeyName", new ConsumerValidator((builder, value) -> {
            String defaultKmsKeyName = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)defaultKmsKeyName, (String)"defaultKmsKeyName");
            builder.setDefaultKmsKeyName(defaultKmsKeyName);
        }, Collections.emptyList()));
        this.put("labels", new ConsumerValidator((builder, value) -> {
            Map labelsMap = this.cast.getMapProperty(value);
            for (String key : labelsMap.keySet()) {
                String val = (String)labelsMap.get(key);
                ValidationUtil.validNonBlankString((String)key, (String)"labels");
                ValidationUtil.validNonEmptyString((String)val, (String)"labels");
            }
            builder.setLabels(labelsMap);
        }, Collections.emptyList()));
        this.put("cors", new ConsumerValidator((bucketInfoBuilder, value) -> {
            List list = this.cast.getListProperty(value);
            ArrayList<Cors> cors = new ArrayList<Cors>();
            Cors.Builder corsBuilder = Cors.newBuilder();
            for (int i = 0; i < list.size(); ++i) {
                Map map = this.cast.getStringObjectMapProperty(list.get(i));
                ValidatorFiller.INSTANCE.fillObject((Object)corsBuilder, map, (ConsumerMap)CorsConsumer.getInstance());
                cors.add(corsBuilder.build());
            }
            bucketInfoBuilder.setCors(cors);
        }, Collections.singletonList(new EmptyListValidator("cors"))));
        this.put("logging", new ConsumerValidator((builder, value) -> {
            BucketInfo.Logging.Builder loggingBuilder = BucketInfo.Logging.newBuilder();
            Map map = this.cast.getMapProperty(value);
            ValidatorFiller.INSTANCE.fillObject((Object)loggingBuilder, map, (ConsumerMap)new LoggingConsumer());
            builder.setLogging(loggingBuilder.build());
        }, Collections.emptyList()));
        this.put("iamConfiguration", new ConsumerValidator((builder, value) -> {
            BucketInfo.IamConfiguration.Builder iamConfigBuilder = BucketInfo.IamConfiguration.newBuilder();
            Map map = this.cast.getMapProperty(value);
            ValidatorFiller.INSTANCE.fillObject((Object)iamConfigBuilder, map, (ConsumerMap)IamConfigurationConsumer.getInstance());
            builder.setIamConfiguration(iamConfigBuilder.build());
        }, Collections.emptyList()));
        this.put("acl", new ConsumerValidator((builder, value) -> {
            AclEntityRoleRequest entityRequest = new AclEntityRoleRequest();
            List list = this.cast.getListProperty(value);
            ArrayList<Acl> acl = new ArrayList<Acl>();
            for (int i = 0; i < list.size(); ++i) {
                Map map = this.cast.getStringObjectMapProperty(list.get(i));
                ValidatorFiller.INSTANCE.fillObject((Object)entityRequest, map, (ConsumerMap)AclEntityRoleConsumer.getInstance());
                acl.add(Acl.of((Acl.Entity)entityRequest.getEntity(), (Acl.Role)entityRequest.getRole()));
            }
            builder.setAcl(acl);
        }, Collections.singletonList(new EmptyListValidator("acl"))));
        this.put("rules", new ConsumerValidator((builder, value) -> {
            LifecycleRulesRequest rulesRequest = new LifecycleRulesRequest();
            List list = this.cast.getListProperty(value);
            ArrayList<BucketInfo.LifecycleRule> rulesList = new ArrayList<BucketInfo.LifecycleRule>();
            for (int i = 0; i < list.size(); ++i) {
                Map map = this.cast.getStringObjectMapProperty(list.get(i));
                ValidatorFiller.INSTANCE.fillObject((Object)rulesRequest, map, (ConsumerMap)LifecycleRulesRequestConsumer.getInstance());
                rulesList.add(new BucketInfo.LifecycleRule(rulesRequest.getAction(), rulesRequest.getCondition()));
            }
            builder.setLifecycleRules(rulesList);
        }, Collections.singletonList(new EmptyListValidator("rules"))));
    }
}

