/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.consumer.AbstractCloudConfigConsumer;
import coldfusion.cloud.gcp.config.RetrySettingsBuilder;
import coldfusion.cloud.gcp.consumer.RetrySettingsBuilderConsumer;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.gcp.storage.consumer.TransportOptionsConsumer;
import coldfusion.gcp.storage.request.StorageConfigBuilder;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;

public class StorageConfigConsumer
extends AbstractCloudConfigConsumer<StorageConfigBuilder> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;
    public static StorageConfigConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StorageConfigConsumer getInstance() {
        if (instance != null) return instance;
        Class<StorageConfigConsumer> clazz = StorageConfigConsumer.class;
        synchronized (StorageConfigConsumer.class) {
            instance = new StorageConfigConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private StorageConfigConsumer() {
        this.put("storageRetryStrategy", new ConsumerValidator((builder, val) -> {
            String storageRetryStrategy = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)storageRetryStrategy, (String)"storageRetryStrategy");
            StorageRetryStrategy storageRetryStrategyVal = null;
            switch (storageRetryStrategy.toUpperCase()) {
                case "DEFAULT": {
                    storageRetryStrategyVal = StorageRetryStrategy.getDefaultStorageRetryStrategy();
                    break;
                }
                case "UNIFORM": {
                    storageRetryStrategyVal = StorageRetryStrategy.getUniformStorageRetryStrategy();
                    break;
                }
            }
            builder.setStorageRetryStrategy(storageRetryStrategyVal);
        }, Collections.emptyList()));
        this.put("host", new ConsumerValidator((builder, value) -> builder.setHost(this.cast.getStringProperty(value)), Collections.singletonList(NonEmptyStringValidator.INSTANCE)));
        this.put("transportOptions", new ConsumerValidator((builder, value) -> {
            Map transportVal = this.cast.getStringObjectMapProperty(value);
            HttpTransportOptions.Builder transportOptionsB = HttpTransportOptions.newBuilder();
            this.filler.fillObject((Object)transportOptionsB, transportVal, (ConsumerMap)TransportOptionsConsumer.getInstance());
            if (System.getSecurityManager() == null) {
                builder.setTransportOptions((TransportOptions)transportOptionsB.build());
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){
                    final /* synthetic */ StorageConfigBuilder val$builder;
                    final /* synthetic */ HttpTransportOptions.Builder val$transportOptionsB;
                    {
                        this.val$builder = storageConfigBuilder;
                        this.val$transportOptionsB = builder;
                    }

                    public Object run() {
                        this.val$builder.setTransportOptions((TransportOptions)this.val$transportOptionsB.build());
                        return null;
                    }
                });
            }
        }, Collections.emptyList()));
        this.put("headers", new ConsumerValidator((builder, value) -> builder.setHeaders(this.cast.getStringStringMapProperty(value)), Collections.emptyList()));
        this.put("retrySettings", new ConsumerValidator((builder, value) -> builder.setRetrySettings(this.populateRetrySettings(value)), Collections.emptyList()));
    }

    private RetrySettingsBuilder populateRetrySettings(Object settings) {
        RetrySettingsBuilder builder = new RetrySettingsBuilder();
        ValidatorFiller.INSTANCE.fillObject((Object)builder, (Map)settings, RetrySettingsBuilderConsumer.INSTANCE.getRetrySettingsMap());
        return builder;
    }
}

