/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.gcp.storage.request.StorageBlobSourceOptionBuilder;
import coldfusion.gcp.storage.util.Validator;
import java.util.Collections;

public class StorageBlobSourceOptionConsumer
extends ConsumerMap<StorageBlobSourceOptionBuilder> {
    private static final long serialVersionUID = 1L;
    private static StorageBlobSourceOptionConsumer instance;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StorageBlobSourceOptionConsumer getInstance() {
        if (instance != null) return instance;
        Class<StorageBlobSourceOptionConsumer> clazz = StorageBlobSourceOptionConsumer.class;
        synchronized (StorageBlobSourceOptionConsumer.class) {
            if (instance != null) return instance;
            instance = new StorageBlobSourceOptionConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private StorageBlobSourceOptionConsumer() {
        this.put("decryptionKey", new ConsumerValidator((blobSourceOptionBuilder, value) -> blobSourceOptionBuilder.setDecryptionKey(value), Collections.emptyList()));
        this.put("generationMatch", new ConsumerValidator((blobSourceOptionBuilder, value) -> blobSourceOptionBuilder.setGenerationMatch(value), Collections.emptyList()));
        this.put("generationNotMatch", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            Long generationNotMatch = this.cast.getLongProperty(value);
            blobSourceOptionBuilder.setGenerationNotMatch(generationNotMatch);
        }, Collections.emptyList()));
        this.put("metaGenerationMatch", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            Long metagenerationMatch = this.cast.getLongProperty(value);
            blobSourceOptionBuilder.setMetagenerationMatch(metagenerationMatch);
        }, Collections.emptyList()));
        this.put("metaGenerationNotMatch", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            Long metagenerationNotMatch = this.cast.getLongProperty(value);
            blobSourceOptionBuilder.setMetagenerationNotMatch(metagenerationNotMatch);
        }, Collections.emptyList()));
        this.put("shouldReturnRawInputStream", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            Boolean shouldReturnRawInputStream = Validator.getBooleanProperty(value, "shouldReturnRawInputStream");
            blobSourceOptionBuilder.setShouldReturnRawInputStream(shouldReturnRawInputStream);
        }, Collections.emptyList()));
        this.put("userProject", new ConsumerValidator((blobSourceOptionBuilder, value) -> {
            String userProject = this.cast.getStringProperty(value).trim();
            blobSourceOptionBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
    }
}

