/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.storage.consumer.IdentityRoleConsumer;
import coldfusion.gcp.storage.consumer.PolicyBindingsConsumer;
import coldfusion.gcp.storage.request.IdentityRoleBuilder;
import coldfusion.gcp.storage.util.StorageUtils;
import com.google.cloud.Binding;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PolicyConsumer
extends ConsumerMap<Policy.Builder> {
    private static final long serialVersionUID = 8649617507000983944L;
    private static PolicyConsumer instance;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolicyConsumer getInstance() {
        if (instance != null) return instance;
        Class<PolicyConsumer> clazz = PolicyConsumer.class;
        synchronized (PolicyConsumer.class) {
            instance = new PolicyConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PolicyConsumer() {
        this.put("addIdentity", new ConsumerValidator((builder, value) -> {
            Map map = this.cast.getStringObjectMapProperty(value);
            IdentityRoleBuilder irBuilder = new IdentityRoleBuilder();
            this.filler.fillObject((Object)irBuilder, map, (ConsumerMap)IdentityRoleConsumer.getInstance());
            Identity[] i = new Identity[irBuilder.getIdentity().size()];
            i = irBuilder.getIdentity().toArray(i);
            if (i.length == 1) {
                builder.addIdentity(irBuilder.getRole(), i[0], new Identity[0]);
            } else {
                Identity[] otherMembers = Arrays.copyOfRange(i, 1, i.length);
                builder.addIdentity(irBuilder.getRole(), i[0], otherMembers);
            }
        }, Collections.emptyList()));
        this.put("removeIdentity", new ConsumerValidator((builder, value) -> {
            Map map = this.cast.getStringObjectMapProperty(value);
            IdentityRoleBuilder irBuilder = new IdentityRoleBuilder();
            this.filler.fillObject((Object)irBuilder, map, (ConsumerMap)IdentityRoleConsumer.getInstance());
            Identity[] i = new Identity[irBuilder.getIdentity().size()];
            i = irBuilder.getIdentity().toArray(i);
            if (i.length == 1) {
                builder.removeIdentity(irBuilder.getRole(), i[0], new Identity[0]);
            } else {
                Identity[] otherMembers = Arrays.copyOfRange(i, 1, i.length);
                builder.removeIdentity(irBuilder.getRole(), i[0], otherMembers);
            }
        }, Collections.emptyList()));
        this.put("removeRole", new ConsumerValidator((builder, value) -> {
            String role = this.cast.getStringProperty(value);
            builder.removeRole(StorageUtils.getRole(role));
        }, Collections.emptyList()));
        this.put("bindings", new ConsumerValidator((builder, value) -> {
            List list = this.cast.getListProperty(value);
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            for (int i = 0; i < list.size(); ++i) {
                Object val = list.get(i);
                Map map = this.cast.getStringObjectMapProperty(val);
                Binding.Builder bindingBuilder = Binding.newBuilder();
                this.filler.fillObject((Object)bindingBuilder, map, (ConsumerMap)PolicyBindingsConsumer.getInstance());
                bindings.add(bindingBuilder.build());
            }
            builder.setBindings(bindings);
        }, Collections.emptyList()));
        this.put("etag", new ConsumerValidator((builder, value) -> {
            String eTag = this.cast.getStringProperty(value);
            builder.setEtag(eTag);
        }, Collections.emptyList()));
        this.put("version", new ConsumerValidator((builder, value) -> {
            Integer version = this.cast.getIntegerProperty(value);
            builder.setVersion(version.intValue());
        }, Collections.emptyList()));
    }
}

