/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NotNullValidator;
import com.google.cloud.storage.NotificationInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NotificationInfoConsumer
extends ConsumerMap<NotificationInfo.Builder> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static NotificationInfoConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotificationInfoConsumer getInstance() {
        if (instance != null) return instance;
        Class<NotificationInfo> clazz = NotificationInfo.class;
        synchronized (NotificationInfo.class) {
            instance = new NotificationInfoConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NotificationInfoConsumer() {
        this.put("customAttributes", new ConsumerValidator((builder, val) -> {
            Map customAttributes = this.cast.getStringStringMapProperty(val);
            builder.setCustomAttributes(customAttributes);
        }, Collections.emptyList()));
        this.put("etag", new ConsumerValidator((builder, val) -> {
            String etag = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)etag, (String)"etag");
            builder.setEtag(etag);
        }, Collections.emptyList()));
        this.put("eventTypes", new ConsumerValidator((builder, val) -> {
            List eventTypesStr = this.cast.getListProperty(val);
            List eventTypesList = null;
            NotificationInfo.EventType[] eventType = new NotificationInfo.EventType[eventTypesList.size()];
            for (int i = 0; i < eventTypesStr.size(); ++i) {
                String value = (String)eventTypesStr.get(i);
                eventTypesList.add(NotificationInfo.EventType.valueOf((String)value));
            }
            builder.setEventTypes(eventTypesList.toArray(eventType));
        }, Collections.singletonList(new EmptyListValidator("eventTypes"))));
        this.put("objectNamePrefix", new ConsumerValidator((builder, val) -> {
            String objectNamePrefix = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)objectNamePrefix, (String)"objectNamePrefix");
            builder.setObjectNamePrefix(objectNamePrefix);
        }, Collections.emptyList()));
        this.put("payLoadFormat", new ConsumerValidator((builder, val) -> {
            String payLoadFormat = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)payLoadFormat, (String)"payLoadFormat");
            builder.setPayloadFormat(NotificationInfo.PayloadFormat.valueOf((String)payLoadFormat));
        }, Collections.emptyList()));
        this.put("selfLink", new ConsumerValidator((builder, val) -> {
            String selfLink = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)selfLink, (String)"selfLink");
            builder.setSelfLink(selfLink);
        }, Collections.emptyList()));
        this.put("topic", new ConsumerValidator((builder, val) -> {
            String topic = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)topic, (String)"topic");
            builder.setTopic(topic);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

