/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.gcp.BucketReference;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.util.RB;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CorsConsumer
extends ConsumerMap<Cors.Builder> {
    private static final long serialVersionUID = -7995789578197597547L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static CorsConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CorsConsumer getInstance() {
        if (instance != null) return instance;
        Class<CorsConsumer> clazz = CorsConsumer.class;
        synchronized (CorsConsumer.class) {
            instance = new CorsConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CorsConsumer() {
        this.put("methods", new ConsumerValidator((corsBuilder, value) -> {
            HashSet<HttpMethod> validHttpValues = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.values()));
            try {
                List methodsList = this.cast.getStringListProperty(value);
                ArrayList<HttpMethod> val = new ArrayList<HttpMethod>();
                for (String httpMethod : methodsList) {
                    HttpMethod method = HttpMethod.valueOfStrict((String)httpMethod);
                    if (!validHttpValues.contains(method)) {
                        throw new CFStorageException(RB.getString(BucketReference.class, (String)"INVALID_VALUE_LIST", (Object)httpMethod, validHttpValues));
                    }
                    val.add(method);
                }
                corsBuilder.setMethods(val);
            }
            catch (ClassCastException ex) {
                throw new FieldValidationFailedException(RB.getString(BucketReference.class, (String)"INVALID_LIST", (Object)"methods", validHttpValues), (Throwable)ex);
            }
        }, Collections.singletonList(new EmptyListValidator("methods"))));
        this.put("origins", new ConsumerValidator((corsBuilder, value) -> {
            List or = this.cast.getListProperty(value);
            corsBuilder.setOrigins((Iterable)or);
        }, Collections.singletonList(new EmptyListValidator("origins"))));
        this.put("responseHeader", new ConsumerValidator((corsBuilder, value) -> {
            List responseHeaders = this.cast.getListProperty(value);
            corsBuilder.setResponseHeaders((Iterable)responseHeaders);
        }, Collections.singletonList(new EmptyListValidator("responseHeader"))));
        this.put("maxAgeSeconds", new ConsumerValidator((corsBuilder, value) -> {
            Integer maxAgeSeconds = this.cast.getIntegerProperty(value);
            corsBuilder.setMaxAgeSeconds(maxAgeSeconds);
        }, Collections.emptyList()));
    }
}

