/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.gcp.storage.consumer.BlobIdBuilderConsumer;
import coldfusion.gcp.storage.consumer.StorageBlobSourceOptionConsumer;
import coldfusion.gcp.storage.consumer.TargetOptionConsumer;
import coldfusion.gcp.storage.request.BlobIdBuilder;
import coldfusion.gcp.storage.request.StorageBlobSourceOptionBuilder;
import coldfusion.gcp.storage.request.TargetOptionBuilder;
import com.google.cloud.storage.Storage;
import java.util.Collections;
import java.util.Map;

public class CopyRequestConsumer
extends ConsumerMap<Storage.CopyRequest.Builder> {
    private static final long serialVersionUID = 1L;
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static CopyRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CopyRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<CopyRequestConsumer> clazz = CopyRequestConsumer.class;
        synchronized (CopyRequestConsumer.class) {
            if (instance != null) return instance;
            instance = new CopyRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CopyRequestConsumer() {
        this.put("megabytesCopiedPerChunk", new ConsumerValidator((copyRequestBuilder, val) -> {
            Long megabytesCopiedPerChunk = this.cast.getLongProperty(val);
            copyRequestBuilder.setMegabytesCopiedPerChunk(megabytesCopiedPerChunk);
        }, Collections.emptyList()));
        this.put("source", new ConsumerValidator((copyRequestBuilder, val) -> {
            Map map = this.cast.getStringObjectMapProperty(val);
            BlobIdBuilder blobIdBuilder = new BlobIdBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)blobIdBuilder, map, (ConsumerMap)BlobIdBuilderConsumer.getInstance());
            copyRequestBuilder.setSource(blobIdBuilder.getBlobId());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("sourceOptions", new ConsumerValidator((copyRequestBuilder, val) -> {
            Map storageBlobsourceOpt = this.cast.getStringObjectMapProperty(val);
            StorageBlobSourceOptionBuilder blobSourceOptionBuilder = new StorageBlobSourceOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)blobSourceOptionBuilder, storageBlobsourceOpt, (ConsumerMap)StorageBlobSourceOptionConsumer.getInstance());
            copyRequestBuilder.setSourceOptions(blobSourceOptionBuilder.getBlobSourceOptions());
        }, Collections.emptyList()));
        this.put("target", new ConsumerValidator((copyRequestBuilder, val) -> {
            Map map = this.cast.getStringObjectMapProperty(val);
            TargetOptionBuilder builder = new TargetOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, map, (ConsumerMap)TargetOptionConsumer.getInstance());
            copyRequestBuilder.setTarget(builder.getTarget(), builder.getBlobTargetOption());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
    }
}

