/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.SerializationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.RootReference;
import coldfusion.gcp.StorageServiceImpl;
import coldfusion.gcp.storage.cfnotification.StorageNotification;
import coldfusion.gcp.storage.consumer.BlobListOptionConsumer;
import coldfusion.gcp.storage.consumer.BlobSourceOptionConsumer;
import coldfusion.gcp.storage.consumer.ComposeObjectConsumer;
import coldfusion.gcp.storage.consumer.CopyRequestConsumer;
import coldfusion.gcp.storage.consumer.DeleteBlobRequestConsumer;
import coldfusion.gcp.storage.consumer.DownloadObjectConsumer;
import coldfusion.gcp.storage.consumer.LifecyleConsumer;
import coldfusion.gcp.storage.consumer.ObjectMetadataConsumer;
import coldfusion.gcp.storage.consumer.PolicyConsumer;
import coldfusion.gcp.storage.consumer.SignUrlOptionConsumer;
import coldfusion.gcp.storage.consumer.StorageBucketOptionConsumer;
import coldfusion.gcp.storage.consumer.StorageBucketSourceOptionConsumer;
import coldfusion.gcp.storage.consumer.UpdateBlobConsumer;
import coldfusion.gcp.storage.consumer.UpdateBucketConsumer;
import coldfusion.gcp.storage.consumer.UploadFileRequestConsumer;
import coldfusion.gcp.storage.consumer.UploadObjectConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.pmt.util.GCPStorageApis;
import coldfusion.gcp.storage.pmt.util.PMTUtilForGCPStorage;
import coldfusion.gcp.storage.request.BlobSourceOptionBuilder;
import coldfusion.gcp.storage.request.DeleteBlobRequest;
import coldfusion.gcp.storage.request.DownloadObjectBuilder;
import coldfusion.gcp.storage.request.LifecycleBuilder;
import coldfusion.gcp.storage.request.ListBlobRequest;
import coldfusion.gcp.storage.request.ObjectMetadataBuilder;
import coldfusion.gcp.storage.request.SignUrlOptionBuilder;
import coldfusion.gcp.storage.request.StorageBucketOptionBuilder;
import coldfusion.gcp.storage.request.StorageBucketSourceOptionBuilder;
import coldfusion.gcp.storage.request.UpdateBlobBuilder;
import coldfusion.gcp.storage.request.UpdateBucketBuilder;
import coldfusion.gcp.storage.request.UploadFileRequest;
import coldfusion.gcp.storage.request.UploadObjectBuilder;
import coldfusion.gcp.storage.util.StorageUtils;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class BucketReference
implements RootReference {
    private Storage storageClient;
    private Logger logger = CFLogs.SERVER_LOG;
    private String bucketName;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.STORAGE.name());
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    BucketReference(StorageServiceImpl storageService, String bucketName) {
        this.bucketName = bucketName;
        this.storageClient = storageService.getStorageClient();
        this.tagAttributeList.addTagAttribute("bucket", (Object)bucketName);
    }

    @Override
    public Struct listAll() {
        return this.listAll(null);
    }

    @Override
    public Struct listAll(Map options) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.listAll, this.tagAttributeList);
        String status = "Success";
        Struct blobListResponse = new Struct();
        try {
            Page blobs;
            ListBlobRequest request = new ListBlobRequest();
            if (Objects.nonNull(options)) {
                this.filler.fillObject((Object)request, options, (ConsumerMap)BlobListOptionConsumer.getInstance());
                Storage.BlobListOption[] blobListOption = new Storage.BlobListOption[request.getBlobListOption().size()];
                blobs = this.storageClient.list(this.bucketName, request.getBlobListOption().toArray(blobListOption));
            } else {
                blobs = this.storageClient.list(this.bucketName, new Storage.BlobListOption[0]);
            }
            ArrayList<Struct> blobList = new ArrayList<Struct>();
            for (Blob blob : blobs.getValues()) {
                Struct blobStruct = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)blob);
                if (blobStruct.containsKey((Object)"options")) {
                    blobStruct.remove((Object)"options");
                }
                if (blobStruct.containsKey((Object)"createTime")) {
                    blobStruct.put((Object)"createTime", (Object)new OleDateTime(blob.getCreateTime().longValue()));
                }
                if (blobStruct.containsKey((Object)"updateTime")) {
                    blobStruct.put((Object)"updateTime", (Object)new OleDateTime(blob.getUpdateTime().longValue()));
                }
                if (blobStruct.containsKey((Object)"customTime")) {
                    blobStruct.put((Object)"customTime", (Object)new OleDateTime(blob.getCustomTime().longValue()));
                }
                if (blobStruct.containsKey((Object)"deleteTime")) {
                    blobStruct.put((Object)"deleteTime", (Object)new OleDateTime(blob.getDeleteTime().longValue()));
                }
                if (blobStruct.containsKey((Object)"rentetionExpirationTime")) {
                    blobStruct.put((Object)"rentetionExpirationTime", (Object)new OleDateTime(blob.getRetentionExpirationTime().longValue()));
                }
                if (blobStruct.containsKey((Object)"timeStorageClassUpdated")) {
                    blobStruct.put((Object)"timeStorageClassUpdated", (Object)new OleDateTime(blob.getTimeStorageClassUpdated().longValue()));
                }
                blobList.add(blobStruct);
            }
            if (blobs.getNextPageToken() != null) {
                blobListResponse.put((Object)"nextPageToken", (Object)blobs.getNextPageToken());
            }
            blobListResponse.put((Object)"response", blobList);
            blobListResponse.put((Object)"status", (Object)"Success");
            Struct struct = blobListResponse;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in Blob List : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in Blob List : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.listAll, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Struct setIamPolicy(Map policyRequest) {
        Struct bucketSourceOption = new Struct();
        return this.setIamPolicy(policyRequest, (Map)bucketSourceOption);
    }

    public Struct setIamPolicy(Map policyRequest, Map bucketSourceOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.setIamPolicy, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            StorageBucketSourceOptionBuilder bucketSourceOptionBuilder = new StorageBucketSourceOptionBuilder();
            this.filler.fillObject((Object)bucketSourceOptionBuilder, bucketSourceOption, StorageBucketSourceOptionConsumer.INSTANCE.getConsumerMap());
            Storage.BucketSourceOption[] bso = new Storage.BucketSourceOption[bucketSourceOptionBuilder.getBucketSourceOption().size()];
            Policy originalPolicy = this.storageClient.getIamPolicy(this.bucketName, bucketSourceOptionBuilder.getBucketSourceOption().toArray(bso));
            Policy.Builder policyBuilder = originalPolicy.toBuilder();
            this.filler.fillObject((Object)policyBuilder, policyRequest, (ConsumerMap)PolicyConsumer.getInstance());
            Policy updatedPolicy = this.storageClient.setIamPolicy(this.bucketName, policyBuilder.build(), bucketSourceOptionBuilder.getBucketSourceOption().toArray(bso));
            response.put((Object)"response", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)updatedPolicy));
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.setIamPolicy, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public Struct getIamPolicy() {
        Struct policyRequest = new Struct();
        return this.getIamPolicy((Map)policyRequest);
    }

    @Override
    public Struct getIamPolicy(Map policyRequest) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getIAMPolicy, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            StorageBucketSourceOptionBuilder bucketSourceOptionBuilder = new StorageBucketSourceOptionBuilder();
            this.filler.fillObject((Object)bucketSourceOptionBuilder, policyRequest, StorageBucketSourceOptionConsumer.INSTANCE.getConsumerMap());
            Storage.BucketSourceOption[] bucketSourceOption = new Storage.BucketSourceOption[bucketSourceOptionBuilder.getBucketSourceOption().size()];
            Policy policy = this.storageClient.getIamPolicy(this.bucketName, bucketSourceOptionBuilder.getBucketSourceOption().toArray(bucketSourceOption));
            response.put((Object)"response", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)policy));
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getIAMPolicy, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    @Override
    public Struct uploadFile(String srcFile, String key) {
        Struct blobWriteOption = new Struct();
        Struct blobId = new Struct();
        blobId.put((Object)"name", (Object)key);
        Struct blobInfo = new Struct();
        blobInfo.put((Object)"blobId", (Object)blobId);
        blobWriteOption.put((Object)"blobInfo", (Object)blobInfo);
        blobWriteOption.put((Object)"srcfile", (Object)srcFile);
        return this.uploadFile((Map)blobWriteOption);
    }

    @Override
    public Struct uploadFile(Map blobWriteOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.uploadFile, this.tagAttributeList);
        String status = "Success";
        String blob_name = "";
        Struct response = new Struct();
        try {
            Blob blob;
            StorageUtils.setBucketName(this.bucketName);
            UploadFileRequest uploadFileRequest = new UploadFileRequest();
            this.filler.fillObject((Object)uploadFileRequest, blobWriteOption, (ConsumerMap)UploadFileRequestConsumer.getInstance());
            blob_name = uploadFileRequest.getBlobInfo().getBlobId().getName();
            Storage.BlobWriteOption[] blobWrite = new Storage.BlobWriteOption[uploadFileRequest.getBlobWriteOption().size()];
            if (VFSFileFactory.checkIfVFile((String)uploadFileRequest.getSrcFile())) {
                blob = this.storageClient.createFrom(uploadFileRequest.getBlobInfo(), VFSFileFactory.getInputStream((String)uploadFileRequest.getSrcFile()), uploadFileRequest.getBufferSize(), uploadFileRequest.getBlobWriteOption().toArray(blobWrite));
            } else {
                File f = VFSFileFactory.getFileObject((String)uploadFileRequest.getSrcFile());
                blob = this.storageClient.createFrom(uploadFileRequest.getBlobInfo(), f.toPath(), uploadFileRequest.getBufferSize(), uploadFileRequest.getBlobWriteOption().toArray(blobWrite));
            }
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)blob);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
            response.put((Object)"status", (Object)"Success");
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.uploadFile, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status, blob_name));
        }
        return response;
    }

    @Override
    public Struct uploadObject(Map blobWriteOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.uploadObject, this.tagAttributeList);
        String status = "Success";
        String blobName = "";
        Struct response = new Struct();
        UploadObjectBuilder uploadObjectBuilder = new UploadObjectBuilder();
        try {
            StorageUtils.setBucketName(this.bucketName);
            this.filler.fillObject((Object)uploadObjectBuilder, blobWriteOption, (ConsumerMap)UploadObjectConsumer.getInstance());
            blobName = uploadObjectBuilder.getBlobInfo().getName();
            String serializedValue = SerializationUtil.Serialize((Object)uploadObjectBuilder.getObject(), (String)"JSON", (boolean)false);
            Storage.BlobWriteOption[] blobWrite = new Storage.BlobWriteOption[uploadObjectBuilder.getBlobWriteOption().size()];
            try (WriteChannel writer = this.storageClient.writer(uploadObjectBuilder.getBlobInfo(), uploadObjectBuilder.getBlobWriteOption().toArray(blobWrite));){
                writer.write(ByteBuffer.wrap(serializedValue.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new CFStorageException(e.getMessage(), e);
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (SerializationException | StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.uploadObject, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status, blobName));
        }
        return response;
    }

    @Override
    public Struct downloadObject(Map blobSourceOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.downloadObject, this.tagAttributeList);
        String status = "Success";
        String blobName = "";
        Struct response = new Struct();
        DownloadObjectBuilder downloadObjectBuilder = new DownloadObjectBuilder();
        try {
            StorageUtils.setBucketName(this.bucketName);
            this.filler.fillObject((Object)downloadObjectBuilder, blobSourceOption, (ConsumerMap)DownloadObjectConsumer.getInstance());
            blobName = downloadObjectBuilder.getblobInfo().getName();
            Storage.BlobSourceOption[] blobSource = new Storage.BlobSourceOption[downloadObjectBuilder.getBlobSourceOptionList().size()];
            byte[] content = this.storageClient.readAllBytes(this.bucketName, blobName, downloadObjectBuilder.getBlobSourceOptionList().toArray(blobSource));
            Object deSerializedObj = SerializationUtil.Deserialize((String)new String(content, StandardCharsets.UTF_8), (String)"JSON", (boolean)false);
            response.put((Object)"object", deSerializedObj);
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (SerializationException | StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.downloadObject, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status, blobName));
        }
    }

    @Override
    public Struct downloadToFile(String destFilePath, String key) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.downloadToFile, this.tagAttributeList);
        Struct blobSourceOption = new Struct();
        blobSourceOption.put((Object)"key", (Object)key);
        blobSourceOption.put((Object)"destinationFilePath", (Object)destFilePath);
        PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.downloadToFile, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", "Success", key));
        return this.downloadToFile((Map)blobSourceOption);
    }

    @Override
    public Struct downloadToFile(Map blobSourceOptionReq) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.downloadToFile, this.tagAttributeList);
        String status = "Success";
        String blobName = "";
        Struct response = new Struct();
        BlobSourceOptionBuilder blobSourceOptionBuilder = new BlobSourceOptionBuilder();
        Optional<Object> backupFile = Optional.empty();
        try {
            this.filler.fillObject((Object)blobSourceOptionBuilder, blobSourceOptionReq, (ConsumerMap)BlobSourceOptionConsumer.getInstance());
            Storage.BlobSourceOption[] blobSourceOption = new Storage.BlobSourceOption[blobSourceOptionBuilder.getBlobSourceOption().size()];
            blobName = blobSourceOptionBuilder.getBlobName();
            File destFile = VFSFileFactory.getFileObject((String)blobSourceOptionBuilder.getDestinationFilePath());
            backupFile = this.backupDestinationFile(destFile);
            BlobId bid = BlobId.of((String)this.bucketName, (String)blobName);
            if (VFSFileFactory.checkIfVFile((String)blobSourceOptionBuilder.getDestinationFilePath())) {
                this.storageClient.downloadTo(bid, VFSFileFactory.getOutputStream((String)blobSourceOptionBuilder.getDestinationFilePath(), (boolean)false), blobSourceOptionBuilder.getBlobSourceOption().toArray(blobSourceOption));
            } else {
                this.storageClient.downloadTo(bid, Paths.get(blobSourceOptionBuilder.getDestinationFilePath(), new String[0]), blobSourceOptionBuilder.getBlobSourceOption().toArray(blobSourceOption));
            }
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"response", (Object)RB.getString(BucketReference.class, (String)"DOWNLOAD_TO_FILE", (Object)blobName, (Object)this.bucketName, (Object)blobSourceOptionBuilder.getDestinationFilePath()));
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.downloadToFile, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status, blobName));
        }
    }

    private Optional<File> backupDestinationFile(File destinationFile) throws IOException {
        if (!destinationFile.exists()) {
            return Optional.empty();
        }
        long currentTimeStamp = System.currentTimeMillis();
        this.logger.info((Object)("taking backup for file : " + destinationFile.getAbsolutePath()));
        String backupFileName = destinationFile.getName() + currentTimeStamp + ".bak";
        File backupFile = VFSFileFactory.getFileObject((String)(destinationFile.getParent() + "\\" + backupFileName));
        while (backupFile.exists()) {
            backupFileName = destinationFile.getName() + currentTimeStamp + ".bak";
            backupFile = VFSFileFactory.getFileObject((String)(destinationFile.getParent() + "\\" + backupFileName));
        }
        FileUtils.copyFile((File)destinationFile, (String)backupFileName);
        destinationFile.delete();
        return Optional.ofNullable(backupFile);
    }

    public Struct ComposeObject(Map composeRequest) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.ComposeObject, this.tagAttributeList);
        String status = "Success";
        Struct composeResp = new Struct();
        try {
            StorageUtils.setBucketName(this.bucketName);
            Storage.ComposeRequest.Builder composeReq = Storage.ComposeRequest.newBuilder();
            this.filler.fillObject((Object)composeReq, composeRequest, (ConsumerMap)ComposeObjectConsumer.getInstance());
            Storage.ComposeRequest com = composeReq.build();
            Blob compositeObject = this.storageClient.compose(com);
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)compositeObject);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            composeResp.put((Object)"response", (Object)res);
            composeResp.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.ComposeObject, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap(null, status));
        }
        return composeResp;
    }

    @Override
    public Struct delete(Object blob) {
        if (blob instanceof Struct) {
            return this.delete((Struct)blob);
        }
        return this.delete(String.valueOf(blob));
    }

    private Struct delete(String blobName) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.delete, this.tagAttributeList);
        String status = "Success";
        Struct resp = new Struct();
        try {
            this.isKeyExist(blobName);
            boolean deleted = this.storageClient.delete(this.bucketName, blobName, new Storage.BlobSourceOption[0]);
            if (deleted) {
                resp.put((Object)"status", (Object)"Success");
            } else {
                resp.put((Object)"status", (Object)"Failure");
            }
        }
        catch (StorageException e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.delete, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status, blobName));
        }
        return resp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Struct delete(Struct blobOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.delete, this.tagAttributeList);
        String status = "Success";
        String blob_name = null;
        Struct resp = new Struct();
        try {
            StorageUtils.setBucketName(this.bucketName);
            DeleteBlobRequest request = new DeleteBlobRequest();
            this.filler.fillObject((Object)request, (Map)blobOption, (ConsumerMap)DeleteBlobRequestConsumer.getInstance());
            blob_name = request.getBlobId().getName();
            Storage.BlobSourceOption[] blobSourceOption = new Storage.BlobSourceOption[request.getBlobSourceOption().size()];
            boolean deleteStatus = this.storageClient.delete(request.getBlobId(), request.getBlobSourceOption().toArray(blobSourceOption));
            if (deleteStatus) {
                resp.put((Object)"status", (Object)"Success");
            } else {
                StorageUtils.getBlob(this.storageClient, blob_name, request.getUserProject());
                resp.put((Object)"status", (Object)"Failure");
            }
        }
        catch (StorageException e) {
            try {
                this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
                status = "Failure";
                throw new CFStorageException(e.getMessage(), e);
                catch (Exception e2) {
                    this.logger.error((Object)"Error occurred in delete : ", (Throwable)e2);
                    status = "Failure";
                    throw new CFStorageException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.delete, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status, blob_name));
                throw throwable;
            }
        }
        PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.delete, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status, blob_name));
        return resp;
    }

    @Override
    public Struct copy(Map copyRequest) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.copy, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        StorageUtils.setBucketName(this.bucketName);
        Storage.CopyRequest.Builder copyRequestBuilder = Storage.CopyRequest.newBuilder();
        try {
            Map map = this.cast.getStringObjectMapProperty((Object)copyRequest);
            this.filler.fillObject((Object)copyRequestBuilder, map, (ConsumerMap)CopyRequestConsumer.getInstance());
            Storage.CopyRequest request = copyRequestBuilder.build();
            Blob blob = this.storageClient.copy(request).getResult();
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)blob);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.copy, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public Struct getLocation() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getLocation, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[]{Storage.BucketGetOption.fields((Storage.BucketField[])Storage.BucketField.values())});
            response.put((Object)"location", (Object)bucket.getLocation());
            response.put((Object)"locationType", (Object)bucket.getLocationType());
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getLocation, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
    }

    public Struct enableVersioning() {
        Struct response = new Struct();
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.enableVersioning, this.tagAttributeList);
        String status = "Success";
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            bucket.toBuilder().setVersioningEnabled(Boolean.valueOf(true)).build().update(new Storage.BucketTargetOption[0]);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.enableVersioning, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public Struct suspendVersioning() {
        Struct response = new Struct();
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.suspendVersioning, this.tagAttributeList);
        String status = "Success";
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            bucket.toBuilder().setVersioningEnabled(Boolean.valueOf(false)).build().update(new Storage.BucketTargetOption[0]);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.suspendVersioning, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public Struct getVersioningStatus() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getVersioningStatus, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        boolean version = false;
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            if (bucket.versioningEnabled() != null) {
                version = bucket.versioningEnabled();
            }
            response.put((Object)"versioningEnabled", (Object)version);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getVersioningStatus, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public Struct enableRequesterPay(Map bucketOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.enableRequesterPay, this.tagAttributeList);
        Struct response = new Struct();
        String status = "Success";
        try {
            StorageBucketOptionBuilder bucketOptionBuilder = new StorageBucketOptionBuilder();
            this.filler.fillObject((Object)bucketOptionBuilder, bucketOption, StorageBucketOptionConsumer.INSTANCE.getConsumerMap());
            Bucket bucket = null;
            bucket = bucketOptionBuilder.getBucketGetOption() != null ? this.storageClient.get(this.bucketName, bucketOptionBuilder.getBucketGetOption()) : this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            if (bucketOptionBuilder.getBucketTargetOption() != null) {
                bucket.toBuilder().setRequesterPays(Boolean.valueOf(true)).build().update(bucketOptionBuilder.getBucketTargetOption());
            } else {
                bucket.toBuilder().setRequesterPays(Boolean.valueOf(true)).build().update(new Storage.BucketTargetOption[0]);
            }
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"requesterPays", (Object)bucket.requesterPays());
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in enableRequesterPay : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"enableRequesterPayError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.enableRequesterPay, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public Struct disableRequesterPay(Map bucketOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.disableRequesterPay, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            StorageBucketOptionBuilder bucketOptionBuilder = new StorageBucketOptionBuilder();
            this.filler.fillObject((Object)bucketOptionBuilder, bucketOption, StorageBucketOptionConsumer.INSTANCE.getConsumerMap());
            Bucket bucket = null;
            bucket = bucketOptionBuilder.getBucketGetOption() != null ? this.storageClient.get(this.bucketName, bucketOptionBuilder.getBucketGetOption()) : this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            if (bucketOptionBuilder.getBucketTargetOption() == null) {
                throw new CFStorageException(RB.getString(BucketReference.class, (String)"DISABLE_REQUESTER_PAYS"));
            }
            bucket.toBuilder().setRequesterPays(Boolean.valueOf(false)).build().update(bucketOptionBuilder.getBucketTargetOption());
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"requesterPays", (Object)bucket.requesterPays());
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)RB.getString(BucketReference.class, (String)"DISABLE_REQUESTER_PAYS"), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"DISABLE_REQUESTER_PAYS"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.disableRequesterPay, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public Struct getRequesterPayStatus(Map bucketOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getRequesterPayStatus, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            StorageBucketOptionBuilder bucketOptionBuilder = new StorageBucketOptionBuilder();
            this.filler.fillObject((Object)bucketOptionBuilder, bucketOption, StorageBucketOptionConsumer.INSTANCE.getConsumerMap());
            Bucket bucket = null;
            bucket = bucketOptionBuilder.getBucketGetOption() != null ? this.storageClient.get(this.bucketName, bucketOptionBuilder.getBucketGetOption()) : this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"requesterPays", (Object)bucket.requesterPays());
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)RB.getString(BucketReference.class, (String)"GET_REQUESTER_PAYS"), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"getRequesterPayStatus"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getRequesterPayStatus, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
    }

    public Struct setRules(Map setRulesRequest) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.setRules, this.tagAttributeList);
        String status = "Success";
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            LifecycleBuilder rulesBuilder = new LifecycleBuilder();
            this.filler.fillObject((Object)rulesBuilder, setRulesRequest, (ConsumerMap)LifecyleConsumer.getInstance());
            Storage.BucketTargetOption[] option = new Storage.BucketTargetOption[rulesBuilder.getBucketTargetOption().size()];
            bucket.toBuilder().setLifecycleRules(rulesBuilder.getLifecycleRule()).build().update(rulesBuilder.getBucketTargetOption().toArray(option));
            Struct struct = this.getRules();
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in delete Rules : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"setRulesError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.setRules, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
    }

    public Struct deleteRules() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.deleteRules, this.tagAttributeList);
        Struct response = new Struct();
        String status = "Success";
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            bucket.toBuilder().deleteLifecycleRules().build().update(new Storage.BucketTargetOption[0]);
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in delete Rules : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"deleteRulesError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.deleteRules, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status));
        }
    }

    public Struct getRules() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getRules, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            ArrayList<Struct> list = new ArrayList<Struct>();
            if (bucket.getLifecycleRules() != null) {
                for (BucketInfo.LifecycleRule rule : bucket.getLifecycleRules()) {
                    Struct actionCondition = new Struct();
                    actionCondition.put((Object)"action", (Object)rule.getAction().getActionType().toString());
                    Struct conditionRule = new Struct();
                    if (rule.getCondition().getIsLive() != null) {
                        conditionRule.put((Object)"IsLive", (Object)rule.getCondition().getIsLive());
                    }
                    if (rule.getCondition().getAge() != null) {
                        conditionRule.put((Object)"age", (Object)rule.getCondition().getAge().toString());
                    }
                    if (rule.getCondition().getCreatedBefore() != null) {
                        conditionRule.put((Object)"createdBefore", (Object)rule.getCondition().getCreatedBefore().toString());
                    }
                    if (rule.getCondition().getCustomTimeBefore() != null) {
                        conditionRule.put((Object)"customTimeBefore", (Object)rule.getCondition().getCustomTimeBefore().toString());
                    }
                    if (rule.getCondition().getDaysSinceCustomTime() != null) {
                        conditionRule.put((Object)"daysSinceCustomTime", (Object)rule.getCondition().getDaysSinceCustomTime().toString());
                    }
                    if (rule.getCondition().getDaysSinceNoncurrentTime() != null) {
                        conditionRule.put((Object)"daysSinceNoncurrentTime", (Object)rule.getCondition().getDaysSinceNoncurrentTime().toString());
                    }
                    if (rule.getCondition().getMatchesPrefix() != null) {
                        conditionRule.put((Object)"matchesPrefix", (Object)rule.getCondition().getMatchesPrefix().toString());
                    }
                    if (rule.getCondition().getMatchesStorageClass() != null) {
                        conditionRule.put((Object)"matchesStorageClass", (Object)rule.getCondition().getMatchesStorageClass().toString());
                    }
                    if (rule.getCondition().getMatchesSuffix() != null) {
                        conditionRule.put((Object)"matchesSuffix", (Object)rule.getCondition().getMatchesSuffix().toString());
                    }
                    if (rule.getCondition().getNoncurrentTimeBefore() != null) {
                        conditionRule.put((Object)"noncurrentTimeBefore", (Object)rule.getCondition().getNoncurrentTimeBefore().toString());
                    }
                    if (rule.getCondition().getNumberOfNewerVersions() != null) {
                        conditionRule.put((Object)"numberOfNewerVersions", (Object)rule.getCondition().getNumberOfNewerVersions().toString());
                    }
                    actionCondition.put((Object)"condition", (Object)conditionRule);
                    list.add(actionCondition);
                }
            }
            response.put((Object)"rules", list);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in get Rules : ", (Throwable)e);
            status = "Failure";
            throw new CFStorageException(RB.getString(BucketReference.class, (String)"getRulesError"), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getRules, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public Struct addTags(Map objectMetadata) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.addTags, this.tagAttributeList);
        Struct response = new Struct();
        String status = "Success";
        try {
            ObjectMetadataBuilder metadataBuilder = new ObjectMetadataBuilder();
            Map map = this.cast.getMapProperty((Object)objectMetadata);
            this.filler.fillObject((Object)metadataBuilder, map, (ConsumerMap)ObjectMetadataConsumer.getInstance());
            this.isKeyExist(metadataBuilder.getObjectName());
            Blob blob = this.storageClient.get(this.bucketName, metadataBuilder.getObjectName(), new Storage.BlobGetOption[0]);
            blob.toBuilder().setMetadata(metadataBuilder.getMetadata()).build().update(new Storage.BlobTargetOption[0]);
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.addTags, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
    }

    public Struct updateObject(Map blobInfo) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.updateObject, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            StorageUtils.setBucketName(this.bucketName);
            UpdateBlobBuilder updateBlobBuilder = new UpdateBlobBuilder();
            this.filler.fillObject((Object)updateBlobBuilder, blobInfo, (ConsumerMap)UpdateBlobConsumer.getInstance());
            Storage.BlobTargetOption[] bto = new Storage.BlobTargetOption[updateBlobBuilder.getBlobTargetOption().size()];
            Blob blob = this.storageClient.update(updateBlobBuilder.getBlobInfo(), updateBlobBuilder.getBlobTargetOption().toArray(bto));
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)blob);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.updateObject, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
    }

    public Struct updateBucket(Map bucketInfo) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.updateBucket, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            StorageUtils.setBucketName(this.bucketName);
            BucketInfo.Builder bucketInfoBuilder = BucketInfo.newBuilder((String)this.bucketName);
            UpdateBucketBuilder updateBucketBuilder = new UpdateBucketBuilder();
            this.filler.fillObject((Object)updateBucketBuilder, bucketInfo, (ConsumerMap)UpdateBucketConsumer.getInstance());
            Storage.BucketTargetOption[] bto = new Storage.BucketTargetOption[updateBucketBuilder.getBucketTargetOption().size()];
            Bucket bucket = this.storageClient.update(updateBucketBuilder.getBucketInfo(), updateBucketBuilder.getBucketTargetOption().toArray(bto));
            Struct res = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
            if (res.containsKey((Object)"options")) {
                res.remove((Object)"options");
            }
            response.put((Object)"response", (Object)res);
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.updateBucket, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
    }

    public Struct lockRetentionPolicy() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.lockRetentionPolicy, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[]{Storage.BucketGetOption.fields((Storage.BucketField[])new Storage.BucketField[]{Storage.BucketField.METAGENERATION})});
            Bucket lockedBucket = bucket.lockRetentionPolicy(new Storage.BucketTargetOption[]{Storage.BucketTargetOption.metagenerationMatch()});
            response.put((Object)"message", (Object)RB.getString(BucketReference.class, (String)"LOCK_RETENTION_POLICY_SUCCESS", (Object)this.bucketName));
            response.put((Object)"retentionEffectiveTime", (Object)new OleDateTime(lockedBucket.getRetentionEffectiveTime().longValue()));
            response.put((Object)"retentionPeriod", (Object)lockedBucket.getRetentionPeriod());
            response.put((Object)"retentionPolicyIsLocked", (Object)lockedBucket.retentionPolicyIsLocked());
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.lockRetentionPolicy, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public Struct listAllVersions() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.listAllVersions, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[0]);
            Page blobs = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.versions((boolean)true)});
            ArrayList<Struct> list = new ArrayList<Struct>();
            for (Blob blob : blobs.iterateAll()) {
                Struct objStruct = new Struct();
                objStruct.put((Object)"key", (Object)blob.getName());
                objStruct.put((Object)"generation", (Object)blob.getGeneration());
                objStruct.put((Object)"etag", (Object)blob.getEtag());
                objStruct.put((Object)"owner", (Object)blob.getOwner());
                objStruct.put((Object)"storageClass", (Object)blob.getStorageClass().name());
                list.add(objStruct);
            }
            response.put((Object)"response", list);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.listAllVersions, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public Struct getObjectDetails(Object blobGetOption) {
        if (blobGetOption instanceof Map) {
            return this.getObjectDetails(blobGetOption);
        }
        return this.getObjectDetails(String.valueOf(blobGetOption));
    }

    private Struct getObjectDetails(String key) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getObjectDetails, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            this.isKeyExist(key);
            Blob blob = this.storageClient.get(this.bucketName, key, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])Storage.BlobField.values())});
            response = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)blob);
            if (response.containsKey((Object)"options")) {
                response.remove((Object)"options");
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getObjectDetails, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status, key));
        }
        return response;
    }

    public Struct getObjectMetadata(String key) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getObjectMetadata, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            this.isKeyExist(key);
            Blob blob = this.storageClient.get(this.bucketName, key, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])Storage.BlobField.values())});
            if (blob.getMetadata() != null) {
                Struct metadata = new Struct();
                metadata.putAll(blob.getMetadata());
                response.put((Object)"customMetadata", (Object)metadata);
            }
            response.put((Object)"key", (Object)key);
            response.put((Object)"contentType", (Object)blob.getContentType());
            response.put((Object)"contentEncoding", (Object)blob.getContentEncoding());
            response.put((Object)"contentDisposition", (Object)blob.getContentDisposition());
            response.put((Object)"cacheControl", (Object)blob.getCacheControl());
            response.put((Object)"contentLanguage", (Object)blob.getContentLanguage());
            response.put((Object)"updateTime", (Object)new OleDateTime(blob.getUpdateTime().longValue()));
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getObjectMetadata, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status, key));
        }
        return response;
    }

    public Struct getBucketMetadata() {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getBucketMetadata, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            Bucket bucket = this.storageClient.get(this.bucketName, new Storage.BucketGetOption[]{Storage.BucketGetOption.fields((Storage.BucketField[])Storage.BucketField.values())});
            response = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)bucket);
            if (response.containsKey((Object)"options")) {
                response.remove((Object)"options");
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getBucketMetadata, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public Struct signUrl(Map signUrlOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.signUrl, this.tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            SignUrlOptionBuilder builder = new SignUrlOptionBuilder();
            this.filler.fillObject((Object)builder, signUrlOption, (ConsumerMap)SignUrlOptionConsumer.getInstance());
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)builder.getObjectName())).build();
            Storage.SignUrlOption[] signUrlOptionArr = new Storage.SignUrlOption[builder.getSignUrlOption().size()];
            URL url = this.storageClient.signUrl(blobInfo, builder.getDuration(), builder.getTimeunit(), builder.getSignUrlOption().toArray(signUrlOptionArr));
            response.put((Object)"url", (Object)url.toString());
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.signUrl, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public Struct createNotification(Map NotificationAttr) {
        return StorageNotification.createNotification(this.storageClient, this.bucketName, NotificationAttr);
    }

    public Struct getNotification(String notificationId) {
        return StorageNotification.getNotification(this.storageClient, this.bucketName, notificationId);
    }

    public Struct listNotifications() {
        return StorageNotification.listNotifications(this.storageClient, this.bucketName);
    }

    public Struct deleteNotification(String notificationId) {
        return StorageNotification.deleteNotification(this.storageClient, this.bucketName, notificationId);
    }

    private boolean isKeyExist(String blobName) {
        try {
            if (blobName.isEmpty()) {
                throw new CFStorageException(RB.getString(BucketReference.class, (String)"KEY_NULL_EMPTY"));
            }
            BlobId blobId = BlobId.of((String)this.bucketName, (String)blobName);
            Blob blob = this.storageClient.get(blobId);
            if (blob == null) {
                throw new CFStorageException(RB.getString(BucketReference.class, (String)"KEY_NOT_FOUND", (Object)blobName, (Object)this.bucketName));
            }
        }
        catch (StorageException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CFStorageException(e.getMessage(), e);
        }
        return true;
    }
}

