/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.CFDocument;
import coldfusion.document.DocumentMargin;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentWriter;
import coldfusion.document.spi.PageNoCallbackHandler;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class DocumentSection {
    private StormPrinter _stormPrinter = null;
    private StormPageFormat stormPageFormat = null;
    private DocumentProperties docProps;
    private int sectiontotalpagecount = 0;
    private StormBase base = null;
    private Viewport viewport = null;
    private String sectionName;
    private boolean bookmarksEnabled;
    private int shiftPageCount;
    private PageNoCallbackHandler pageNoCallbackHandler;

    DocumentSection(StormBase base, Viewport viewport, StormPrinter _stormPrinter, StormPageFormat stormPageFormat, DocumentProperties docProps) {
        this.base = base;
        this.viewport = viewport;
        this._stormPrinter = _stormPrinter;
        this.stormPageFormat = stormPageFormat;
        this.docProps = docProps;
    }

    DocumentSection(StormPrinter printer, StormPageFormat pageFormat, DocumentProperties docProps) {
        this(null, null, printer, pageFormat, docProps);
    }

    public void setDocumentSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public void setBookmarksEnabled(boolean enabled) {
        this.bookmarksEnabled = enabled;
    }

    public void shiftPageCount(int pdfFormPageCount) {
        this.shiftPageCount = pdfFormPageCount;
    }

    public void setPageNoCallbackHandler(PageNoCallbackHandler pcbh) {
        this.pageNoCallbackHandler = pcbh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() throws Exception {
        CFDocument document = this.docProps.getDocument();
        DocumentWriter writer = this.docProps.getWriter();
        if (this.shiftPageCount > 0) {
            document.setCurrentPageNumber(document.getCurrentPageNumber() + this.shiftPageCount);
        }
        document.setTotalSectionPageCount(this.sectiontotalpagecount);
        int pageIndex = document.getCurrentPageNumber();
        try {
            for (int j = 0; j < this._stormPrinter.getPageCount(); ++j) {
                if (pageIndex > 0) {
                    document.newPage();
                }
                document.setCurrentSectionPageNumber(j + 1);
                if (this.bookmarksEnabled && j == 0 && this.sectionName != null && this.sectionName.trim().length() > 0) {
                    writer.addBookmark(this.sectionName);
                }
                DocumentMargin margin = new DocumentMargin();
                margin.setTop(this.stormPageFormat.getMargin(1));
                margin.setBottom(this.stormPageFormat.getMargin(3));
                Graphics2D g = writer.createGraphics((float)this.stormPageFormat.getPageWidth(), (float)this.stormPageFormat.getPageHeight(), margin, this.docProps.isExternalLinksOn());
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                try {
                    this._stormPrinter.printPage((Graphics)g, j);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    writer.saveState();
                    g.dispose();
                    writer.flush();
                }
                document.setCurrentPageNumber(++pageIndex);
            }
        }
        finally {
            this._stormPrinter.dispose();
        }
    }

    public int getSectiontotalpagecount() {
        return this.sectiontotalpagecount;
    }

    void setSectiontotalpagecount(int sectiontotalpagecount) {
        this.sectiontotalpagecount = sectiontotalpagecount;
    }

    public void releaseStormBase() {
        if (this.base != null) {
            this.base.getViewportCallback().disposeTopLevelContainer(this.viewport);
            this.base.dispose();
            this.base = null;
        }
    }
}

