/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.CFContentLoader;
import coldfusion.document.ContentLoaderFactoryImpl;
import coldfusion.document.DocumentExporter;
import coldfusion.document.DocumentFrame;
import coldfusion.document.pdf.PdfDocumentWriter;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.DocumentWriter;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.PageNoCallbackHandler;
import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.log.CFLogs;
import coldfusion.util.Waiter;
import coldfusion.vfs.VFSFileFactory;
import com.icesoft.util.trackers.RenderDoneTracker;
import com.icesoft.util.trackers.RenderDoneTrackerListener;
import ice.net.Authentication;
import ice.net.AuthenticationEvent;
import ice.net.AuthenticationListener;
import ice.net.AuthenticationManager;
import ice.net.HttpURLConnection;
import ice.net.proxy.Proxy;
import ice.storm.ContentLoader;
import ice.storm.ContentLoaderFactory;
import ice.storm.HistoryEntry;
import ice.storm.HistoryManager;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DocumentProcessor {
    private StormBase _stormBase = null;
    private DocumentProperties docProps;
    private HeaderFooterContentProvider headerContentProvider;
    private PageNoCallbackHandler pageNoCallbackHandler;
    private DocumentSectionProperties docSectionProps;
    private Exporter exporter;
    private long requestTimeOut = 0L;
    private URLConnectionSettings connSettings;
    private Proxy proxy;
    private static ThreadLocal authenticationThreadLocal = new InheritableThreadLocal();
    private HeaderFooterContentProvider footerContentProvider;

    public DocumentProcessor() {
        this(new URLConnectionSettings());
    }

    public DocumentProcessor(URLConnectionSettings connSettings) {
        this.connSettings = connSettings;
        this._stormBase = new StormBase();
        HistoryManager historyManager = this._stormBase.getHistoryManager();
        this._stormBase.removePropertyChangeListener((PropertyChangeListener)historyManager, null);
        this._stormBase.setHistoryManager((HistoryManager)new DummyHistoryManager());
        this.exporter = new DocumentExporter();
        ContentLoaderFactoryImpl contentLoaderFactory = connSettings == null ? new ContentLoaderFactoryImpl() : new ContentLoaderFactoryImpl(connSettings);
        this.proxy = contentLoaderFactory.getProxy();
        this._stormBase.setContentLoaderFactory((ContentLoaderFactory)contentLoaderFactory);
    }

    public void setDocumentProperties(DocumentProperties docProps) {
        this.docProps = docProps;
    }

    public void setHeaderContentProvider(HeaderFooterContentProvider headerContentProvider) {
        this.headerContentProvider = headerContentProvider;
    }

    public void setFooterContentProvider(HeaderFooterContentProvider footerContentProvider) {
        this.footerContentProvider = footerContentProvider;
    }

    public void setPageNoCallbackHandler(PageNoCallbackHandler pageNoCallbackHandler) {
        this.pageNoCallbackHandler = pageNoCallbackHandler;
    }

    public void setDocSectionProps(DocumentSectionProperties docSectionProps) {
        this.docSectionProps = docSectionProps;
    }

    public void setExporter(Exporter exporter) {
        this.exporter = exporter;
    }

    public void setRequestTimeOut(long requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
    }

    public void processContent(String content, URL baseUrl, String charset, List sectionQueue) throws Exception {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(content.getBytes(charset));
        }
        catch (UnsupportedEncodingException ueex) {
            in = new ByteArrayInputStream(content.getBytes());
        }
        CFContentLoader cl = new CFContentLoader(baseUrl, in, "text/html; charset=" + charset, this.proxy, this.connSettings);
        this.processContent(cl, baseUrl, sectionQueue);
    }

    public void processContent(URL url, String charset, String mimeType, URL baseUrl, List sectionQueue) throws Exception {
        Object contentType = null;
        contentType = mimeType != null && charset != null ? mimeType + "; charset=" + charset : (charset != null ? "charset=" + charset : mimeType);
        CFContentLoader cl = new CFContentLoader(url, (String)contentType, this.proxy, this.connSettings);
        this.setUserAgent(cl);
        this.processContent(cl, baseUrl, sectionQueue);
    }

    private void setUserAgent(ContentLoader cl) {
        URLConnection uc = cl.getURLConnection();
        String userAgent = this.connSettings.getUserAgent();
        userAgent = userAgent == null ? "ColdFusion" : userAgent;
        uc.addRequestProperty("User-Agent", userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processContent(File file, String charset, String mimeType, URL baseUrl, List sectionQueue) throws Exception {
        try (InputStream in = null;){
            in = VFSFileFactory.getInputStream((String)file.getAbsolutePath());
            mimeType = mimeType == null ? "text/html" : mimeType;
            mimeType = (String)mimeType + "; charset=" + charset;
            CFContentLoader cl = new CFContentLoader(file.toURL(), in, (String)mimeType, this.proxy, this.connSettings);
            this.processContent(cl, baseUrl, sectionQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processContent(ContentLoader cl, URL baseUrl, List sectionQueue) throws TimeOutException, RenderException, Exception {
        block12: {
            try {
                Waiter taskwaiter = new Waiter();
                String id = "CFDOCUMENT" + Thread.currentThread().getName();
                DocumentViewportCallback dvc = new DocumentViewportCallback(taskwaiter);
                this._stormBase.setViewportCallback((ViewportCallback)dvc);
                this._stormBase.setComponentToolkitName("swing");
                AuthenticationData authData = null;
                if (this.connSettings.getAuthUserName() != null) {
                    authData = new AuthenticationData(this.connSettings.getAuthUserName(), this.connSettings.getAuthPassword(), dvc);
                    authenticationThreadLocal.set(authData);
                }
                try {
                    Object msg;
                    this._stormBase.renderContent(cl, id);
                    try {
                        msg = taskwaiter.getResponse(this.requestTimeOut);
                    }
                    catch (InterruptedException e) {
                        throw new TimeOutException(this.requestTimeOut);
                    }
                    if (msg == null) {
                        DocumentFrame frame = dvc.getBrowserPanel();
                        frame.setBaseURL(baseUrl);
                        frame.setDocumentProperties(this.docProps);
                        frame.setDocumentSectionProperties(this.docSectionProps);
                        frame.setHeaderContentProvider(this.headerContentProvider);
                        frame.setFooterContentProvider(this.footerContentProvider);
                        frame.setPageNoCallbackHandler(this.pageNoCallbackHandler);
                        frame.exportContent(this.exporter, sectionQueue);
                        if (sectionQueue == null) {
                            dvc.dispose();
                        }
                        break block12;
                    }
                    if (authData != null && authData.isAuthFailed()) {
                        throw new AuthenticationFailedException(authData.authFailedURL);
                    }
                    throw new RenderException(msg.toString());
                }
                catch (Exception ex) {
                    CFLogs.SERVER_LOG.error((Throwable)ex);
                    this._stormBase.stopLoading(dvc.getViewportName());
                    this._stormBase.suspend();
                    throw ex;
                }
            }
            finally {
                if (this._stormBase != null && sectionQueue == null) {
                    this._stormBase.dispose();
                    this._stormBase = null;
                }
                authenticationThreadLocal.set(null);
            }
        }
    }

    public List getLinks() throws Exception {
        DocumentWriter writer = this.docProps.getWriter();
        if (writer instanceof PdfDocumentWriter) {
            return ((PdfDocumentWriter)writer).getPdfWriter().getLinks();
        }
        return Collections.EMPTY_LIST;
    }

    static {
        AuthenticationManager authManager = new AuthenticationManager();
        authManager.addAuthenticationListener((AuthenticationListener)new IceAuthenticationListener());
        HttpURLConnection.setGlobalAuthenticationManager((AuthenticationManager)authManager);
    }

    private static class DummyHistoryManager
    implements HistoryManager {
        private DummyHistoryManager() {
        }

        public void setBackHistorySize(int i) {
        }

        public void setForwardHistorySize(int i) {
        }

        public int getBackHistorySize() {
            return 0;
        }

        public int getForwardHistorySize() {
            return 0;
        }

        public String[] getBackHistory(String string) {
            return null;
        }

        public String[] getForwardHistory(String string) {
            return null;
        }

        public HistoryEntry[] getBackEntries(String string) {
            return null;
        }

        public HistoryEntry[] getForwardEntries(String string) {
            return null;
        }

        public HistoryEntry addToForwardHistory(String string, String string1, int i) {
            return null;
        }

        public HistoryEntry addToBackHistory(String string, String string1, int i) {
            return null;
        }

        public String getCurrentLocation(String string) {
            return null;
        }

        public void reload(String string) {
        }

        public void goBack(String string) {
        }

        public void goBack(String string, int i) {
        }

        public void goForward(String string) {
        }

        public void goForward(String string, int i) {
        }

        public void goingSomewhere(ContentLoader contentLoader, String string) {
        }

        public boolean canGoBack(String string) {
            return false;
        }

        public boolean canGoForward(String string) {
            return false;
        }

        public void clearAllHistories() {
        }

        public void clearHistoryForViewport(Viewport viewport) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private static class DocumentViewportCallback
    implements ViewportCallback {
        private StormBase stormBase;
        private DocumentFrame browserFrame;
        private String viewportId = null;
        private Waiter taskwaiter = null;

        public DocumentViewportCallback(Waiter taskwaiter) {
            this.taskwaiter = taskwaiter;
        }

        public DocumentFrame getBrowserPanel() {
            return this.browserFrame;
        }

        public String getViewportName() {
            return this.viewportId;
        }

        public Container createTopLevelContainer(Viewport viewport) {
            this.viewportId = viewport.getId();
            if (this.browserFrame == null) {
                this.browserFrame = new DocumentFrame(this.stormBase, viewport);
                this.browserFrame.setVisible(false);
            }
            RenderDoneTracker rt = new RenderDoneTracker(viewport.getId());
            rt.addTrackerListener(new RenderDoneTrackerListener(){

                @Override
                public void renderingDone(String viewportId, int resolutionType, String msg) {
                    if (resolutionType == 0) {
                        taskwaiter.setResponse(null);
                    } else if (resolutionType == 1) {
                        taskwaiter.setResponse((Object)msg);
                        this.disposeTopLevelContainer(stormBase.findViewportByName(viewportId));
                    } else if (resolutionType == 2) {
                        taskwaiter.setResponse((Object)msg);
                        this.disposeTopLevelContainer(stormBase.findViewportByName(viewportId));
                    }
                }
            });
            this.stormBase.addPropertyChangeListener((PropertyChangeListener)rt, viewport.getId());
            return this.browserFrame.getPanel();
        }

        public void disposeTopLevelContainer(Viewport viewport) {
            if (this.browserFrame != null) {
                this.browserFrame.setVisible(false);
                this.browserFrame = null;
            }
        }

        public void init(StormBase stormBase) {
            this.stormBase = stormBase;
        }

        public void authenticationFailed(URL url) {
            this.taskwaiter.setResponse((Object)url);
            this.disposeTopLevelContainer(null);
        }

        public void processViewportMessage(Viewport viewport, String messageName, Object addArg, Object value) {
        }

        protected void dispose() {
            this.disposeTopLevelContainer(this.stormBase.findViewportByName(this.viewportId));
        }
    }

    private static class AuthenticationData {
        private String userName;
        private String password;
        private DocumentViewportCallback callback;
        private Set urlSet = new HashSet();
        private URL authFailedURL;

        public AuthenticationData(String userName, String password, DocumentViewportCallback callback) {
            this.userName = userName;
            this.password = password;
            this.callback = callback;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean authenticationTried(URL url) {
            return this.urlSet.contains(url);
        }

        public void addURL(URL url) {
            this.urlSet.add(url);
        }

        void authenticationFailed(URL url) {
            this.authFailedURL = url;
            this.callback.authenticationFailed(url);
        }

        boolean isAuthFailed() {
            return this.authFailedURL != null;
        }
    }

    public static class TimeOutException
    extends Exception {
        private long timeout;

        public TimeOutException(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }
    }

    public static class AuthenticationFailedException
    extends Exception {
        private URL url;

        public AuthenticationFailedException(URL url) {
            this.url = url;
        }

        public URL getURL() {
            return this.url;
        }
    }

    public static class RenderException
    extends Exception {
        public RenderException(String message) {
            super(message);
        }
    }

    private static class IceAuthenticationListener
    implements AuthenticationListener {
        private IceAuthenticationListener() {
        }

        public void onAuthenticationEvent(AuthenticationEvent authenticationEvent) {
            Authentication authentication = authenticationEvent.getAuthentication();
            AuthenticationData authData = (AuthenticationData)authenticationThreadLocal.get();
            if (authData != null) {
                URL url = authentication.getUrl();
                if (!authData.authenticationTried(url)) {
                    authentication.setUserName(authData.getUserName());
                    authentication.setPassword(authData.getPassword());
                    authData.addURL(url);
                } else {
                    authentication.setGiveUp(true);
                    authData.authenticationFailed(url);
                }
            }
        }
    }
}

