/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.proxy;

import coldfusion.log.CFLogs;
import coldfusion.tagext.net.websocket.server.proxy.ProxyConnection;
import coldfusion.tagext.net.websocket.server.proxy.ProxyMessage;
import coldfusion.tagext.net.websocket.server.proxy.ProxyMessageProcessor;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyConnectionManager;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyServer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;

public class WSProxyMessageReader {
    static Charset charset = Charset.forName("UTF-8");
    static CharsetDecoder decoder = charset.newDecoder();
    ProxyConnection conn;
    ByteBuffer readBuffer;
    int readBufferSize;
    private String incompletePreviousMessage;

    public WSProxyMessageReader(ProxyConnection conn, int readBufferSize) {
        this.conn = conn;
        this.readBufferSize = readBufferSize;
        this.readBuffer = ByteBuffer.allocateDirect(readBufferSize);
    }

    public void doRead() {
        WebSocketProxyReadCompletionHandler handler = new WebSocketProxyReadCompletionHandler();
        this.conn.read(this.readBuffer, handler);
    }

    private class WebSocketProxyReadCompletionHandler
    implements CompletionHandler<Integer, AsynchronousSocketChannel> {
        private WebSocketProxyReadCompletionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, AsynchronousSocketChannel attachment) {
            if (result != -1) {
                CharBuffer charBuffer = null;
                try {
                    charBuffer = decoder.decode(WSProxyMessageReader.this.readBuffer.flip());
                    if (charBuffer.length() != 0) {
                        ArrayList<ProxyMessage> msgs = this.parseReceivedMessage(charBuffer.toString());
                        ArrayBlockingQueue<ArrayList<ProxyMessage>> arrayBlockingQueue = WSProxyServer.receivedBuffers;
                        synchronized (arrayBlockingQueue) {
                            WSProxyServer.receivedBuffers.offer(msgs);
                        }
                    }
                    WSProxyMessageReader.this.readBuffer.clear();
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            WSProxyMessageReader.this.doRead();
        }

        private ArrayList<ProxyMessage> parseReceivedMessage(String msg) {
            Object[] result;
            if (WSProxyMessageReader.this.incompletePreviousMessage != null) {
                CFLogs.WEBSOCKETPROXY_LOG.info((Object)("Incomplete Message before merge " + WSProxyMessageReader.this.incompletePreviousMessage));
                msg = WSProxyMessageReader.this.incompletePreviousMessage + (String)msg;
                WSProxyMessageReader.this.incompletePreviousMessage = null;
            }
            if ((result = ProxyMessageProcessor.processProxyMessages((String)msg)) == null) {
                WSProxyMessageReader.this.incompletePreviousMessage = null;
                return null;
            }
            WSProxyMessageReader.this.incompletePreviousMessage = (String)result[0];
            return (ArrayList)result[1];
        }

        @Override
        public void failed(Throwable exc, AsynchronousSocketChannel attachment) {
            WSProxyConnectionManager.getInstance().removeClientConnection(WSProxyMessageReader.this.conn);
        }
    }
}

