/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.proxy;

import coldfusion.tagext.net.websocket.server.core.ClientConnectionManager;
import coldfusion.tagext.net.websocket.server.core.WSTaskProcessor;
import coldfusion.tagext.net.websocket.server.proxy.ClientProxyConnection;
import coldfusion.tagext.net.websocket.server.proxy.ProxyConnection;
import coldfusion.tagext.net.websocket.server.proxy.WSProxyMessageWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class WSProxyConnectionManager {
    private static WSProxyConnectionManager connectionMgrInstance;
    private static ConcurrentLinkedDeque<ProxyConnection> clientConnections;
    private static ConcurrentLinkedDeque<Object[]> messageQ;
    private static WSProxyMessageWriter messageWriter;
    private static ConcurrentHashMap<String, ProxyConnection> clientIdMap;
    private static ConcurrentHashMap<ProxyConnection, Integer> clientSizeMap;
    private static AtomicInteger activeConnectionCount;

    public static WSProxyConnectionManager getInstance() {
        return connectionMgrInstance;
    }

    void addClientConnection(ProxyConnection connection) {
        clientConnections.add(connection);
        clientSizeMap.put(connection, 0);
        activeConnectionCount.incrementAndGet();
    }

    void removeClientConnection(ProxyConnection connection) {
        clientConnections.remove(connection);
        clientSizeMap.remove(connection);
        activeConnectionCount.decrementAndGet();
        if (activeConnectionCount.intValue() == 0) {
            Map connections = ClientConnectionManager.getConnections();
            for (ClientProxyConnection conn : connections.values()) {
                if (conn == null) continue;
                WSTaskProcessor.getTaskProcessor().connectionClosed(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConnection getConnection(String clientId, byte[] msgBytes) {
        ProxyConnection conn = clientIdMap.get(clientId);
        if (conn != null && conn.getState() != -1) {
            return conn;
        }
        conn = this.getConnectionWithLeastClients();
        if (conn != null && conn.getState() != -1) {
            try {
                clientIdMap.put(clientId, conn);
                int clients = clientSizeMap.get(conn);
                clientSizeMap.put(conn, ++clients);
                return conn;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator<ProxyConnection> it = clientConnections.iterator();
        while (it.hasNext()) {
            ProxyConnection proxyConnection = conn = it.next();
            synchronized (proxyConnection) {
                if (conn.getState() == 0) {
                    conn.setState(2);
                    return conn;
                }
            }
        }
        return null;
    }

    void updateClientMaps(String clientId, ProxyConnection conn) {
        clientIdMap.put(clientId, conn);
        Integer clients = clientSizeMap.get(conn);
        if (clients == null) {
            clients = new Integer(0);
            clientSizeMap.put(conn, clients);
        } else {
            Integer n = clients;
            clients = clients + 1;
        }
    }

    private ProxyConnection getConnectionWithLeastClients() {
        Iterator<Map.Entry<ProxyConnection, Integer>> it = clientSizeMap.entrySet().iterator();
        ProxyConnection conn = null;
        int minSize = Integer.MAX_VALUE;
        while (it.hasNext()) {
            Map.Entry<ProxyConnection, Integer> elem = it.next();
            ProxyConnection tmpConn = elem.getKey();
            int clients = elem.getValue();
            if (tmpConn.getState() == -1 || clients >= minSize) continue;
            conn = elem.getKey();
            minSize = clients;
        }
        return conn;
    }

    private static byte[] convertMessageLengthToBytes(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doWrite(String clientId, String msg) {
        try {
            msg = String.valueOf(((String)msg).length()) + ";" + (String)msg;
            byte[] msgBytes = new byte[((String)msg).getBytes("UTF-8").length];
            System.arraycopy(((String)msg).getBytes("UTF-8"), 0, msgBytes, 0, ((String)msg).getBytes("UTF-8").length);
            messageQ.add(new Object[]{clientId, msgBytes, msg});
            ConcurrentLinkedDeque<Object[]> concurrentLinkedDeque = messageQ;
            synchronized (concurrentLinkedDeque) {
                messageQ.notify();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public void shutdown() {
        messageWriter.close();
        for (ProxyConnection conn : clientConnections) {
            conn.shutdown();
        }
    }

    public void resetClientIds(ProxyConnection connection) {
        clientIdMap.values().remove(connection);
        clientSizeMap.remove(connection);
    }

    public void removeClientConnection(String clientId) {
        clientIdMap.remove(clientId);
    }

    static {
        clientConnections = new ConcurrentLinkedDeque();
        messageQ = new ConcurrentLinkedDeque();
        connectionMgrInstance = new WSProxyConnectionManager();
        messageWriter = new WSProxyMessageWriter(messageQ);
        clientIdMap = new ConcurrentHashMap();
        clientSizeMap = new ConcurrentHashMap();
        activeConnectionCount = new AtomicInteger();
    }
}

