/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.netty;

import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.websocket.server.netty.WebSocketClientConnectionInitializer;
import coldfusion.tagext.net.websocket.server.netty.WebSocketFrameHandler;
import coldfusion.tagext.net.websocket.server.netty.WebSocketSSLEngine;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class WSNettyPipelineFactory
extends ChannelInitializer<SocketChannel> {
    private final boolean ssl;
    private final int DEFAULT_MAX_FRAME_SIZE = 0x100000;
    private final int maxFrameSize = ServiceFactory.getWebsocketService().getMaxFrameSize() > 0 ? ServiceFactory.getWebsocketService().getMaxFrameSize() * 1024 : 0x100000;

    public WSNettyPipelineFactory(boolean ssl) {
        this.ssl = ssl;
    }

    protected void initChannel(SocketChannel socketChannel) {
        String WEBSOCKET_PATH = "/cfusion/cfusion";
        ChannelPipeline pipeline = socketChannel.pipeline();
        if (this.ssl) {
            SSLEngine engine = WebSocketSSLEngine.getContext().createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxFrameSize)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketClientConnectionInitializer()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WEBSOCKET_PATH, null, true, this.maxFrameSize)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketFrameHandler()});
    }
}

