/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.cluster;

import coldfusion.log.CFLogs;
import coldfusion.tagext.net.websocket.WebSocketServiceImpl;
import coldfusion.tagext.net.websocket.WebSocketUtil;
import coldfusion.tagext.net.websocket.server.cluster.MethodInvocationData;
import coldfusion.tagext.net.websocket.server.cluster.MulticastDiscovery;
import coldfusion.tagext.net.websocket.server.cluster.PeerInfo;
import coldfusion.tagext.net.websocket.server.cluster.RemoteMethodExecutor;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketRemoteService;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketRemoteServiceImpl;
import coldfusion.util.RB;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class WebSocketClusterManager {
    private static final String PREFIX_INSTANCE = "instance_";
    private static final String WS_REMOTE_STUB = "WSRemoteStub";
    private static final String MULTICAST_GROUP_IP = "229.0.0.2";
    private static final int RMI_PORT = 1099;
    private static Logger logger = Logger.getLogger(WebSocketClusterManager.class);
    private static WebSocketClusterManager instance;
    private WebSocketServiceImpl webSocketService;
    private RemoteMethodExecutor executor;
    private MulticastDiscovery discoveryService;
    private WebSocketRemoteServiceImpl remoteService_self;
    private PeerInfo selfNode;
    private List<PeerInfo> peerList = new LinkedList<PeerInfo>();

    public static WebSocketClusterManager getInstance() {
        if (instance == null) {
            instance = new WebSocketClusterManager();
        }
        return instance;
    }

    public void initializeClusterSetting(WebSocketServiceImpl webSocketService) {
        this.webSocketService = webSocketService;
        this.remoteService_self = new WebSocketRemoteServiceImpl();
        this.populateInstanceNode();
        this.exportRemoteObjAndStub();
        this.discoveryService = new MulticastDiscovery(MULTICAST_GROUP_IP, webSocketService.getMulticastPort());
        this.discoveryService.startListeningInMessage();
        this.discoveryService.broadcastNodeUpMessage(this.selfNode);
        this.executor = new RemoteMethodExecutor();
    }

    public void stopCluster() {
        if (null == this.discoveryService) {
            return;
        }
        this.discoveryService.stopMulticastSocket();
        for (PeerInfo peerInfo : this.peerList) {
            if (peerInfo == null || peerInfo.isLocalInstance() || peerInfo.getStub() == null) continue;
            try {
                peerInfo.getStub().removePeer(this.selfNode);
            }
            catch (RemoteException ex) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionError", (Object)"removePeer", (Object)this.selfNode.getHostName(), (Object)ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void exportRemoteObjAndStub() {
        Registry registry = this.getRegistry();
        String bindName = this.populateRemoteObjectName(this.selfNode);
        WebSocketRemoteService stub = this.remoteService_self.toStub();
        this.selfNode.setStub(stub);
        try {
            registry.rebind(bindName, stub);
        }
        catch (RemoteException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"NodeStubBindError", (Object)bindName, (Object)e.getMessage()), (Throwable)e);
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"NodeStubNotBoundedError", (Object)ex.getMessage()), (Throwable)ex);
        }
    }

    public MulticastDiscovery getDiscoveryService() {
        return this.discoveryService;
    }

    public void delegatePublishMessage(String appName, String channel, String message, Map filterCriteria) {
        MethodInvocationData methodData = new MethodInvocationData(MethodInvocationData.PUBLISH_MESSAGE, appName, channel);
        methodData.setMessageToPublish(message);
        methodData.setFilterCriteria(filterCriteria);
        this.callRemoteNodesSync(methodData);
    }

    public List delegateGetChannels(String appName, String channel) {
        MethodInvocationData methodData = new MethodInvocationData(MethodInvocationData.GET_ALL_CHANNELS, appName, channel);
        List futureList = this.callRemoteNodesAsync(methodData);
        LinkedList result = new LinkedList();
        for (Future future : futureList) {
            try {
                List list = (List)future.get();
                result.addAll(list);
            }
            catch (InterruptedException e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionErrorNoHost", (Object)"GetAllClients", (Object)e.getMessage()), (Throwable)e);
            }
            catch (ExecutionException e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionErrorNoHost", (Object)"GetAllClients", (Object)e.getMessage()), (Throwable)e);
            }
        }
        return result;
    }

    public List delegateGetClients(String appName, String channel) {
        MethodInvocationData methodData = new MethodInvocationData(MethodInvocationData.GET_ALL_CLIENTS, appName, channel);
        List futureList = this.callRemoteNodesAsync(methodData);
        LinkedList result = new LinkedList();
        for (Future future : futureList) {
            try {
                List list = (List)future.get();
                result.addAll(list);
            }
            catch (InterruptedException e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionErrorNoHost", (Object)"GetAllClients", (Object)e.getMessage()), (Throwable)e);
            }
            catch (ExecutionException e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionErrorNoHost", (Object)"GetAllClients", (Object)e.getMessage()), (Throwable)e);
            }
        }
        return result;
    }

    public int delegateGetSubscriberCount(String appName, String channel) {
        MethodInvocationData methodData = new MethodInvocationData(MethodInvocationData.GET_SUBSCRIBER_COUNT, appName, channel);
        List futureList = this.callRemoteNodesAsync(methodData);
        int totalSubscriberCount = 0;
        for (Future future : futureList) {
            try {
                int count = (Integer)future.get();
                totalSubscriberCount += count;
            }
            catch (InterruptedException e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionErrorNoHost", (Object)"GetAllClients", (Object)e.getMessage()), (Throwable)e);
            }
            catch (ExecutionException e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionErrorNoHost", (Object)"GetAllClients", (Object)e.getMessage()), (Throwable)e);
            }
        }
        return totalSubscriberCount;
    }

    private List callRemoteNodesAsync(MethodInvocationData data) {
        ArrayList<Future> futureList = new ArrayList<Future>(this.peerList.size() - 1);
        Iterator<PeerInfo> itr = this.peerList.iterator();
        while (itr.hasNext()) {
            PeerInfo peerInfo = itr.next();
            if (peerInfo == null || peerInfo.isLocalInstance() || peerInfo.getStub() == null) continue;
            try {
                WebSocketRemoteService stub = peerInfo.getStub();
                futureList.add(this.executor.executeTask(stub, data));
            }
            catch (ConnectException connEx) {
                itr.remove();
            }
            catch (RemoteException ex) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionError", (Object)MethodInvocationData.getMethodName(data), (Object)peerInfo.getHostName(), (Object)ex.getMessage()), (Throwable)ex);
            }
        }
        return futureList;
    }

    private void callRemoteNodesSync(MethodInvocationData data) {
        Iterator<PeerInfo> itr = this.peerList.iterator();
        while (itr.hasNext()) {
            PeerInfo peerInfo = itr.next();
            if (peerInfo == null || peerInfo.isLocalInstance() || peerInfo.getStub() == null) continue;
            try {
                peerInfo.getStub().invoke(data);
            }
            catch (ConnectException connEx) {
                itr.remove();
            }
            catch (RemoteException ex) {
                if (ex.getCause() instanceof WebSocketUtil.ChannelNotFoundForPublishException) continue;
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionError", (Object)MethodInvocationData.getMethodName(data), (Object)peerInfo.getHostName(), (Object)ex.getMessage()), (Throwable)ex);
            }
            catch (Exception exception) {}
        }
    }

    public void addAndAcknowledgeRemotePeer(PeerInfo remotePeer) {
        WebSocketRemoteService remoteStub;
        if (this.selfNode.getNodeName().equals(remotePeer.getNodeName()) && this.selfNode.getHostName().equals(remotePeer.getHostName())) {
            return;
        }
        boolean success = this.onAddPeer(remotePeer);
        if (success && (remoteStub = remotePeer.getStub()) != null) {
            try {
                remoteStub.addPeer(this.selfNode);
            }
            catch (RemoteException ex) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteMethodExecutionError", (Object)"addPeer", (Object)remotePeer.getHostName(), (Object)ex.getMessage()), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAddPeer(PeerInfo peerInfo) {
        if (this.isPeerAlreadyPresent(peerInfo)) {
            return false;
        }
        Registry registry = this.getRemoteRegistry(peerInfo.getHostName());
        WebSocketRemoteService remoteStub = null;
        if (registry == null) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteRegistryNotFoundError", (Object)peerInfo.getHostName()));
            return false;
        }
        String serviceName = this.populateRemoteObjectName(peerInfo);
        try {
            remoteStub = (WebSocketRemoteService)registry.lookup(serviceName);
        }
        catch (RemoteException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteStubLookupFailedError", (Object)serviceName, (Object)peerInfo.getHostName(), (Object)e.getMessage()), (Throwable)e);
            return false;
        }
        catch (NotBoundException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteStubNotBoundError", (Object)serviceName, (Object)peerInfo.getHostName(), (Object)e.getMessage()), (Throwable)e);
            return false;
        }
        if (remoteStub == null) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteStubNullError", (Object)serviceName, (Object)peerInfo.getHostName()));
            return false;
        }
        peerInfo.setStub(remoteStub);
        List<PeerInfo> list = this.peerList;
        synchronized (list) {
            this.peerList.add(peerInfo);
        }
        return true;
    }

    public void onRemovePeer(PeerInfo remotePeer) {
        for (PeerInfo peer : this.peerList) {
            if (!peer.getNodeName().equals(remotePeer.getNodeName()) || !peer.getHostName().equals(remotePeer.getHostName())) continue;
            this.peerList.remove(peer);
            return;
        }
    }

    public List<PeerInfo> getPeers() {
        return this.peerList;
    }

    public PeerInfo getLocalPeerInfo() {
        return this.selfNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateInstanceNode() {
        this.selfNode = new PeerInfo();
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"LocalHostResolutionFailed", (Object)e.getMessage()), (Throwable)e);
        }
        String hostName = ia.getHostAddress();
        this.selfNode.setHostName(hostName);
        this.selfNode.setNodeName(this.generateNodeName());
        this.selfNode.setLocalInstance(true);
        List<PeerInfo> list = this.peerList;
        synchronized (list) {
            this.peerList.add(this.selfNode);
        }
    }

    private boolean isPeerAlreadyPresent(PeerInfo newNode) {
        for (PeerInfo peer : this.peerList) {
            if (!peer.getNodeName().equals(newNode.getNodeName()) || !peer.getHostName().equals(newNode.getHostName())) continue;
            return peer.getStub() == newNode.getStub();
        }
        return false;
    }

    private String populateRemoteObjectName(PeerInfo nodeInfo) {
        String name = nodeInfo.getNodeName() + WS_REMOTE_STUB;
        return name;
    }

    private String generateNodeName() {
        String webSocketPort = "" + this.webSocketService.getPort();
        String nodeName = PREFIX_INSTANCE + webSocketPort;
        return nodeName;
    }

    private Registry getRegistry() {
        Registry rmiRegistry = null;
        try {
            rmiRegistry = LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException e) {
            try {
                rmiRegistry = LocateRegistry.getRegistry(1099);
            }
            catch (RemoteException ex) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"LocalRMIRegistryRetrievalFailed", (Object)1099, (Object)ex.getMessage()), (Throwable)ex);
            }
        }
        return rmiRegistry;
    }

    private Registry getRemoteRegistry(String host) {
        Registry rmiRegistry = null;
        try {
            rmiRegistry = LocateRegistry.getRegistry(host);
        }
        catch (RemoteException e) {
            CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"RemoteRegistryNotFoundError", (Object)host, (Object)e.getMessage()), (Throwable)e);
        }
        return rmiRegistry;
    }
}

