/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationEventListener;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.EventListeners;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RMIInitializationException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.SecurityService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.net.websocket.WebSocketTag;
import coldfusion.tagext.net.websocket.WebSocketUtil;
import coldfusion.tagext.net.websocket.messaging.ChannelConstants;
import coldfusion.tagext.net.websocket.messaging.ChannelManager;
import coldfusion.tagext.net.websocket.server.WebSocketEngine;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.util.PasswordUtils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class WebSocketServiceImpl
extends ServiceBase
implements WebSocketService,
ApplicationEventListener,
Observer {
    private static final Object[] noArgs = new Object[0];
    private static ServletContext mServletContext;
    private File configFile;
    private final int DEFAULT_PORT = 8575;
    private final int DEFAULT_MULTICAST_PORT = 45566;
    private final int DEFAULT_SSL_PORT = 8543;
    private final int DEFAULT_MAX_FRAME_SIZE = 1024;
    private final int DEFAULT_SOCKET_TIME_OUT = 300;
    private final String FLASH_POLICY_PORT = "flashPolicyPort";
    private final String CLUSTERED = "clustered";
    private final String START_LISTENER_NORMAL_PORT = "startListenerOnNormalPort";
    private final String SSL_ENABLED = "sslEnabled";
    private final String SSL_PORT = "sslport";
    private final String KEY_STORE_LOCATION = "keystoreLocation";
    private final String KEY_STORE_PASSWORD = "keystorePassword";
    protected ConfigMap websocket_settings;
    private WebSocketEngine webSocketEngine;
    private int port;
    private int multicastPort;
    private int flashPort;
    private int socketTimeOut;
    private int maxFrameSize;
    private boolean flashFallBackEnabled = true;
    private boolean loggingEnabled = false;
    private boolean isEnabled = true;
    private boolean clustered = false;
    private boolean normalPortListenerEnabled = true;
    private boolean isEnterpriseEdition = true;
    private boolean sslEnabled = false;
    private int sslPort = 8443;
    private String keyStoreLocation = null;
    private String keyStorePassword = null;
    private String encryptedKeyStorePassword = null;
    private String seed;
    private final String START_LISTENER_PROXY_CONNECT_PORT = "enableWebsocketOverProxyPort";
    private boolean isProxyEnabled;
    private static final String ENABLE_RMI = "coldfusion.rmi.enable";
    private static boolean openRMIPort;

    public WebSocketServiceImpl(File configFile) {
        this.configFile = configFile;
        this.setEnableWatch(true);
        this.setWatchFile(configFile);
        try {
            FeatureRouter.getInstance().allowFeature(EFRConstants.websocket_cluster.intValue(), null);
        }
        catch (Exception e) {
            this.isEnterpriseEdition = false;
        }
    }

    public void start(ServletContext context) throws ServiceException {
        super.start();
        mServletContext = context;
        this.webSocketEngine = new WebSocketEngine();
        if (this.isEnabled) {
            EventListeners.addApplicationEventListener((ApplicationEventListener)this);
            this.webSocketEngine.start(this);
        }
        if (this.clustered && this.isEnterpriseEdition) {
            if (!openRMIPort) {
                String message = "RMI is needed for Websocket functionality to work in clustered state. Set coldfusion.rmi.enable JVM flag as true and restart the server";
                CFLogs.SERVER_LOG.error((Object)message);
                throw new RMIInitializationException(message);
            }
            try {
                WebSocketClusterManager clusterManager = WebSocketClusterManager.getInstance();
                clusterManager.initializeClusterSetting(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                CFLogs.SERVER_LOG.info((Object)("Cluster initialization for WebSocket failed. Verify assigned multicast port " + this.multicastPort + " is not in use."));
            }
        }
    }

    public void stop() throws ServiceException {
        if (this.webSocketEngine != null) {
            this.webSocketEngine.stop();
        }
    }

    public void store() throws ServiceException {
        this.serialize(this.websocket_settings, this.configFile);
    }

    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        this.serialize(this.websocket_settings, this.configFile, broadcast, key, value, oldValue);
    }

    public void load() throws ServiceException {
        try {
            PasswordUtils.getInstance().addObserver((Observer)this);
            this.websocket_settings = (ConfigMap)this.deserialize(this.configFile);
            ConfigMap settingsLocal = (ConfigMap)this.deserialize(this.configFile, true);
            this.websocket_settings.init((Service)this, "configuration");
            this.websocket_settings.setConfigMapListener((ConfigMapListener)this);
            Boolean normalportEnalbed = (Boolean)this.websocket_settings.get((Object)"startListenerOnNormalPort");
            if (normalportEnalbed != null) {
                this.normalPortListenerEnabled = normalportEnalbed;
            } else {
                this.websocket_settings.put((Object)"NORMAL_PORT", (Object)new Boolean(true));
            }
            String portvalue = (String)this.websocket_settings.get((Object)"port");
            if (portvalue != null) {
                this.port = Integer.parseInt(portvalue);
            } else {
                this.websocket_settings.put((Object)"port", (Object)"8575", false);
            }
            String flashPortvalue = (String)this.websocket_settings.get((Object)"flashPolicyPort");
            if (flashPortvalue != null) {
                this.flashPort = Integer.parseInt(flashPortvalue);
            } else {
                this.websocket_settings.put((Object)"flashPolicyPort", (Object)"1243", false);
            }
            Number timeout = (Number)this.websocket_settings.get((Object)"socketTimeout");
            if (timeout != null) {
                this.socketTimeOut = timeout.intValue();
            } else {
                this.websocket_settings.put((Object)"socketTimeout", (Object)new Integer(300), false);
            }
            Number frameSize = (Number)this.websocket_settings.get((Object)"maxFrameSize");
            if (frameSize != null) {
                this.maxFrameSize = frameSize.intValue();
            } else {
                this.websocket_settings.put((Object)"maxFrameSize", (Object)new Integer(1024), false);
            }
            Boolean flashFallback = (Boolean)this.websocket_settings.get((Object)"flashFallBack");
            if (flashFallback != null) {
                this.flashFallBackEnabled = flashFallback;
            } else {
                this.websocket_settings.put((Object)"flashFallBack", (Object)new Boolean(true), false);
            }
            Boolean websocketStart = (Boolean)this.websocket_settings.get((Object)"startWebSocketService");
            if (websocketStart != null) {
                this.isEnabled = websocketStart;
            } else {
                this.websocket_settings.put((Object)"startWebSocketService", (Object)new Boolean(true), false);
            }
            String logLevel = (String)this.websocket_settings.get((Object)"logging");
            if (logLevel != null && logLevel.equalsIgnoreCase("debug")) {
                this.loggingEnabled = true;
            } else {
                Logger loggerWebSocket = CFLogs.WEBSOCKET_LOG;
                loggerWebSocket.setLoggingEnabled(false);
                Logger loggerWebSocketProxy = CFLogs.WEBSOCKETPROXY_LOG;
                loggerWebSocketProxy.setLoggingEnabled(false);
            }
            String multicastPortvalue = (String)this.websocket_settings.get((Object)"multicastPort");
            if (multicastPortvalue != null) {
                this.multicastPort = Integer.parseInt(multicastPortvalue);
            } else {
                this.websocket_settings.put((Object)"multicastPort", (Object)"45566", false);
            }
            Boolean clusteredVal = (Boolean)this.websocket_settings.get((Object)"clustered");
            if (clusteredVal != null) {
                this.clustered = clusteredVal;
            } else {
                this.websocket_settings.put((Object)"clustered", (Object)new Boolean(false), false);
            }
            Boolean sslEnableStr = (Boolean)this.websocket_settings.get((Object)"sslEnabled");
            if (sslEnableStr != null) {
                this.sslEnabled = sslEnableStr;
            } else {
                this.websocket_settings.put((Object)"sslEnabled", (Object)new Boolean(false), false);
            }
            String sslPortvalue = (String)this.websocket_settings.get((Object)"sslport");
            if (sslPortvalue != null) {
                this.sslPort = Integer.parseInt(sslPortvalue);
            } else {
                this.websocket_settings.put((Object)"sslport", (Object)"8543", false);
            }
            String keyStoreLocStr = (String)this.websocket_settings.get((Object)"keystoreLocation");
            if (keyStoreLocStr != null) {
                this.keyStoreLocation = keyStoreLocStr;
            } else {
                this.websocket_settings.put((Object)"keystoreLocation", (Object)"", false);
            }
            String keyStorePasswordStr = (String)settingsLocal.get((Object)"keystorePassword");
            if (keyStorePasswordStr != null) {
                this.encryptedKeyStorePassword = keyStorePasswordStr;
                this.keyStorePassword = this.decryptPassword(keyStorePasswordStr);
                this.websocket_settings.put((Object)"keystorePassword", (Object)this.encryptedKeyStorePassword, false);
            } else {
                this.websocket_settings.put((Object)"keystorePassword", (Object)"", false);
            }
            Boolean wsProxyEnabled = (Boolean)this.websocket_settings.get((Object)"enableWebsocketOverProxyPort");
            this.isProxyEnabled = wsProxyEnabled != null ? wsProxyEnabled : true;
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public boolean isWebSocketServerRunning() {
        return this.webSocketEngine.isRunning();
    }

    public boolean isWebSocketServiceEnabled() {
        return this.isEnabled;
    }

    public boolean isNormalPortListenerEnabled() {
        return this.normalPortListenerEnabled;
    }

    public void setNormalPortListenerEnabled(boolean normalPortListenerEnabled) {
        this.normalPortListenerEnabled = normalPortListenerEnabled;
        if (normalPortListenerEnabled) {
            this.websocket_settings.put((Object)"startListenerOnNormalPort", (Object)new Boolean(true));
        } else {
            this.websocket_settings.put((Object)"startListenerOnNormalPort", (Object)new Boolean(false));
        }
    }

    public boolean isClusterEnabled() {
        return this.clustered;
    }

    public boolean isEnterpriseClusterEnabled() {
        return this.clustered && this.isEnterpriseEdition;
    }

    public void setClusterEnabled(boolean clustered) {
        this.clustered = clustered;
        if (clustered) {
            this.websocket_settings.put((Object)"clustered", (Object)new Boolean(true));
        } else {
            this.websocket_settings.put((Object)"clustered", (Object)new Boolean(false));
        }
    }

    public void setWebSocketServiceEnabled(boolean enableWebSocket) {
        if (enableWebSocket) {
            this.websocket_settings.put((Object)"startWebSocketService", (Object)new Boolean(true));
        } else {
            this.websocket_settings.put((Object)"startWebSocketService", (Object)new Boolean(false));
        }
        this.isEnabled = enableWebSocket;
    }

    public int getPort() {
        return this.port;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getFlashPolicyPort() {
        return this.flashPort;
    }

    public int getSocketTimeOut() {
        return this.socketTimeOut;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public ServletContext getServletContext() {
        return mServletContext;
    }

    public void setFlashPolicyPort(int flashPort) {
        this.flashPort = flashPort;
        this.websocket_settings.put((Object)"flashPolicyPort", (Object)("" + flashPort));
    }

    public void setPort(int port) {
        this.port = port;
        this.websocket_settings.put((Object)"port", (Object)("" + port));
    }

    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
        this.websocket_settings.put((Object)"multicastPort", (Object)("" + multicastPort));
    }

    public boolean isFlashFallBackEnabled() {
        return this.flashFallBackEnabled;
    }

    public void setFlashFallBackEnabled(boolean flashFallBack) {
        if (flashFallBack) {
            this.websocket_settings.put((Object)"flashFallBack", (Object)new Boolean(true));
        } else {
            this.websocket_settings.put((Object)"flashFallBack", (Object)new Boolean(false));
        }
        this.flashFallBackEnabled = flashFallBack;
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
        this.websocket_settings.put((Object)"socketTimeout", (Object)new Integer(socketTimeOut));
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        this.websocket_settings.put((Object)"maxFrameSize", (Object)new Integer(maxFrameSize));
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.websocket_settings.put((Object)"sslEnabled", (Object)new Boolean(sslEnabled));
        this.sslEnabled = sslEnabled;
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public void setSSLPort(int sslPort) {
        this.websocket_settings.put((Object)"sslport", (Object)("" + sslPort));
        this.sslPort = sslPort;
    }

    public String getKeyStorePath() {
        return this.keyStoreLocation;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.websocket_settings.put((Object)"keystoreLocation", (Object)keyStorePath);
        this.keyStoreLocation = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean isProxyEnabled() {
        return this.isProxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.isProxyEnabled = proxyEnabled;
        this.websocket_settings.put((Object)"enableWebsocketOverProxyPort", (Object)proxyEnabled);
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(String loggingEnabled) {
        this.websocket_settings.put((Object)"logging", (Object)loggingEnabled);
        if (loggingEnabled != null && loggingEnabled.equalsIgnoreCase("debug")) {
            this.loggingEnabled = true;
        } else {
            Logger loggerWebSocket = CFLogs.WEBSOCKET_LOG;
            loggerWebSocket.setLoggingEnabled(false);
            Logger loggerWebSocketProxy = CFLogs.WEBSOCKETPROXY_LOG;
            loggerWebSocketProxy.setLoggingEnabled(false);
        }
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
        String encryptedPassword = this.encryptPassword(password);
        this.setEncryptedKeyStorePassword(encryptedPassword);
    }

    public void setEncryptedKeyStorePassword(String password) {
        this.websocket_settings.put((Object)"keystorePassword", (Object)password, false);
    }

    public void beforeApplicationStart(ApplicationScope appScope) {
        this.initializeWebSocketChannels(appScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeWebSocketChannels(ApplicationScope appScope) {
        List lChannelList = (List)appScope.getApplicationSettingsMap().get("wschannels");
        if (lChannelList == null || lChannelList.size() == 0) {
            return;
        }
        String oldPagePath = FusionContext.getCurrent().getPagePath();
        try {
            FusionContext.getCurrent().setPagePath(appScope.getApplicationPath());
            for (Object lWSChannel : lChannelList) {
                Map lChannelEntry = (Map)lWSChannel;
                String channelName = (String)lChannelEntry.get("name");
                String cfcName = (String)lChannelEntry.get("cfclistener");
                if (cfcName == null || cfcName.trim().length() == 0) {
                    cfcName = ChannelConstants.ListenerBaseComponent;
                }
                FusionContext.getCurrent().setPagePath(appScope.getApplicationPath());
                TemplateProxy listenerProxy = null;
                try {
                    File cfcFile = TemplateProxyFactory.getTemplateFile((String)cfcName, (NeoPageContext)FusionContext.getCurrent().pageContext);
                    listenerProxy = TemplateProxyFactory.resolveFile((NeoPageContext)FusionContext.getCurrent().pageContext, (File)cfcFile.getAbsoluteFile());
                    Map metadata = (Map)listenerProxy.getMetadata();
                    String initMethod = (String)metadata.get("initmethod");
                    String string = initMethod = initMethod == null ? "init" : initMethod;
                    if (listenerProxy.get((Object)initMethod) instanceof UDFMethod) {
                        listenerProxy.invoke(initMethod, noArgs, (PageContext)FusionContext.getCurrent().pageContext);
                    }
                    ChannelManager.getInstance(appScope.getName()).initializeChannel(FusionContext.getCurrent().getServletContext(), appScope.getName(), channelName, listenerProxy);
                }
                catch (Throwable throwable) {
                    throw new ChannelInitializationException(throwable, channelName, cfcName);
                    return;
                }
            }
        }
        finally {
            FusionContext.getCurrent().setPagePath(oldPagePath);
        }
    }

    public void onApplicationChange(ApplicationScope appScope) {
        this.beforeApplicationStop(appScope);
        this.beforeApplicationStart(appScope);
    }

    public void onApplicationStart(ApplicationScope appScope) {
    }

    public void beforeApplicationStop(ApplicationScope appScope) {
        ChannelManager.clearApplicationData(appScope.getName());
    }

    public void onApplicationStop(ApplicationScope appScope) {
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    private void reEncryptPassword(String oldSeed) {
        if (oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        String oldKeyStorePassword = this.encryptedKeyStorePassword;
        if (oldKeyStorePassword != null && oldKeyStorePassword.length() > 0) {
            try {
                this.encryptedKeyStorePassword = PasswordUtils.reEncryptWithNewSeed((String)oldKeyStorePassword, (String)oldSeed, (String)this.seed);
                this.setEncryptedKeyStorePassword(this.encryptedKeyStorePassword);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    private String encryptPassword(String password) {
        return PasswordUtils.encryptPassword((String)password, (String)this.seed);
    }

    private String decryptPassword(String password) {
        return PasswordUtils.decryptPassword((String)password, (String)this.seed);
    }

    public void reEncryptPasswordForMigration(String password, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (password != null) {
            try {
                this.encryptedKeyStorePassword = password = PasswordUtils.reEncryptWithNewSeed((String)password, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                this.setEncryptedKeyStorePassword(password);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    public boolean isInstanceOfwebSocketService(Object obj) {
        return obj != null && obj instanceof WebSocketServiceImpl;
    }

    public void sendMessage(String clientId, Object message) {
        WebSocketUtil.sendMessage(clientId, message);
    }

    public void publishMessage(String appName, String channel, Object message) {
        WebSocketUtil.publishMessage(appName, channel, message);
    }

    public void publishMessage(String appName, String channel, Object message, Map filterCriteria) {
        WebSocketUtil.publishMessage(appName, channel, message, filterCriteria);
    }

    public void publishMessage(String appName, String channel, Object message, Map filterCriteria, boolean isClustered) {
        WebSocketUtil.publishMessage(appName, channel, message, filterCriteria, isClustered);
    }

    public List getAllChannels(String appName) {
        return WebSocketUtil.getAllChannels(appName);
    }

    public List getAllChannels(String appName, String channelName) {
        return WebSocketUtil.getAllChannels(appName, channelName);
    }

    public List getAllChannels(String appName, String channelName, boolean clustered) {
        return WebSocketUtil.getAllChannels(appName, channelName, clustered);
    }

    public List getClients(String appName, String channelName) {
        return WebSocketUtil.getClients(appName, channelName);
    }

    public List getAllClients(String appName, String achannel, boolean clustered) {
        return WebSocketUtil.getAllClients(appName, achannel, clustered);
    }

    public Object getWSThreadContext() {
        return WebSocketUtil.getWSThreadContext();
    }

    public String getWebRootPath(Object webSocketContext) {
        return ((WebSocketUtil.WebSocketContext)webSocketContext).getWebRootPath();
    }

    public String getBaseTemplatePath(Object webSocketContext) {
        return ((WebSocketUtil.WebSocketContext)webSocketContext).getBaseTemplatePath();
    }

    public void setWebSocketForAjaxTag(HashMap ajaxTags) {
        ajaxTags.put("CFWEBSOCKET", new WebSocketTag());
    }

    static {
        openRMIPort = true;
        String openRMIPortString = System.getProperty(ENABLE_RMI);
        if (openRMIPortString != null) {
            openRMIPort = Boolean.getBoolean(ENABLE_RMI);
        }
    }

    public static class ChannelInitializationException
    extends ApplicationException {
        public String mChannelName;
        public String mlistenerCFC;

        public ChannelInitializationException(Throwable th, String channelName, String listenerCFC) {
            super(th);
            this.mChannelName = channelName;
            this.mlistenerCFC = listenerCFC;
        }
    }
}

