/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus.producer;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.VendorCredential;
import coldfusion.cloud.azure.servicebus.ServiceBusClient;
import coldfusion.cloud.azure.servicebus.ServiceBusClientImpl;
import coldfusion.cloud.azure.servicebus.ServiceBusConfig;
import java.util.HashMap;
import java.util.Map;

public class ServiceBusProducer
implements CloudServiceProducer<VendorCredential, ServiceBusConfig> {
    private static Map<String, ServiceBusClient> credentialAliasToServiceBusClient = new HashMap<String, ServiceBusClient>();

    public CloudService getServiceHandle(VendorCredential credential, ServiceBusConfig serviceConfig) {
        ServiceBusConfig config;
        String configAlias;
        String credentialAlias = credential.getAlias();
        if (credentialAlias == null) {
            credentialAlias = "";
        }
        if ((configAlias = (config = serviceConfig).getConfigAlias()) == null) {
            configAlias = "";
        }
        String id = credentialAlias + "-" + configAlias;
        ServiceBusClient serviceBusClient = this.createServiceBusClient(id, credential, config);
        return serviceBusClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServiceBusClient createServiceBusClient(String id, VendorCredential credential, ServiceBusConfig config) {
        ServiceBusClient serviceBusClient = credentialAliasToServiceBusClient.get(id);
        if (serviceBusClient != null) return serviceBusClient;
        Class<ServiceBusProducer> clazz = ServiceBusProducer.class;
        synchronized (ServiceBusProducer.class) {
            if (serviceBusClient != null) return serviceBusClient;
            serviceBusClient = new ServiceBusClientImpl(credential, config);
            credentialAliasToServiceBusClient.put(id, serviceBusClient);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return serviceBusClient;
        }
    }
}

