/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus.metadata;

import com.microsoft.azure.servicebus.management.EntityStatus;
import com.microsoft.azure.servicebus.management.SubscriptionDescription;
import java.time.Duration;

public class SBSubscriptionProperties {
    String topicPath;
    String subscriptionName;
    String receiveMode;
    Duration autoDeleteOnIdle;
    Duration defaultMessageTimeToLive;
    Boolean enableBatchedOperations;
    Boolean enableDeadletteringOnFilterEvaluationException;
    Boolean enableDeadletteringOnMessageExpiration;
    EntityStatus entityStatus;
    String forwardDeadLetteredMessagesTo;
    String forwardTo;
    Duration lockDuration;
    Integer maxDeliveryCount;
    Boolean requiresSession;
    String userMetadata;

    public SBSubscriptionProperties(SubscriptionDescription subscription) {
        this.topicPath = subscription.getTopicPath();
        this.subscriptionName = subscription.getSubscriptionName();
        this.autoDeleteOnIdle = subscription.getAutoDeleteOnIdle();
        this.enableBatchedOperations = subscription.isEnableBatchedOperations();
        this.enableDeadletteringOnFilterEvaluationException = subscription.isEnableDeadLetteringOnFilterEvaluationException();
        this.enableDeadletteringOnMessageExpiration = subscription.isEnableDeadLetteringOnMessageExpiration();
        this.entityStatus = subscription.getEntityStatus();
        this.forwardDeadLetteredMessagesTo = subscription.getForwardDeadLetteredMessagesTo();
        this.lockDuration = subscription.getLockDuration();
        this.maxDeliveryCount = subscription.getMaxDeliveryCount();
        this.requiresSession = subscription.isRequiresSession();
        this.userMetadata = subscription.getUserMetadata();
    }

    public SBSubscriptionProperties() {
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getReceiveMode() {
        return this.receiveMode;
    }

    public void setReceiveMode(String receiveMode) {
        this.receiveMode = receiveMode;
    }

    public String getTopicPath() {
        return this.topicPath;
    }

    public void setTopicPath(String topicPath) {
        this.topicPath = topicPath;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public void setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
    }

    public Boolean getEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public void setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
    }

    public Boolean getEnableDeadletteringOnFilterEvaluationException() {
        return this.enableDeadletteringOnFilterEvaluationException;
    }

    public void setEnableDeadletteringOnFilterEvaluationException(Boolean enableDeadletteringOnFilterEvaluationException) {
        this.enableDeadletteringOnFilterEvaluationException = enableDeadletteringOnFilterEvaluationException;
    }

    public Boolean getEnableDeadletteringOnMessageExpiration() {
        return this.enableDeadletteringOnMessageExpiration;
    }

    public void setEnableDeadletteringOnMessageExpiration(Boolean enableDeadletteringOnMessageExpiration) {
        this.enableDeadletteringOnMessageExpiration = enableDeadletteringOnMessageExpiration;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public void setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public void setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public void setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
    }

    public Integer getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public void setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
    }

    public Boolean getRequiresSession() {
        return this.requiresSession;
    }

    public void setRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
    }

    public EntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(EntityStatus entityStatus) {
        this.entityStatus = entityStatus;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public void setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
    }

    public SubscriptionDescription getDescription() {
        SubscriptionDescription description = new SubscriptionDescription(this.topicPath, this.subscriptionName);
        if (this.autoDeleteOnIdle != null) {
            description.setAutoDeleteOnIdle(this.autoDeleteOnIdle);
        }
        if (this.defaultMessageTimeToLive != null) {
            description.setDefaultMessageTimeToLive(this.defaultMessageTimeToLive);
        }
        if (this.enableBatchedOperations != null) {
            description.setEnableBatchedOperations(this.enableBatchedOperations.booleanValue());
        }
        if (this.enableDeadletteringOnFilterEvaluationException != null) {
            description.setEnableDeadLetteringOnFilterEvaluationException(this.enableDeadletteringOnFilterEvaluationException.booleanValue());
        }
        if (this.enableDeadletteringOnMessageExpiration != null) {
            description.setEnableDeadLetteringOnMessageExpiration(this.enableDeadletteringOnMessageExpiration.booleanValue());
        }
        if (this.entityStatus != null) {
            description.setEntityStatus(this.entityStatus);
        }
        if (this.forwardDeadLetteredMessagesTo != null) {
            description.setForwardDeadLetteredMessagesTo(this.forwardDeadLetteredMessagesTo);
        }
        if (this.forwardTo != null) {
            description.setForwardTo(this.forwardTo);
        }
        if (this.lockDuration != null) {
            description.setLockDuration(this.lockDuration);
        }
        if (this.maxDeliveryCount != null) {
            description.setMaxDeliveryCount(this.maxDeliveryCount.intValue());
        }
        if (this.userMetadata != null) {
            description.setUserMetadata(this.userMetadata);
        }
        return description;
    }
}

