/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.cursor;

import coldfusion.log.Logger;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Scope;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import jakarta.servlet.jsp.PageContext;
import java.util.Iterator;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;

@GenerateCFNamedInvoke
public class CFMongoChangeStreamCursor
extends Scope
implements NamedInvokable {
    private MongoChangeStreamCursor cursor;
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.cursor");
    private static InvokeNamedMethodInvocationMap<CFMongoChangeStreamCursor> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public CFMongoChangeStreamCursor(ChangeStreamIterable itr) {
        this.cursor = itr.cursor();
    }

    private Map convertBsonDocumentToMap(BsonDocument doc) {
        Struct map = new Struct();
        doc.forEach((arg_0, arg_1) -> CFMongoChangeStreamCursor.lambda$convertBsonDocumentToMap$0((Map)map, arg_0, arg_1));
        return map;
    }

    public Map next() {
        ChangeStreamDocument streamDoc = (ChangeStreamDocument)this.cursor.next();
        Struct streamMap = new Struct();
        if (streamDoc.getOperationType() != null) {
            streamMap.put("operationType", streamDoc.getOperationType().getValue());
        }
        if (streamDoc.getFullDocument() != null) {
            streamMap.put("fullDocument", streamDoc.getFullDocument());
        }
        if (streamDoc.getNamespaceDocument() != null) {
            streamMap.put("ns", this.convertBsonDocumentToMap(streamDoc.getNamespaceDocument()));
        }
        if (streamDoc.getDestinationNamespaceDocument() != null) {
            streamMap.put("to", this.convertBsonDocumentToMap(streamDoc.getDestinationNamespaceDocument()));
        }
        if (streamDoc.getDocumentKey() != null) {
            streamMap.put("documentKey", this.convertBsonDocumentToMap(streamDoc.getDocumentKey()));
        }
        if (streamDoc.getUpdateDescription() != null) {
            Struct updateDesc = new Struct();
            updateDesc.put("removedFields", streamDoc.getUpdateDescription().getRemovedFields());
            updateDesc.put("updatedFields", this.convertBsonDocumentToMap(streamDoc.getUpdateDescription().getUpdatedFields()));
            streamMap.put("updateDescription", updateDesc);
        }
        if (streamDoc.getClusterTime() != null) {
            Long date = streamDoc.getClusterTime().getValue();
            streamMap.put("clusterTime", Cast._Date((Object)date));
        }
        if (streamDoc.getTxnNumber() != null) {
            streamMap.put("txnNumber", streamDoc.getTxnNumber());
        }
        if (streamDoc.getLsid() != null) {
            streamMap.put("lsid", this.convertBsonDocumentToMap(streamDoc.getLsid()));
        }
        return streamMap;
    }

    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    public void close() {
        this.cursor.close();
    }

    public boolean isExhausted() {
        return this.cursor.getServerCursor() == null;
    }

    protected Object resolveName(String name) {
        BsonDocument resumeToken;
        if (name.equalsIgnoreCase("_id") && (resumeToken = this.cursor.getResumeToken()) != null) {
            return this.convertBsonDocumentToMap(resumeToken);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    protected void bindName(String name, Object obj) throws UnsupportedOperationException {
    }

    protected void bindName_Final(String name, Object obj) throws UnsupportedOperationException {
    }

    protected void unbindName(String name) throws UnsupportedOperationException {
    }

    protected boolean containsName(String name) throws UnsupportedOperationException {
        return false;
    }

    protected Iterator getNames() throws UnsupportedOperationException {
        return null;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("cursor service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("cursor service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    private static /* synthetic */ void lambda$convertBsonDocumentToMap$0(Map map, String key, BsonValue value) {
        if (value instanceof BsonString) {
            map.put(key, ((BsonString)value).getValue());
        } else if (value instanceof BsonTimestamp) {
            Long date = ((BsonTimestamp)value).getValue();
            map.put(key, Cast._Date((Object)date));
        } else {
            map.put(key, value);
        }
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"next", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.next();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("next", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"hasNext", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.hasNext();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("hasNext", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"close", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    obj.close();
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("close", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"isExhausted", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.isExhausted();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("isExhausted", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"clone", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.clone();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("clone", (Object)obj);
        });
    }
}

