/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.codecs.PrimitiveCodec;
import coldfusion.runtime.JSONUtils;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;
import org.bson.json.JsonReader;

class CFJSONBasedCodec<T>
extends PrimitiveCodec<T> {
    CFJSONBasedCodec() {
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        String serializeJSON = JSONUtils.serializeJSON(value, (Object)"struct");
        if (serializeJSON.startsWith("[")) {
            JsonReader jsonReader = new JsonReader(serializeJSON);
            jsonReader.readStartArray();
            writer.writeStartArray();
            BsonReaderMark mark = jsonReader.getMark();
            while (jsonReader.readBsonType() == BsonType.DOCUMENT) {
                mark.reset();
                writer.pipe((BsonReader)jsonReader);
                mark = jsonReader.getMark();
            }
            jsonReader.readEndArray();
            writer.writeEndArray();
            return;
        }
        writer.pipe((BsonReader)new JsonReader(serializeJSON));
    }

    public Class<T> getEncoderClass() {
        return Object.class;
    }
}

