/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.bson.types;

import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.bson.types.CFMongoObjectID;
import coldfusion.runtime.Scope;
import coldfusion.util.CFDumpable;
import com.mongodb.DBRef;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bson.types.ObjectId;

public class CFMongoDBRef
extends Scope
implements CFDumpable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DBRef dbRef;
    public static final String DB = "db";
    public static final String COLLECTION = "collection";
    public static final String ID = "id";
    private static final List<String> keysList = Collections.unmodifiableList(Arrays.asList("id", "collection", "db"));

    public CFMongoDBRef(DBRef dbRef) {
        this.dbRef = dbRef;
    }

    public CFMongoDBRef(String collectionName, Object objectId) {
        this(collectionName, objectId, null);
    }

    public CFMongoDBRef(String collectionName, Object objectId, String db) {
        ObjectId objId = objectId instanceof CFMongoObjectID ? ((CFMongoObjectID)objectId).getId() : MongoUtils.getObjectId(objectId);
        this.dbRef = new DBRef(db, collectionName, (Object)objId);
    }

    public DBRef getRef() {
        return this.dbRef;
    }

    public Object getMetadata() {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put(ID, new CFMongoObjectID(this.dbRef.getId()));
        metaData.put(COLLECTION, this.dbRef.getCollectionName());
        metaData.put(DB, this.dbRef.getDatabaseName());
        return metaData;
    }

    public String getLabel() {
        return "MongoDBRef";
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void bindName(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void bindName_Final(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void unbindName(String name) {
        throw new UnsupportedOperationException();
    }

    protected Object resolveName(String name) {
        if ((name = name.toLowerCase()).equals(COLLECTION)) {
            return this.dbRef.getCollectionName();
        }
        if (name.equals(ID)) {
            return new CFMongoObjectID(this.dbRef.getId());
        }
        if (name.equals(DB)) {
            return this.dbRef.getDatabaseName();
        }
        return null;
    }

    protected boolean containsName(String name) {
        return keysList.contains(name.toLowerCase());
    }

    protected Iterator getNames() {
        return keysList.iterator();
    }
}

