/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.nosql.mongo.CFMongoClientSession;
import coldfusion.nosql.mongo.CFMongoCollection;
import coldfusion.nosql.mongo.CFMongoGridFSBucket;
import coldfusion.nosql.mongo.CFMongoServiceHandle;
import coldfusion.nosql.mongo.MongoConfigException;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.cursor.CFMongoIterator;
import coldfusion.nosql.mongo.cursor.CFMongoIteratorImpl;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Scope;
import coldfusion.server.ServiceFactory;
import coldfusion.util.CFDumpable;
import coldfusion.util.RB;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import jakarta.servlet.jsp.PageContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class CFMongoDatabase
extends Scope
implements CFDumpable,
NamedInvokable {
    public static final Class<Map> DOCUMENT_CLASS = Map.class;
    private MongoDatabase db;
    private CFMongoClientSession csDelegate;
    private final CFMongoServiceHandle svc;
    private static final BsonValue VALUE_1 = new BsonInt32(1);
    private static final BsonValue VALUE_0 = new BsonInt32(0);
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)"MONGO_DB");
    private static String[] serverStatusKeys = new String[]{"asserts", "connections", "encryptionAtRest", "extra_info", "globalLock", "host", "localTime", "locks", "metrics", "logicalSessionRecordCache", "network", "opLatencies", "opReadConcernCounters", "opcounters", "opcountersRepl", "pid", "security", "storageEngine", "tcmalloc", "transactions", "transportSecurity", "uptime", "uptimeEstimate", "uptimeMillis", "version", "wiredTiger"};
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.mongo");
    private static InvokeNamedMethodInvocationMap<CFMongoDatabase> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    CFMongoDatabase(MongoDatabase db, CFMongoServiceHandle svc) {
        this.db = db;
        this.svc = svc;
        this.tagAttributeList.addTagAttribute("db", (Object)db.getName());
    }

    CFMongoDatabase(MongoDatabase db, CFMongoServiceHandle svc, CFMongoClientSession csDelegate) {
        this(db, svc);
        this.csDelegate = csDelegate;
        this.tagAttributeList.addTagAttribute("db", (Object)db.getName());
    }

    public CFMongoServiceHandle getSvc() {
        return this.svc;
    }

    public String getName() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getName", (boolean)true);
        String res = this.db.getName();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getName", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public List getCollectionNames() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getCollectionNames", (boolean)true);
        ListCollectionsIterable collectionIterator = this.csDelegate == null ? this.db.listCollections(DOCUMENT_CLASS) : this.db.listCollections(this.csDelegate.getClientSession(), DOCUMENT_CLASS);
        Array array = new Array();
        collectionIterator.iterator().forEachRemaining(map -> array.add((Object)((String)map.get("name"))));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getCollectionNames", (TagAttributeList)this.tagAttributeList);
        return array;
    }

    public CFMongoIterator<String> __getCollectionNames(CFMongoClientSession clientSession) {
        RequestMonitorEventProcessor.onFunctionStart((String)"__getCollectionNames", (boolean)true);
        CFMongoIteratorImpl<String> res = new CFMongoIteratorImpl<String>(this.db.listCollectionNames(clientSession.getClientSession()));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"__getCollectionNames", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Array getCollectionInfos() {
        return this.getCollectionInfos(null, false, false, null);
    }

    public Array getCollectionInfos(Map<?, ?> query) {
        return this.getCollectionInfos(query, false, false, null);
    }

    public Array getCollectionInfos(Map<?, ?> query, boolean nameOnly) {
        return this.getCollectionInfos(query, nameOnly, false, null);
    }

    public Array getCollectionInfos(Map<?, ?> query, boolean nameOnly, boolean authorizedCollections) {
        return this.getCollectionInfos(query, nameOnly, authorizedCollections, null);
    }

    public Array getCollectionInfos(Map<?, ?> query, boolean nameOnly, boolean authorizedCollections, Map<?, ?> options) {
        BsonDocument queryFilter;
        RequestMonitorEventProcessor.onFunctionStart((String)"getCollectionInfos", (boolean)true);
        CFMongoClientSession clientSession = MongoUtils.getSession(options);
        clientSession = clientSession == null ? this.csDelegate : clientSession;
        ListCollectionsIterable collectionIterator = clientSession == null ? this.db.listCollections(DOCUMENT_CLASS) : this.db.listCollections(clientSession.getClientSession(), DOCUMENT_CLASS);
        BsonDocument bsonDocument = queryFilter = query != null ? BsonUtils.to(query) : null;
        if (queryFilter != null) {
            collectionIterator.filter((Bson)queryFilter);
        }
        MongoUtils.getListCollectionsIterable(options, collectionIterator);
        Array array = new Array();
        collectionIterator.iterator().forEachRemaining(map -> array.add((Object)(nameOnly ? new HashMap<String, String>(){
            {
                this.put("name", (String)map.get("name"));
                this.put("type", (String)map.get("type"));
            }
        } : this.fixUUID((Map)map))));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getCollectionInfos", (TagAttributeList)this.tagAttributeList);
        return array;
    }

    public CFMongoCollection collection(String name) {
        RequestMonitorEventProcessor.onFunctionStart((String)"collection", (boolean)true);
        MongoCollection collection = this.db.getCollection(name, DOCUMENT_CLASS);
        CFMongoCollection res = this.csDelegate != null ? new CFMongoCollection(this, collection, this.csDelegate) : new CFMongoCollection(this, collection);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"collection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection collection(String name, CFMongoClientSession cs) {
        RequestMonitorEventProcessor.onFunctionStart((String)"collection", (boolean)true);
        MongoCollection collection = this.db.getCollection(name, DOCUMENT_CLASS);
        CFMongoCollection res = new CFMongoCollection(this, collection, cs);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"collection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection getCollection(String name) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getCollection", (boolean)true);
        MongoCollection collection = this.db.getCollection(name, DOCUMENT_CLASS);
        CFMongoCollection res = this.csDelegate != null ? new CFMongoCollection(this, collection, this.csDelegate) : new CFMongoCollection(this, collection);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getCollection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection createCollection(String name) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createCollection", (boolean)true);
        if (this.csDelegate != null) {
            this.db.createCollection(this.csDelegate.getClientSession(), name);
        } else {
            this.db.createCollection(name);
        }
        CFMongoCollection res = this.collection(name, this.csDelegate);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createCollection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoCollection createCollection(String name, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)Thread.currentThread().getStackTrace()[1].getMethodName(), (boolean)true);
        CFMongoClientSession clientSession = MongoUtils.getSession(options);
        CreateCollectionOptions createCollectionOptions = null;
        if (clientSession != null && options.size() > 1 || clientSession == null) {
            createCollectionOptions = MongoUtils.getCreateCollectionOptions(options);
        }
        CFMongoClientSession cFMongoClientSession = clientSession = clientSession == null ? this.csDelegate : clientSession;
        if (clientSession != null) {
            RequestMonitorEventProcessor.onFunctionStart((String)"createCollection", (boolean)true);
            if (createCollectionOptions != null) {
                this.db.createCollection(clientSession.getClientSession(), name, createCollectionOptions);
            } else {
                this.db.createCollection(clientSession.getClientSession(), name);
            }
        } else if (createCollectionOptions != null) {
            this.db.createCollection(name, createCollectionOptions);
        } else {
            this.db.createCollection(name);
        }
        CFMongoCollection res = this.collection(name, clientSession);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createCollection", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public boolean collectionExists(String collectionName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"collectionExists", (boolean)true);
        boolean res = false;
        List collectionNames = this.getCollectionNames();
        for (Object name : collectionNames) {
            if (!((String)name).equals(collectionName)) continue;
            res = true;
            break;
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"collectionExists", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoDatabase createView(String name, String viewOn, List pipeline) {
        return this.createView(name, viewOn, pipeline, null);
    }

    public CFMongoDatabase createView(String name, String viewOn, List pipeline, Map createOptions) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createView", (boolean)true);
        CFMongoClientSession clientSession = MongoUtils.getSession(createOptions);
        CreateViewOptions createViewOptions = null;
        if (clientSession != null && createOptions.size() > 1 || clientSession == null) {
            createViewOptions = MongoUtils.getCreateViewOptions(createOptions);
        }
        clientSession = clientSession == null ? this.csDelegate : clientSession;
        List<? extends Bson> mongoPipeline = MongoUtils.getPipeline(pipeline);
        if (clientSession != null) {
            if (createViewOptions != null) {
                this.db.createView(clientSession.getClientSession(), name, viewOn, mongoPipeline, createViewOptions);
            } else {
                this.db.createView(clientSession.getClientSession(), name, viewOn, mongoPipeline);
            }
        } else if (createViewOptions != null) {
            this.db.createView(name, viewOn, mongoPipeline, createViewOptions);
        } else {
            this.db.createView(name, viewOn, mongoPipeline);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createView", null, null, (String)name, (String)viewOn, (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public Map runCommand(Map command) {
        return this.runCommand(command, null);
    }

    public Map runCommand(Map command, Map configMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"runCommand", (boolean)true);
        BsonDocument commandDoc = BsonUtils.to(command);
        Map res = this.__runCommand(commandDoc, configMap, DOCUMENT_CLASS);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"runCommand", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private Map __runCommand(BsonDocument commandDoc, Map configMap) {
        return this.__runCommand(commandDoc, configMap, DOCUMENT_CLASS);
    }

    protected <T> T __runCommand(BsonDocument commandDoc, Map configMap, Class<T> resultClass) {
        CFMongoClientSession clientSession;
        ReadPreference readPreference = MongoUtils.getReadPreference(configMap);
        if (readPreference == null) {
            readPreference = this.db.getReadPreference();
        }
        clientSession = (clientSession = MongoUtils.getSession(configMap)) == null ? this.csDelegate : clientSession;
        T res = this.__runCommand((Bson)commandDoc, readPreference, clientSession, resultClass);
        return res;
    }

    protected Map __runCommand(Bson commandDoc, ReadPreference readPreference, CFMongoClientSession clientSession) {
        Map res = this.__runCommand(commandDoc, readPreference, clientSession, DOCUMENT_CLASS);
        return res;
    }

    protected <T> T __runCommand(Bson commandDoc, ReadPreference readPreference, CFMongoClientSession clientSession, Class<T> resultClass) {
        Object res = clientSession != null ? (readPreference != null ? this.db.runCommand(clientSession.getClientSession(), commandDoc, readPreference, resultClass) : this.db.runCommand(clientSession.getClientSession(), commandDoc, resultClass)) : (readPreference != null ? this.db.runCommand(commandDoc, readPreference, resultClass) : this.db.runCommand(commandDoc, resultClass));
        return (T)res;
    }

    public CFMongoServiceHandle getMongo() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getMongo", (boolean)true);
        CFMongoServiceHandle res = this.svc;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getMongo", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoDatabase getSiblingDB(String name) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getSiblingDB", (boolean)true);
        CFMongoDatabase res = this.svc.db(name);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getSiblingDB", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map adminCommand(Map command) {
        return this.adminCommand(command, null);
    }

    public Map adminCommand(Map command, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"adminCommand", (boolean)true);
        Map res = this.getSiblingDB("admin").runCommand(command, options);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"adminCommand", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map stats() {
        return this.stats(1);
    }

    public Map stats(int scale) {
        RequestMonitorEventProcessor.onFunctionStart((String)"stats", (boolean)true);
        BsonDocument dbStatsDoc = new BsonDocument("dbStats", VALUE_1).append("scale", (BsonValue)new BsonInt32(scale));
        Map res = this.__runCommand((Bson)dbStatsDoc, this.db.getReadPreference(), this.csDelegate);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"stats", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map serverBuildInfo() {
        RequestMonitorEventProcessor.onFunctionStart((String)"serverBuildInfo", (boolean)true);
        Map res = this.runSimpleCommand("buildInfo");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"serverBuildInfo", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map serverCmdLineOpts() {
        RequestMonitorEventProcessor.onFunctionStart((String)"serverCmdLineOpts", (boolean)true);
        Map res = this.runSimpleCommand("getCmdLineOpts");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"serverCmdLineOpts", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map hostInfo() {
        RequestMonitorEventProcessor.onFunctionStart((String)"hostInfo", (boolean)true);
        Map res = this.runSimpleCommand("hostInfo");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"hostInfo", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map isMaster() {
        RequestMonitorEventProcessor.onFunctionStart((String)"isMaster", (boolean)true);
        Map res = this.runSimpleCommand("isMaster");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"isMaster", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map isMaster(Map fields) {
        RequestMonitorEventProcessor.onFunctionStart((String)"isMaster", (boolean)true);
        Map res = this.runSimpleCommand("isMaster");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"isMaster", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map currentOp() {
        RequestMonitorEventProcessor.onFunctionStart((String)"currentOp", (boolean)true);
        Map res = this.runSimpleCommand("currentOp");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"currentOp", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map currentOp(Object operations) {
        return this.currentOp(operations, null);
    }

    public Map currentOp(Object operations, Map<?, ?> options) {
        boolean b;
        RequestMonitorEventProcessor.onFunctionStart((String)"currentOp", (boolean)true);
        Map res = operations instanceof Map ? this.runSimpleCommand("currentOp", (Map)operations, options) : ((b = Cast._boolean((Object)operations, (boolean)false)) ? this.runSimpleCommand("currentOp", Collections.singletonMap("$all", true), options) : this.currentOp());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"currentOp", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private Map runSimpleCommand(String command) {
        return this.runSimpleCommand(command, null);
    }

    private Map runSimpleCommand(String command, Map<?, ?> fields) {
        return this.runSimpleCommand(command, fields, null);
    }

    private Map runSimpleCommand(String command, Map<?, ?> fields, Map<?, ?> options) {
        BsonDocument commandDoc = new BsonDocument(command, VALUE_1);
        if (fields != null) {
            BsonUtils.to(fields, commandDoc);
        }
        return this.__runCommand(commandDoc, options);
    }

    public Map serverStatus() {
        return this.serverStatus(null, null);
    }

    public Map serverStatus(Map<?, ?> filter) {
        return this.serverStatus(filter, null);
    }

    public Map serverStatus(Map<?, ?> filter, Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"serverStatus", (boolean)true);
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("serverStatus", VALUE_1);
        if (filter != null) {
            BsonUtils.to(filter, bsonDocument);
        }
        Map res = this.__runCommand(bsonDocument, options);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"serverStatus", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public String version() {
        RequestMonitorEventProcessor.onFunctionStart((String)"version", (boolean)true);
        String res = this.version(null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"version", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public String version(Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"version", (boolean)true);
        TreeSet<String> keys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        keys.add("version");
        Map map = this.getServerStatusFields(keys, options);
        String res = (String)map.get("version");
        CloudMonitoringUtil.onCloudFunctionEnd((String)"version", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    private Map getServerStatusFields(Set<String> keys, Map<?, ?> options) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.put("serverStatus", VALUE_1);
        for (String statusKey : serverStatusKeys) {
            if (keys.contains(statusKey)) continue;
            bsonDocument.put(statusKey, VALUE_0);
        }
        return this.__runCommand(bsonDocument, options);
    }

    private Object getStatsField(String name) {
        BsonDocument dbStatsDoc = new BsonDocument("dbStats", VALUE_1).append("scale", (BsonValue)new BsonInt32(1));
        Map stats = this.__runCommand((Bson)dbStatsDoc, this.db.getReadPreference(), this.csDelegate);
        return stats.get(name);
    }

    public CFMongoGridFSBucket createBucket() {
        RequestMonitorEventProcessor.onFunctionStart((String)"createBucket", (boolean)true);
        GridFSBucket bucket = GridFSBuckets.create((MongoDatabase)this.db);
        CFMongoGridFSBucket res = new CFMongoGridFSBucket(bucket);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createBucket", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoGridFSBucket createBucket(String name) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createBucket", (boolean)true);
        GridFSBucket bucket = GridFSBuckets.create((MongoDatabase)this.db, (String)name);
        CFMongoGridFSBucket res = new CFMongoGridFSBucket(bucket);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createBucket", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map createUser(Map user) {
        return this.createUser(user, null);
    }

    public Map createUser(Map user, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createUser", (boolean)true);
        if (user == null || ((String)user.get("user")).isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        Object userName = user.get("user");
        if (!(userName instanceof String)) {
            throw new MongoConfigException("UsernameNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.usernamenotstring"));
        }
        user.remove("user");
        BsonDocument document = new BsonDocument();
        document.put("createUser", (BsonValue)new BsonString((String)userName));
        if (user.containsKey("passwordDigestor")) {
            Object passwordDigest = user.get("passwordDigestor");
            if (!(passwordDigest instanceof String)) {
                throw new MongoConfigException("PasswordDigestNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.passworddigestnotstring"));
            }
            user.remove("passwordDigestor");
            if (passwordDigest != null) {
                boolean digest;
                if (((String)passwordDigest).equalsIgnoreCase("server")) {
                    digest = true;
                } else if (((String)passwordDigest).equalsIgnoreCase("client")) {
                    digest = false;
                } else {
                    throw new MongoConfigException("PasswordDigestNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.passworddigestnotstring"));
                }
                document.put("digestPassword", (BsonValue)new BsonBoolean(digest));
            }
        }
        BsonUtils.to(user, document);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map changeUserPassword(String userName, String password) {
        return this.changeUserPassword(userName, password, null);
    }

    public Map changeUserPassword(String userName, String password, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"changeUserPassword", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        if (password == null || password.isEmpty()) {
            throw new MongoConfigException("MissingPassword", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingpassword"));
        }
        BsonDocument document = new BsonDocument();
        document.put("updateUser", (BsonValue)new BsonString(userName));
        document.put("pwd", (BsonValue)new BsonString(password));
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"changeUserPassword", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getUser(String userName) {
        return this.getUser(userName, null);
    }

    public Map getUser(String userName, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getUser", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        BsonDocument document = new BsonDocument();
        document.put("usersInfo", (BsonValue)new BsonString(userName));
        if (options != null) {
            if (options.containsKey("showCredentials")) {
                document.put("showCredentials", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showCredentials"))));
            }
            if (options.containsKey("showPrivileges")) {
                document.put("showPrivileges", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showPrivileges"))));
            }
            if (options.containsKey("showAuthenticationRestrictions")) {
                document.put("showAuthenticationRestrictions", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showAuthenticationRestrictions"))));
            }
            if (options.containsKey("filter")) {
                document.put("filter", (BsonValue)BsonUtils.to((Map)options.get("filter")));
            }
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getUsers() {
        return this.getUsers(null);
    }

    public Map getUsers(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getUsers", (boolean)true);
        BsonDocument document = new BsonDocument();
        document.put("usersInfo", (BsonValue)new BsonInt32(1));
        if (options != null) {
            if (options.containsKey("showCredentials")) {
                document.put("showCredentials", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showCredentials"))));
            }
            if (options.containsKey("filter")) {
                document.put("filter", (BsonValue)BsonUtils.to((Map)options.get("filter")));
            }
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getUsers", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map dropUser(String userName) {
        return this.dropUser(userName, null);
    }

    public Map dropUser(String userName, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropUser", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        BsonDocument document = new BsonDocument();
        document.put("dropUser", (BsonValue)new BsonString(userName));
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map dropAllUsers() {
        return this.dropAllUsers(null);
    }

    public Map dropAllUsers(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropAllUsers", (boolean)true);
        BsonDocument document = new BsonDocument();
        document.put("dropAllUsersFromDatabase", (BsonValue)new BsonInt32(1));
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropAllUsers", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map grantRolesToUser(String userName, List roles) {
        return this.grantRolesToUser(userName, roles, null);
    }

    public Map grantRolesToUser(String userName, List roles, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"grantRolesToUser", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        if (roles == null || roles.size() == 0) {
            throw new MongoConfigException("MissingRoleToGrantUser", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingroleforgrant"));
        }
        BsonDocument document = new BsonDocument();
        document.put("grantRolesToUser", (BsonValue)new BsonString(userName));
        BsonArray rolesArray = BsonUtils.to(roles);
        document.put("roles", (BsonValue)rolesArray);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"grantRolesToUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map removeUser(String userName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"removeUser", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        BsonDocument document = new BsonDocument();
        document.put("dropUser", (BsonValue)new BsonString(userName));
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"removeUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map revokeRolesFromUser(String userName, List roles) {
        return this.revokeRolesFromUser(userName, roles, null);
    }

    public Map revokeRolesFromUser(String userName, List roles, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"revokeRolesFromUser", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        if (roles == null || roles.size() == 0) {
            throw new MongoConfigException("MissingRoleToRevokeFromUser", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingroleforrevoke"));
        }
        BsonDocument document = new BsonDocument();
        document.put("revokeRolesFromUser", (BsonValue)new BsonString(userName));
        BsonArray rolesArray = BsonUtils.to(roles);
        document.put("roles", (BsonValue)rolesArray);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"revokeRolesFromUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map updateUser(String userName, Map update) {
        return this.updateUser(userName, update, null);
    }

    public Map updateUser(String userName, Map update, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateUser", (boolean)true);
        if (userName == null || userName.isEmpty()) {
            throw new MongoConfigException("MissingUsername", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingusername"));
        }
        if (update == null) {
            throw new MongoConfigException("MissingUpdateInfo", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingupdateinfo"));
        }
        Object password = update.get("password");
        if (!(userName instanceof String)) {
            throw new MongoConfigException("PasswordNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.passwordnotstring"));
        }
        update.remove("password");
        Object passwordDigest = update.get("passwordDigestor");
        if (!(passwordDigest instanceof String)) {
            throw new MongoConfigException("PasswordDigestNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.passworddigestnotstring"));
        }
        update.remove("passwordDigestor");
        BsonDocument document = new BsonDocument();
        document.put("updateUser", (BsonValue)new BsonString(userName));
        if (passwordDigest != null) {
            boolean digest;
            if (((String)passwordDigest).equalsIgnoreCase("server")) {
                digest = true;
            } else if (((String)passwordDigest).equalsIgnoreCase("client")) {
                digest = false;
            } else {
                throw new MongoConfigException("PasswordDigestNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.passworddigestnotstring"));
            }
            document.put("digestPassword", (BsonValue)new BsonBoolean(digest));
        }
        BsonUtils.to(update, document);
        if (password != null) {
            document.put("pwd", (BsonValue)new BsonString((String)password));
        }
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateUser", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map createRole(Map role) {
        return this.createRole(role, null);
    }

    public Map createRole(Map role, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createRole", (boolean)true);
        if (role == null || ((String)role.get("role")).isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        Object roleName = role.get("role");
        if (!(roleName instanceof String)) {
            throw new MongoConfigException("RolenameNotString", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.rolenamenotstring"));
        }
        role.remove("role");
        BsonDocument document = new BsonDocument();
        document.put("createRole", (BsonValue)new BsonString((String)roleName));
        if (!role.containsKey("privileges")) {
            document.put("privileges", (BsonValue)new BsonArray());
        }
        if (!role.containsKey("roles")) {
            document.put("roles", (BsonValue)new BsonArray());
        }
        BsonUtils.to(role, document);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"createRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map dropRole(String roleName) {
        return this.dropRole(roleName, null);
    }

    public Map dropRole(String roleName, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        BsonDocument document = new BsonDocument();
        document.put("dropRole", (BsonValue)new BsonString(roleName));
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map dropAllRoles() {
        return this.dropAllRoles(null);
    }

    public Map dropAllRoles(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropAllRoles", (boolean)true);
        BsonDocument document = new BsonDocument();
        document.put("dropAllRolesFromDatabase", (BsonValue)new BsonInt32(1));
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropAllRoles", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getRole(String roleName) {
        return this.getRole(roleName, null);
    }

    public Map getRole(String roleName, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        BsonDocument document = new BsonDocument();
        document.put("rolesInfo", (BsonValue)new BsonString(roleName));
        if (options != null) {
            if (options.containsKey("showBuiltinRoles")) {
                document.put("showBuiltinRoles", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showBuiltinRoles"))));
            }
            if (options.containsKey("showPrivileges")) {
                document.put("showPrivileges", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showPrivileges"))));
            }
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getRoles() {
        return this.getRoles(null);
    }

    public Map getRoles(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getRoles", (boolean)true);
        BsonDocument document = new BsonDocument();
        document.put("rolesInfo", (BsonValue)new BsonInt32(1));
        if (options != null) {
            if (options.containsKey("showBuiltinRoles")) {
                document.put("showBuiltinRoles", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showBuiltinRoles"))));
            }
            if (options.containsKey("showPrivileges")) {
                document.put("showPrivileges", (BsonValue)new BsonBoolean(Cast._boolean(options.get("showPrivileges"))));
            }
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getRoles", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map grantPrivilegesToRole(String roleName, List privileges) {
        return this.grantPrivilegesToRole(roleName, privileges, null);
    }

    public Map grantPrivilegesToRole(String roleName, List privileges, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"grantPrivilegesToRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        BsonDocument document = new BsonDocument();
        document.put("grantPrivilegesToRole", (BsonValue)new BsonString(roleName));
        BsonArray privilegesArray = BsonUtils.to(privileges);
        document.put("privileges", (BsonValue)privilegesArray);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"grantPrivilegesToRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map revokePrivilegesFromRole(String roleName, List privileges) {
        return this.revokePrivilegesFromRole(roleName, privileges, null);
    }

    public Map revokePrivilegesFromRole(String roleName, List privileges, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"revokePrivilegesFromRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        BsonDocument document = new BsonDocument();
        document.put("revokePrivilegesFromRole", (BsonValue)new BsonString(roleName));
        BsonArray privilegesArray = BsonUtils.to(privileges);
        document.put("privileges", (BsonValue)privilegesArray);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"revokePrivilegesFromRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map grantRolesToRole(String roleName, List roles) {
        return this.grantRolesToRole(roleName, roles, null);
    }

    public Map grantRolesToRole(String roleName, List roles, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"grantRolesToRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        BsonDocument document = new BsonDocument();
        document.put("grantRolesToRole", (BsonValue)new BsonString(roleName));
        BsonArray rolesArray = BsonUtils.to(roles);
        document.put("roles", (BsonValue)rolesArray);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"grantRolesToRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map revokeRolesFromRole(String roleName, List roles) {
        return this.revokeRolesFromRole(roleName, roles, null);
    }

    public Map revokeRolesFromRole(String roleName, List roles, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"revokeRolesFromRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        BsonDocument document = new BsonDocument();
        document.put("revokeRolesFromRole", (BsonValue)new BsonString(roleName));
        BsonArray rolesArray = BsonUtils.to(roles);
        document.put("roles", (BsonValue)rolesArray);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"revokeRolesFromRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map updateRole(String roleName, Map update) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateRole", (boolean)true);
        Map res = this.updateRole(roleName, update, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map updateRole(String roleName, Map update, Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"updateRole", (boolean)true);
        if (roleName == null || roleName.isEmpty()) {
            throw new MongoConfigException("MissingRolename", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingrolename"));
        }
        if (update == null) {
            throw new MongoConfigException("MissingUpdateInfo", RB.getString(MongoUtils.class, (String)"coldfusion.mongodb.missingupdateinfo"));
        }
        BsonDocument document = new BsonDocument();
        document.put("updateRole", (BsonValue)new BsonString(roleName));
        BsonUtils.to(update, document);
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"updateRole", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map dropDatabase() {
        return this.dropDatabase(null);
    }

    public Map dropDatabase(Map options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"dropDatabase", (boolean)true);
        BsonDocument document = new BsonDocument();
        document.put("dropDatabase", (BsonValue)new BsonInt32(1));
        if (options != null) {
            document.put("writeConcern", (BsonValue)BsonUtils.to(options));
        }
        Map res = this.__runCommand(document, null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"dropDatabase", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoDatabase withReadConcern(String readConcern) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withReadConcern", (boolean)true);
        this.db = this.db.withReadConcern(new ReadConcern(ReadConcernLevel.fromString((String)readConcern)));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withReadConcern", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoDatabase withWriteConcern(Map wConcernMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withWriteConcern", (boolean)true);
        WriteConcern wConcern = MongoUtils.getWriteConcern(wConcernMap);
        this.db = this.db.withWriteConcern(wConcern);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withWriteConcern", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoDatabase withReadPreference(Map prefMap) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withReadPreference", (boolean)true);
        ReadPreference readPreference = MongoUtils.getReadPreference(prefMap);
        this.db = this.db.withReadPreference(readPreference);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withReadPreference", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoDatabase withSession(CFMongoClientSession session) {
        RequestMonitorEventProcessor.onFunctionStart((String)"withSession", (boolean)true);
        this.csDelegate = session;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"withSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoDatabase clearSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"clearSession", (boolean)true);
        this.csDelegate = null;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"clearSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public CFMongoClientSession getSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getSession", (boolean)true);
        CFMongoClientSession res = this.csDelegate;
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getSession", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getWriteConcern() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getWriteConcern", (boolean)true);
        Map res = MongoUtils.toMap(this.db.getWriteConcern());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getWriteConcern", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public String getReadConcern() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getReadConcern", (boolean)true);
        String res = this.db.getReadConcern().toString();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getReadConcern", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getReadPreference() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getReadPreference", (boolean)true);
        Map res = MongoUtils.toMap(this.db.getReadPreference());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getReadPreference", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object getMetadata() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getMetadata", (boolean)true);
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("name", this.getName());
        ReadConcern readConcern = this.db.getReadConcern();
        String readConcernLevel = "DEFAULT";
        if (readConcern != null && readConcern.getLevel() != null) {
            readConcernLevel = readConcern.getLevel().toString();
        }
        metaData.put("readConcern", readConcernLevel);
        metaData.put("writeConcern", MongoUtils.toMap(this.db.getWriteConcern()));
        metaData.put("readPreference", MongoUtils.toMap(this.db.getReadPreference()));
        if (this.csDelegate != null) {
            metaData.put("session", this.csDelegate.getMetadata());
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getMetadata", (TagAttributeList)this.tagAttributeList);
        return metaData;
    }

    public String getLabel() {
        return "MongoDBDatabase";
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void bindName(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void bindName_Final(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void unbindName(String name) {
        throw new UnsupportedOperationException();
    }

    protected Object resolveName(String name) {
        return this.collection(name);
    }

    protected boolean containsName(String name) {
        throw new UnsupportedOperationException();
    }

    protected Iterator getNames() {
        return Collections.emptyList().iterator();
    }

    private ClientSession getClientSession(Map<?, ?> configMap) {
        CFMongoClientSession clientSession = MongoUtils.getSession(configMap);
        clientSession = clientSession == null ? (this.csDelegate != null ? this.csDelegate : null) : clientSession;
        return clientSession != null ? clientSession.getClientSession() : null;
    }

    private Map fixUUID(Map map) {
        UUID uuid;
        Map info;
        if (map != null && (info = (Map)map.get("info")) != null && (uuid = (UUID)info.get("uuid")) != null) {
            info.put("uuid", uuid.toString());
        }
        return map;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("mongo service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("mongo service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getSvc", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSvc();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSvc", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getName", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getName();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getName", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getCollectionNames", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getCollectionNames();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getCollectionNames", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"__getCollectionNames", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"clientSession"}, args);
                    return obj.__getCollectionNames((CFMongoClientSession)((Object)((Object)Cast._castForInvokeGen((Object)argColl.get((Object)"clientSession"), CFMongoClientSession.class))));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("__getCollectionNames", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getCollectionInfos", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getCollectionInfos();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query"}, args);
                    return obj.getCollectionInfos(Cast._Map((Object)argColl.get((Object)"query")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "nameOnly"}, args);
                    return obj.getCollectionInfos(Cast._Map((Object)argColl.get((Object)"query")), Cast._boolean((Object)argColl.get((Object)"nameOnly")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "nameOnly", "authorizedCollections"}, args);
                    return obj.getCollectionInfos(Cast._Map((Object)argColl.get((Object)"query")), Cast._boolean((Object)argColl.get((Object)"nameOnly")), Cast._boolean((Object)argColl.get((Object)"authorizedCollections")));
                }
                case 4: {
                    argColl = new ArgumentCollection((Object[])new String[]{"query", "nameOnly", "authorizedCollections", "options"}, args);
                    return obj.getCollectionInfos(Cast._Map((Object)argColl.get((Object)"query")), Cast._boolean((Object)argColl.get((Object)"nameOnly")), Cast._boolean((Object)argColl.get((Object)"authorizedCollections")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getCollectionInfos", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"collection", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name"}, args);
                    return obj.collection(Cast._String((Object)argColl.get((Object)"name")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name", "cs"}, args);
                    return obj.collection(Cast._String((Object)argColl.get((Object)"name")), (CFMongoClientSession)((Object)((Object)Cast._castForInvokeGen((Object)argColl.get((Object)"cs"), CFMongoClientSession.class))));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("collection", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getCollection", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name"}, args);
                    return obj.getCollection(Cast._String((Object)argColl.get((Object)"name")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getCollection", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createCollection", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name"}, args);
                    return obj.createCollection(Cast._String((Object)argColl.get((Object)"name")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name", "options"}, args);
                    return obj.createCollection(Cast._String((Object)argColl.get((Object)"name")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createCollection", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"collectionExists", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"collectionName"}, args);
                    return obj.collectionExists(Cast._String((Object)argColl.get((Object)"collectionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("collectionExists", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createView", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name", "viewOn", "pipeline"}, args);
                    return obj.createView(Cast._String((Object)argColl.get((Object)"name")), Cast._String((Object)argColl.get((Object)"viewOn")), Cast._List((Object)argColl.get((Object)"pipeline")));
                }
                case 4: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name", "viewOn", "pipeline", "createOptions"}, args);
                    return obj.createView(Cast._String((Object)argColl.get((Object)"name")), Cast._String((Object)argColl.get((Object)"viewOn")), Cast._List((Object)argColl.get((Object)"pipeline")), Cast._Map((Object)argColl.get((Object)"createOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createView", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"runCommand", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"command"}, args);
                    return obj.runCommand(Cast._Map((Object)argColl.get((Object)"command")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"command", "configMap"}, args);
                    return obj.runCommand(Cast._Map((Object)argColl.get((Object)"command")), Cast._Map((Object)argColl.get((Object)"configMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("runCommand", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getMongo", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getMongo();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getMongo", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSiblingDB", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name"}, args);
                    return obj.getSiblingDB(Cast._String((Object)argColl.get((Object)"name")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSiblingDB", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"adminCommand", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"command"}, args);
                    return obj.adminCommand(Cast._Map((Object)argColl.get((Object)"command")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"command", "options"}, args);
                    return obj.adminCommand(Cast._Map((Object)argColl.get((Object)"command")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("adminCommand", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"stats", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.stats();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"scale"}, args);
                    return obj.stats(Cast._int((Object)argColl.get((Object)"scale"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("stats", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"serverBuildInfo", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.serverBuildInfo();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("serverBuildInfo", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"serverCmdLineOpts", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.serverCmdLineOpts();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("serverCmdLineOpts", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"hostInfo", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.hostInfo();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("hostInfo", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"isMaster", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.isMaster();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"fields"}, args);
                    return obj.isMaster(Cast._Map((Object)argColl.get((Object)"fields")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("isMaster", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"currentOp", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.currentOp();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"operations"}, args);
                    return obj.currentOp(argColl.get((Object)"operations"));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"operations", "options"}, args);
                    return obj.currentOp(argColl.get((Object)"operations"), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("currentOp", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"serverStatus", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.serverStatus();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter"}, args);
                    return obj.serverStatus(Cast._Map((Object)argColl.get((Object)"filter")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter", "options"}, args);
                    return obj.serverStatus(Cast._Map((Object)argColl.get((Object)"filter")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("serverStatus", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"version", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.version();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.version(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("version", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createBucket", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.createBucket();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"name"}, args);
                    return obj.createBucket(Cast._String((Object)argColl.get((Object)"name")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createBucket", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"user"}, args);
                    return obj.createUser(Cast._Map((Object)argColl.get((Object)"user")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"user", "options"}, args);
                    return obj.createUser(Cast._Map((Object)argColl.get((Object)"user")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"changeUserPassword", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "password"}, args);
                    return obj.changeUserPassword(Cast._String((Object)argColl.get((Object)"userName")), Cast._String((Object)argColl.get((Object)"password")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "password", "options"}, args);
                    return obj.changeUserPassword(Cast._String((Object)argColl.get((Object)"userName")), Cast._String((Object)argColl.get((Object)"password")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("changeUserPassword", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName"}, args);
                    return obj.getUser(Cast._String((Object)argColl.get((Object)"userName")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "options"}, args);
                    return obj.getUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getUsers", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getUsers();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.getUsers(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getUsers", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName"}, args);
                    return obj.dropUser(Cast._String((Object)argColl.get((Object)"userName")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "options"}, args);
                    return obj.dropUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropAllUsers", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.dropAllUsers();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.dropAllUsers(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropAllUsers", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"grantRolesToUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "roles"}, args);
                    return obj.grantRolesToUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._List((Object)argColl.get((Object)"roles")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "roles", "options"}, args);
                    return obj.grantRolesToUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._List((Object)argColl.get((Object)"roles")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("grantRolesToUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removeUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName"}, args);
                    return obj.removeUser(Cast._String((Object)argColl.get((Object)"userName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removeUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"revokeRolesFromUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "roles"}, args);
                    return obj.revokeRolesFromUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._List((Object)argColl.get((Object)"roles")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "roles", "options"}, args);
                    return obj.revokeRolesFromUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._List((Object)argColl.get((Object)"roles")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("revokeRolesFromUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateUser", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "update"}, args);
                    return obj.updateUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._Map((Object)argColl.get((Object)"update")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"userName", "update", "options"}, args);
                    return obj.updateUser(Cast._String((Object)argColl.get((Object)"userName")), Cast._Map((Object)argColl.get((Object)"update")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateUser", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"role"}, args);
                    return obj.createRole(Cast._Map((Object)argColl.get((Object)"role")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"role", "options"}, args);
                    return obj.createRole(Cast._Map((Object)argColl.get((Object)"role")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName"}, args);
                    return obj.dropRole(Cast._String((Object)argColl.get((Object)"roleName")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "options"}, args);
                    return obj.dropRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropAllRoles", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.dropAllRoles();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.dropAllRoles(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropAllRoles", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName"}, args);
                    return obj.getRole(Cast._String((Object)argColl.get((Object)"roleName")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "options"}, args);
                    return obj.getRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRoles", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRoles();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.getRoles(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRoles", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"grantPrivilegesToRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "privileges"}, args);
                    return obj.grantPrivilegesToRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"privileges")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "privileges", "options"}, args);
                    return obj.grantPrivilegesToRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"privileges")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("grantPrivilegesToRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"revokePrivilegesFromRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "privileges"}, args);
                    return obj.revokePrivilegesFromRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"privileges")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "privileges", "options"}, args);
                    return obj.revokePrivilegesFromRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"privileges")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("revokePrivilegesFromRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"grantRolesToRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "roles"}, args);
                    return obj.grantRolesToRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"roles")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "roles", "options"}, args);
                    return obj.grantRolesToRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"roles")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("grantRolesToRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"revokeRolesFromRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "roles"}, args);
                    return obj.revokeRolesFromRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"roles")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "roles", "options"}, args);
                    return obj.revokeRolesFromRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._List((Object)argColl.get((Object)"roles")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("revokeRolesFromRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateRole", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "update"}, args);
                    return obj.updateRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._Map((Object)argColl.get((Object)"update")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"roleName", "update", "options"}, args);
                    return obj.updateRole(Cast._String((Object)argColl.get((Object)"roleName")), Cast._Map((Object)argColl.get((Object)"update")), Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateRole", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"dropDatabase", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.dropDatabase();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.dropDatabase(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("dropDatabase", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withReadConcern", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"readConcern"}, args);
                    return obj.withReadConcern(Cast._String((Object)argColl.get((Object)"readConcern")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withReadConcern", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withWriteConcern", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"wConcernMap"}, args);
                    return obj.withWriteConcern(Cast._Map((Object)argColl.get((Object)"wConcernMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withWriteConcern", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withReadPreference", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"prefMap"}, args);
                    return obj.withReadPreference(Cast._Map((Object)argColl.get((Object)"prefMap")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withReadPreference", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"withSession", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"session"}, args);
                    return obj.withSession((CFMongoClientSession)((Object)((Object)Cast._castForInvokeGen((Object)argColl.get((Object)"session"), CFMongoClientSession.class))));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("withSession", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"clearSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.clearSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("clearSession", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSession", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getWriteConcern", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getWriteConcern();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getWriteConcern", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getReadConcern", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getReadConcern();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getReadConcern", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getReadPreference", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getReadPreference();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getReadPreference", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getMetadata", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getMetadata();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getMetadata", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getLabel", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getLabel();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getLabel", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"clone", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.clone();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("clone", (Object)obj);
        });
    }
}

