/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi.handler;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.lifecycle.BaseLifecycleManager;

public class LifecycleManager
extends BaseLifecycleManager {
    public LifecycleManager(Object instance) {
        this.instance = instance;
    }

    @Override
    protected Method getPostConstructMethod() {
        if (this.instance != null) {
            List<Method> methods = this.getMethods(this.instance.getClass());
            for (Method method : methods) {
                if (LifecycleManager.getAnnotation(method, PostConstruct.class) == null) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    protected Method getPreDestroyMethod() {
        if (this.instance != null) {
            List<Method> methods = this.getMethods(this.instance.getClass());
            for (Method method : methods) {
                if (LifecycleManager.getAnnotation(method, PreDestroy.class) == null) continue;
                return method;
            }
        }
        return null;
    }

    private List<Method> getMethods(final Class beanClass) {
        List methods = (List)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ArrayList<Method> methods = new ArrayList<Method>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Method[] methodArray;
                    for (Method method : methodArray = cls.getDeclaredMethods()) {
                        methods.add(method);
                    }
                }
                return methods;
            }
        });
        return methods;
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation);
            }
        });
    }
}

