/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi;

import jakarta.xml.ws.Endpoint;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.metadata.ServiceName;
import org.apache.axis2.addressing.metadata.WSDLLocation;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.server.endpoint.EndpointImpl;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Provider
extends jakarta.xml.ws.spi.Provider {
    private static final Log log = LogFactory.getLog(Provider.class);
    private static final Element[] ZERO_LENGTH_ARRAY = new Element[0];

    public Endpoint createAndPublishEndpoint(String s, Object obj) {
        return this.createAndPublishEndpoint(s, obj, null);
    }

    public Endpoint createAndPublishEndpoint(String s, Object obj, WebServiceFeature ... features) {
        EndpointImpl ep = new EndpointImpl(obj);
        ep.publish(s);
        return ep;
    }

    public Endpoint createEndpoint(String binding, Object obj) {
        return this.createEndpoint(binding, obj, null);
    }

    public Endpoint createEndpoint(String binding, Object obj, WebServiceFeature ... features) {
        return new EndpointImpl(obj);
    }

    public jakarta.xml.ws.spi.ServiceDelegate createServiceDelegate(URL url, QName qname, Class clazz) {
        return this.createServiceDelegate(url, qname, clazz, null);
    }

    public jakarta.xml.ws.spi.ServiceDelegate createServiceDelegate(URL url, QName qname, Class clazz, WebServiceFeature ... features) {
        return new ServiceDelegate(url, qname, clazz, features);
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters) {
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(W3CEndpointReference.class);
        EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference(address, serviceName, portName, wsdlDocumentLocation, addressingNamespace);
        W3CEndpointReference w3cEPR = null;
        try {
            if (metadata != null) {
                EndpointReferenceUtils.addMetadata(axis2EPR, metadata.toArray(ZERO_LENGTH_ARRAY));
            }
            if (referenceParameters != null) {
                EndpointReferenceUtils.addReferenceParameters(axis2EPR, referenceParameters.toArray(ZERO_LENGTH_ARRAY));
            }
            w3cEPR = (W3CEndpointReference)EndpointReferenceUtils.convertFromAxis2(axis2EPR, addressingNamespace);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"referenceParameterConstructionErr"), (Throwable)e);
        }
        return w3cEPR;
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName interfaceName, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters, List<Element> elements, Map<QName, String> attributes) {
        String addressingNamespace = EndpointReferenceUtils.getAddressingNamespace(W3CEndpointReference.class);
        EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference(address, serviceName, portName, wsdlDocumentLocation, addressingNamespace);
        W3CEndpointReference w3cEPR = null;
        try {
            if (interfaceName != null) {
                EndpointReferenceUtils.addInterface(axis2EPR, interfaceName, addressingNamespace);
            }
            if (metadata != null) {
                EndpointReferenceUtils.addMetadata(axis2EPR, metadata.toArray(ZERO_LENGTH_ARRAY));
            }
            if (referenceParameters != null) {
                EndpointReferenceUtils.addReferenceParameters(axis2EPR, referenceParameters.toArray(ZERO_LENGTH_ARRAY));
            }
            if (elements != null) {
                EndpointReferenceUtils.addExtensibleElements(axis2EPR, elements.toArray(ZERO_LENGTH_ARRAY));
            }
            if (attributes != null) {
                EndpointReferenceUtils.addExtensibleAttributes(axis2EPR, attributes);
            }
            w3cEPR = (W3CEndpointReference)EndpointReferenceUtils.convertFromAxis2(axis2EPR, addressingNamespace);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"referenceParameterConstructionErr"), (Throwable)e);
        }
        return w3cEPR;
    }

    public <T> T getPort(jakarta.xml.ws.EndpointReference jaxwsEPR, Class<T> sei, WebServiceFeature ... features) {
        if (jaxwsEPR == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"dispatchNoEndpointReference2"));
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"getPortInvalidSEI", (String)jaxwsEPR.toString(), (String)"null"));
        }
        EndpointReference axis2EPR = EndpointReferenceUtils.createAxis2EndpointReference("");
        String addressingNamespace = null;
        try {
            addressingNamespace = EndpointReferenceUtils.convertToAxis2(axis2EPR, jaxwsEPR);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invalidEndpointReference", (String)e.toString()));
        }
        ServiceDelegate serviceDelegate = null;
        try {
            ServiceName serviceName = EndpointReferenceHelper.getServiceNameMetadata((EndpointReference)axis2EPR, (String)addressingNamespace);
            WSDLLocation wsdlLocation = EndpointReferenceHelper.getWSDLLocationMetadata((EndpointReference)axis2EPR, (String)addressingNamespace);
            URL wsdlLocationURL = null;
            if (wsdlLocation.getLocation() != null) {
                wsdlLocationURL = new URL(wsdlLocation.getLocation());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getPort: Using EPR wsdlLocationURL = " + wsdlLocationURL));
                }
            } else {
                wsdlLocationURL = new URL(axis2EPR.getAddress() + "?wsdl");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getPort: Using default wsdlLocationURL = " + wsdlLocationURL));
                }
            }
            serviceDelegate = new ServiceDelegate(wsdlLocationURL, serviceName.getName(), Service.class, new WebServiceFeature[0]);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"endpointUpdateError"), (Throwable)e);
        }
        return serviceDelegate.getPort(axis2EPR, addressingNamespace, sei, features);
    }

    public jakarta.xml.ws.EndpointReference readEndpointReference(Source eprInfoset) {
        jakarta.xml.ws.EndpointReference jaxwsEPR = null;
        try {
            jaxwsEPR = EndpointReferenceUtils.convertFromSource(eprInfoset);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"endpointRefCreationError"), (Throwable)e);
        }
        return jaxwsEPR;
    }
}

