/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import jakarta.xml.bind.util.JAXBSource;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.datasource.SourceDataSource;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.SourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceBlockImpl
extends BlockImpl<Source, Void>
implements SourceBlock {
    private static final Log log = LogFactory.getLog(SourceBlockImpl.class);

    SourceBlockImpl(Source busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
        if (busObject instanceof DOMSource || busObject instanceof SAXSource || busObject instanceof StreamSource || busObject instanceof StAXSource || busObject instanceof JAXBSource) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("data object is a " + busObject.getClass().getName()));
            }
        } else {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceNotSupported", (String)busObject.getClass().getName()));
        }
    }

    public SourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, null, qName, factory);
    }

    @Override
    protected Source _getBOFromOM(OMElement omElement, Void busContext) throws XMLStreamException, WebServiceException {
        OMDataSource ds;
        if (omElement instanceof OMSourcedElement && (ds = ((OMSourcedElement)omElement).getDataSource()) instanceof SourceDataSource) {
            return ((SourceDataSource)ds).getObject();
        }
        boolean hasFault = false;
        if (this.parent != null && this.parent.isFault() || omElement.getQName().getLocalPart().equals("Fault")) {
            hasFault = true;
        }
        MemoryBlob blob = Blobs.createMemoryBlob();
        MemoryBlobOutputStream out = blob.getOutputStream();
        try {
            if (!hasFault) {
                omElement.serializeAndConsume((OutputStream)out);
            } else {
                omElement.serialize((OutputStream)out);
            }
            out.close();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        StreamSource busObject = new StreamSource((InputStream)blob.getInputStream());
        return busObject;
    }

    @Override
    protected XMLStreamReader _getReaderFromBO(Source busObj, Void busContext) throws XMLStreamException, WebServiceException {
        try {
            if (busObj instanceof StreamSource) {
                XMLInputFactory f = StAXUtils.getXMLInputFactory();
                return f.createXMLStreamReader(busObj);
            }
            return this._slow_getReaderFromSource(busObj);
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceReadErr", (String)className), (Throwable)e);
        }
    }

    private XMLStreamReader _slow_getReaderFromSource(Source src) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start _slow_getReaderFromSource");
        }
        byte[] bytes = (byte[])ConvertUtils.convert(src, byte[].class);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully converted to ByteArray");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((InputStream)bais);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End _slow_getReaderFromSource =" + reader));
        }
        return reader;
    }

    @Override
    protected void _outputFromBO(Source busObject, Void busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start _outputFromBO");
        }
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Obtained reader=" + reader));
        }
        this._outputFromReader(reader, writer);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End _outputReaderFromBO");
        }
    }

    @Override
    protected Source _getBOFromBO(Source busObject, Void busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceMissingSupport", (String)busObject.getClass().getName()));
    }

    @Override
    public boolean isElementData() {
        return false;
    }

    public void close() {
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return true;
    }

    public boolean isDestructiveWrite() {
        return true;
    }
}

