/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.builder.DataSourceBuilder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.DataSourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceBlockImpl
extends BlockImpl<DataSource, Void>
implements DataSourceBlock {
    private static final Log log = LogFactory.getLog(DataSourceBlockImpl.class);

    DataSourceBlockImpl(DataSource busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
    }

    public DataSourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, null, qName, factory);
    }

    @Override
    public OMElement getOMElement() throws XMLStreamException, WebServiceException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("", "");
        return factory.createOMElement((OMDataSource)this, "dummy", ns);
    }

    @Override
    protected DataSource _getBOFromOM(OMElement omElement, Void busContext) throws XMLStreamException, WebServiceException {
        DataSourceBuilder.ByteArrayDataSourceEx busObject;
        boolean hasFault = false;
        if (this.parent != null && this.parent.isFault() || omElement.getQName().getLocalPart().equals("Fault")) {
            hasFault = true;
        }
        if (!hasFault) {
            busObject = (DataSourceBuilder.ByteArrayDataSourceEx)((OMSourcedElement)omElement).getDataSource();
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            omElement.serialize((OutputStream)baos);
            busObject = new ByteArrayDataSource(baos.toByteArray(), "UTF-8");
        }
        return busObject;
    }

    @Override
    protected XMLStreamReader _getReaderFromBO(DataSource busObj, Void busContext) throws XMLStreamException, WebServiceException {
        try {
            return StAXUtils.createXMLStreamReader((InputStream)busObj.getInputStream());
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceReadErr", (String)className), (Throwable)e);
        }
    }

    @Override
    protected void _outputFromBO(DataSource busObject, Void busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start _outputFromBO");
        }
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Obtained reader=" + reader));
        }
        this._outputFromReader(reader, writer);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End _outputReaderFromBO");
        }
    }

    @Override
    protected DataSource _getBOFromBO(DataSource busObject, Void busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceMissingSupport", (String)busObject.getClass().getName()));
    }

    @Override
    public boolean isElementData() {
        return false;
    }

    public void close() {
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return true;
    }

    public boolean isDestructiveWrite() {
        return true;
    }
}

