/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import jakarta.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBDataSource
extends AbstractPushOMDataSource {
    private static final Log log = LogFactory.getLog(JAXBDataSource.class);
    private final Object jaxb;
    private final JAXBDSContext context;

    public JAXBDataSource(Object jaxb, JAXBDSContext context) {
        this.jaxb = jaxb;
        this.context = context;
    }

    public OMDataSourceExt copy() {
        return new JAXBDataSource(this.jaxb, this.context);
    }

    public Object getObject() {
        return this.jaxb;
    }

    public JAXBDSContext getContext() {
        return this.context;
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            this.context.marshal(this.jaxb, xmlWriter);
        }
        catch (JAXBException je) {
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("JAXBContext for marshal failure:" + this.context.getJAXBContext(this.context.getClassLoader())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new XMLStreamException(je);
        }
    }

    public boolean isDestructiveWrite() {
        return false;
    }
}

