/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import jakarta.activation.DataHandler;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axis2.datasource.jaxb.AttachmentContext;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentUnmarshallerMonitor;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JAXBAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private static final Log log = LogFactory.getLog(JAXBAttachmentUnmarshaller.class);
    private final AttachmentContext context;
    private final OMAttachmentAccessor attachmentAccessor;

    public JAXBAttachmentUnmarshaller(AttachmentContext context, OMAttachmentAccessor attachmentAccessor) {
        this.context = context;
        this.attachmentAccessor = attachmentAccessor;
    }

    public final boolean isXOPPackage() {
        boolean value = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("isXOPPackage returns " + value));
        }
        return value;
    }

    public final byte[] getAttachmentAsByteArray(String cid) {
        DataHandler dh;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to retrieve attachment [" + cid + "] as a byte[]"));
        }
        if ((dh = this.getAttachmentAsDataHandler(cid)) != null) {
            try {
                return this.convert(dh);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception occurred while getting the byte[] " + ioe));
                }
                throw new OMException((Throwable)ioe);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning null byte[]");
        }
        return null;
    }

    public final DataHandler getAttachmentAsDataHandler(String cid) {
        DataHandler dh;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to retrieve attachment [" + cid + "] as a DataHandler"));
        }
        if ((dh = this.getDataHandler(cid)) != null) {
            return dh;
        }
        String cid2 = this.getNewCID(cid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("A dataHandler was not found for [" + cid + "] trying [" + cid2 + "]"));
        }
        if ((dh = this.getDataHandler(cid2)) != null) {
            return dh;
        }
        throw new OMException(Messages.getMessage((String)"noDataHandler", (String)cid));
    }

    private String getNewCID(String cid) {
        String cid2;
        block2: {
            cid2 = cid;
            try {
                cid2 = URLDecoder.decode(cid, "UTF-8");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("getNewCID decoding " + cid + " as UTF-8 decoding error: " + e));
            }
        }
        return cid2;
    }

    private byte[] convert(DataHandler dh) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading byte[] from DataHandler " + dh));
        }
        InputStream is = dh.getInputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataHandler InputStream " + is));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int num = is.read(b);
        if (log.isDebugEnabled() && num <= 0) {
            log.debug((Object)("DataHandler InputStream contains no data. num=" + num));
        }
        while (num > 0) {
            baos.write(b, 0, num);
            num = is.read(b);
        }
        return baos.toByteArray();
    }

    private DataHandler getDataHandler(String cid) {
        DataHandler dh;
        String blobcid = cid;
        if (blobcid.startsWith("cid:")) {
            blobcid = blobcid.substring(4);
        }
        if ((dh = this.attachmentAccessor.getDataHandler(blobcid)) == null) {
            dh = this.context.getDataHandlerForSwA(blobcid);
        }
        if (dh != null) {
            JAXBAttachmentUnmarshallerMonitor.addBlobCID(blobcid);
        }
        return dh;
    }
}

