/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.ContainerPortProtocol;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class KubernetesServicePort
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public KubernetesServicePort() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static KubernetesServicePort createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new KubernetesServicePort();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAppProtocol() {
        return (String)this.backingStore.get("appProtocol");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("appProtocol", n -> this.setAppProtocol(n.getStringValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("nodePort", n -> this.setNodePort(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("port", n -> this.setPort(n.getIntegerValue()));
        deserializerMap.put("protocol", n -> this.setProtocol((ContainerPortProtocol)n.getEnumValue(ContainerPortProtocol::forValue)));
        deserializerMap.put("targetPort", n -> this.setTargetPort(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public Integer getNodePort() {
        return (Integer)this.backingStore.get("nodePort");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getPort() {
        return (Integer)this.backingStore.get("port");
    }

    @Nullable
    public ContainerPortProtocol getProtocol() {
        return (ContainerPortProtocol)((Object)this.backingStore.get("protocol"));
    }

    @Nullable
    public String getTargetPort() {
        return (String)this.backingStore.get("targetPort");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("appProtocol", this.getAppProtocol());
        writer.writeStringValue("name", this.getName());
        writer.writeIntegerValue("nodePort", this.getNodePort());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("port", this.getPort());
        writer.writeEnumValue("protocol", (Enum)this.getProtocol());
        writer.writeStringValue("targetPort", this.getTargetPort());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAppProtocol(@Nullable String value) {
        this.backingStore.set("appProtocol", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setNodePort(@Nullable Integer value) {
        this.backingStore.set("nodePort", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPort(@Nullable Integer value) {
        this.backingStore.set("port", (Object)value);
    }

    public void setProtocol(@Nullable ContainerPortProtocol value) {
        this.backingStore.set("protocol", (Object)value);
    }

    public void setTargetPort(@Nullable String value) {
        this.backingStore.set("targetPort", (Object)value);
    }
}

