/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.security.DataSourceHoldStatus;
import com.microsoft.graph.models.security.SiteSource;
import com.microsoft.graph.models.security.UnifiedGroupSource;
import com.microsoft.graph.models.security.UserSource;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DataSource
extends Entity
implements Parsable {
    @Nonnull
    public static DataSource createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.siteSource": {
                    return new SiteSource();
                }
                case "#microsoft.graph.security.unifiedGroupSource": {
                    return new UnifiedGroupSource();
                }
                case "#microsoft.graph.security.userSource": {
                    return new UserSource();
                }
            }
        }
        return new DataSource();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("holdStatus", n -> this.setHoldStatus((DataSourceHoldStatus)n.getEnumValue(DataSourceHoldStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public DataSourceHoldStatus getHoldStatus() {
        return (DataSourceHoldStatus)((Object)this.backingStore.get("holdStatus"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeEnumValue("holdStatus", (Enum)this.getHoldStatus());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setHoldStatus(@Nullable DataSourceHoldStatus value) {
        this.backingStore.set("holdStatus", (Object)value);
    }
}

