/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.ResultInfo;
import com.microsoft.graph.models.security.CaseAction;
import com.microsoft.graph.models.security.CaseOperationStatus;
import com.microsoft.graph.models.security.EdiscoveryAddToReviewSetOperation;
import com.microsoft.graph.models.security.EdiscoveryEstimateOperation;
import com.microsoft.graph.models.security.EdiscoveryExportOperation;
import com.microsoft.graph.models.security.EdiscoveryHoldOperation;
import com.microsoft.graph.models.security.EdiscoveryIndexOperation;
import com.microsoft.graph.models.security.EdiscoveryPurgeDataOperation;
import com.microsoft.graph.models.security.EdiscoveryTagOperation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CaseOperation
extends Entity
implements Parsable {
    @Nonnull
    public static CaseOperation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.ediscoveryAddToReviewSetOperation": {
                    return new EdiscoveryAddToReviewSetOperation();
                }
                case "#microsoft.graph.security.ediscoveryEstimateOperation": {
                    return new EdiscoveryEstimateOperation();
                }
                case "#microsoft.graph.security.ediscoveryExportOperation": {
                    return new EdiscoveryExportOperation();
                }
                case "#microsoft.graph.security.ediscoveryHoldOperation": {
                    return new EdiscoveryHoldOperation();
                }
                case "#microsoft.graph.security.ediscoveryIndexOperation": {
                    return new EdiscoveryIndexOperation();
                }
                case "#microsoft.graph.security.ediscoveryPurgeDataOperation": {
                    return new EdiscoveryPurgeDataOperation();
                }
                case "#microsoft.graph.security.ediscoveryTagOperation": {
                    return new EdiscoveryTagOperation();
                }
            }
        }
        return new CaseOperation();
    }

    @Nullable
    public CaseAction getAction() {
        return (CaseAction)((Object)this.backingStore.get("action"));
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("action", n -> this.setAction((CaseAction)n.getEnumValue(CaseAction::forValue)));
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("percentProgress", n -> this.setPercentProgress(n.getIntegerValue()));
        deserializerMap.put("resultInfo", n -> this.setResultInfo((ResultInfo)n.getObjectValue(ResultInfo::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((CaseOperationStatus)n.getEnumValue(CaseOperationStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Integer getPercentProgress() {
        return (Integer)this.backingStore.get("percentProgress");
    }

    @Nullable
    public ResultInfo getResultInfo() {
        return (ResultInfo)this.backingStore.get("resultInfo");
    }

    @Nullable
    public CaseOperationStatus getStatus() {
        return (CaseOperationStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("action", (Enum)this.getAction());
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeIntegerValue("percentProgress", this.getPercentProgress());
        writer.writeObjectValue("resultInfo", (Parsable)this.getResultInfo(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setAction(@Nullable CaseAction value) {
        this.backingStore.set("action", (Object)value);
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setPercentProgress(@Nullable Integer value) {
        this.backingStore.set("percentProgress", (Object)value);
    }

    public void setResultInfo(@Nullable ResultInfo value) {
        this.backingStore.set("resultInfo", (Object)value);
    }

    public void setStatus(@Nullable CaseOperationStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

