/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UpdateAllowedCombinationsResult
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UpdateAllowedCombinationsResult() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UpdateAllowedCombinationsResult createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UpdateAllowedCombinationsResult();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAdditionalInformation() {
        return (String)this.backingStore.get("additionalInformation");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<String> getConditionalAccessReferences() {
        return (List)this.backingStore.get("conditionalAccessReferences");
    }

    @Nullable
    public List<AuthenticationMethodModes> getCurrentCombinations() {
        return (List)this.backingStore.get("currentCombinations");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("additionalInformation", n -> this.setAdditionalInformation(n.getStringValue()));
        deserializerMap.put("conditionalAccessReferences", n -> this.setConditionalAccessReferences(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("currentCombinations", n -> this.setCurrentCombinations(n.getCollectionOfEnumValues(AuthenticationMethodModes::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("previousCombinations", n -> this.setPreviousCombinations(n.getCollectionOfEnumValues(AuthenticationMethodModes::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<AuthenticationMethodModes> getPreviousCombinations() {
        return (List)this.backingStore.get("previousCombinations");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("additionalInformation", this.getAdditionalInformation());
        writer.writeCollectionOfPrimitiveValues("conditionalAccessReferences", this.getConditionalAccessReferences());
        writer.writeCollectionOfEnumValues("currentCombinations", this.getCurrentCombinations());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfEnumValues("previousCombinations", this.getPreviousCombinations());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAdditionalInformation(@Nullable String value) {
        this.backingStore.set("additionalInformation", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setConditionalAccessReferences(@Nullable List<String> value) {
        this.backingStore.set("conditionalAccessReferences", value);
    }

    public void setCurrentCombinations(@Nullable List<AuthenticationMethodModes> value) {
        this.backingStore.set("currentCombinations", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPreviousCombinations(@Nullable List<AuthenticationMethodModes> value) {
        this.backingStore.set("previousCombinations", value);
    }
}

