/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.TimeRange;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ShiftAvailability
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ShiftAvailability() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ShiftAvailability createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ShiftAvailability();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("recurrence", n -> this.setRecurrence((PatternedRecurrence)n.getObjectValue(PatternedRecurrence::createFromDiscriminatorValue)));
        deserializerMap.put("timeSlots", n -> this.setTimeSlots(n.getCollectionOfObjectValues(TimeRange::createFromDiscriminatorValue)));
        deserializerMap.put("timeZone", n -> this.setTimeZone(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public PatternedRecurrence getRecurrence() {
        return (PatternedRecurrence)this.backingStore.get("recurrence");
    }

    @Nullable
    public List<TimeRange> getTimeSlots() {
        return (List)this.backingStore.get("timeSlots");
    }

    @Nullable
    public String getTimeZone() {
        return (String)this.backingStore.get("timeZone");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("recurrence", (Parsable)this.getRecurrence(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("timeSlots", this.getTimeSlots());
        writer.writeStringValue("timeZone", this.getTimeZone());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRecurrence(@Nullable PatternedRecurrence value) {
        this.backingStore.set("recurrence", (Object)value);
    }

    public void setTimeSlots(@Nullable List<TimeRange> value) {
        this.backingStore.set("timeSlots", value);
    }

    public void setTimeZone(@Nullable String value) {
        this.backingStore.set("timeZone", (Object)value);
    }
}

