/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.RecurrenceRangeType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RecurrenceRange
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RecurrenceRange() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RecurrenceRange createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RecurrenceRange();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public LocalDate getEndDate() {
        return (LocalDate)this.backingStore.get("endDate");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("endDate", n -> this.setEndDate(n.getLocalDateValue()));
        deserializerMap.put("numberOfOccurrences", n -> this.setNumberOfOccurrences(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("recurrenceTimeZone", n -> this.setRecurrenceTimeZone(n.getStringValue()));
        deserializerMap.put("startDate", n -> this.setStartDate(n.getLocalDateValue()));
        deserializerMap.put("type", n -> this.setType((RecurrenceRangeType)n.getEnumValue(RecurrenceRangeType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Integer getNumberOfOccurrences() {
        return (Integer)this.backingStore.get("numberOfOccurrences");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getRecurrenceTimeZone() {
        return (String)this.backingStore.get("recurrenceTimeZone");
    }

    @Nullable
    public LocalDate getStartDate() {
        return (LocalDate)this.backingStore.get("startDate");
    }

    @Nullable
    public RecurrenceRangeType getType() {
        return (RecurrenceRangeType)((Object)this.backingStore.get("type"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeLocalDateValue("endDate", this.getEndDate());
        writer.writeIntegerValue("numberOfOccurrences", this.getNumberOfOccurrences());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("recurrenceTimeZone", this.getRecurrenceTimeZone());
        writer.writeLocalDateValue("startDate", this.getStartDate());
        writer.writeEnumValue("type", (Enum)this.getType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEndDate(@Nullable LocalDate value) {
        this.backingStore.set("endDate", (Object)value);
    }

    public void setNumberOfOccurrences(@Nullable Integer value) {
        this.backingStore.set("numberOfOccurrences", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRecurrenceTimeZone(@Nullable String value) {
        this.backingStore.set("recurrenceTimeZone", (Object)value);
    }

    public void setStartDate(@Nullable LocalDate value) {
        this.backingStore.set("startDate", (Object)value);
    }

    public void setType(@Nullable RecurrenceRangeType value) {
        this.backingStore.set("type", (Object)value);
    }
}

