/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Photo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Photo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Photo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Photo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCameraMake() {
        return (String)this.backingStore.get("cameraMake");
    }

    @Nullable
    public String getCameraModel() {
        return (String)this.backingStore.get("cameraModel");
    }

    @Nullable
    public Double getExposureDenominator() {
        return (Double)this.backingStore.get("exposureDenominator");
    }

    @Nullable
    public Double getExposureNumerator() {
        return (Double)this.backingStore.get("exposureNumerator");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("cameraMake", n -> this.setCameraMake(n.getStringValue()));
        deserializerMap.put("cameraModel", n -> this.setCameraModel(n.getStringValue()));
        deserializerMap.put("exposureDenominator", n -> this.setExposureDenominator(n.getDoubleValue()));
        deserializerMap.put("exposureNumerator", n -> this.setExposureNumerator(n.getDoubleValue()));
        deserializerMap.put("fNumber", n -> this.setFNumber(n.getDoubleValue()));
        deserializerMap.put("focalLength", n -> this.setFocalLength(n.getDoubleValue()));
        deserializerMap.put("iso", n -> this.setIso(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("orientation", n -> this.setOrientation(n.getIntegerValue()));
        deserializerMap.put("takenDateTime", n -> this.setTakenDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public Double getFNumber() {
        return (Double)this.backingStore.get("fNumber");
    }

    @Nullable
    public Double getFocalLength() {
        return (Double)this.backingStore.get("focalLength");
    }

    @Nullable
    public Integer getIso() {
        return (Integer)this.backingStore.get("iso");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getOrientation() {
        return (Integer)this.backingStore.get("orientation");
    }

    @Nullable
    public OffsetDateTime getTakenDateTime() {
        return (OffsetDateTime)this.backingStore.get("takenDateTime");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("cameraMake", this.getCameraMake());
        writer.writeStringValue("cameraModel", this.getCameraModel());
        writer.writeDoubleValue("exposureDenominator", this.getExposureDenominator());
        writer.writeDoubleValue("exposureNumerator", this.getExposureNumerator());
        writer.writeDoubleValue("fNumber", this.getFNumber());
        writer.writeDoubleValue("focalLength", this.getFocalLength());
        writer.writeIntegerValue("iso", this.getIso());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("orientation", this.getOrientation());
        writer.writeOffsetDateTimeValue("takenDateTime", this.getTakenDateTime());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCameraMake(@Nullable String value) {
        this.backingStore.set("cameraMake", (Object)value);
    }

    public void setCameraModel(@Nullable String value) {
        this.backingStore.set("cameraModel", (Object)value);
    }

    public void setExposureDenominator(@Nullable Double value) {
        this.backingStore.set("exposureDenominator", (Object)value);
    }

    public void setExposureNumerator(@Nullable Double value) {
        this.backingStore.set("exposureNumerator", (Object)value);
    }

    public void setFNumber(@Nullable Double value) {
        this.backingStore.set("fNumber", (Object)value);
    }

    public void setFocalLength(@Nullable Double value) {
        this.backingStore.set("focalLength", (Object)value);
    }

    public void setIso(@Nullable Integer value) {
        this.backingStore.set("iso", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOrientation(@Nullable Integer value) {
        this.backingStore.set("orientation", (Object)value);
    }

    public void setTakenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("takenDateTime", (Object)value);
    }
}

