/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IosDeviceType;
import com.microsoft.graph.models.IosMinimumOperatingSystem;
import com.microsoft.graph.models.ManagedMobileLobApp;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedIOSLobApp
extends ManagedMobileLobApp
implements Parsable {
    public ManagedIOSLobApp() {
        this.setOdataType("#microsoft.graph.managedIOSLobApp");
    }

    @Nonnull
    public static ManagedIOSLobApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ManagedIOSLobApp();
    }

    @Nullable
    public IosDeviceType getApplicableDeviceType() {
        return (IosDeviceType)this.backingStore.get("applicableDeviceType");
    }

    @Nullable
    public String getBuildNumber() {
        return (String)this.backingStore.get("buildNumber");
    }

    @Nullable
    public String getBundleId() {
        return (String)this.backingStore.get("bundleId");
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("applicableDeviceType", n -> this.setApplicableDeviceType((IosDeviceType)n.getObjectValue(IosDeviceType::createFromDiscriminatorValue)));
        deserializerMap.put("buildNumber", n -> this.setBuildNumber(n.getStringValue()));
        deserializerMap.put("bundleId", n -> this.setBundleId(n.getStringValue()));
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("minimumSupportedOperatingSystem", n -> this.setMinimumSupportedOperatingSystem((IosMinimumOperatingSystem)n.getObjectValue(IosMinimumOperatingSystem::createFromDiscriminatorValue)));
        deserializerMap.put("versionNumber", n -> this.setVersionNumber(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IosMinimumOperatingSystem getMinimumSupportedOperatingSystem() {
        return (IosMinimumOperatingSystem)this.backingStore.get("minimumSupportedOperatingSystem");
    }

    @Nullable
    public String getVersionNumber() {
        return (String)this.backingStore.get("versionNumber");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("applicableDeviceType", (Parsable)this.getApplicableDeviceType(), new Parsable[0]);
        writer.writeStringValue("buildNumber", this.getBuildNumber());
        writer.writeStringValue("bundleId", this.getBundleId());
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeObjectValue("minimumSupportedOperatingSystem", (Parsable)this.getMinimumSupportedOperatingSystem(), new Parsable[0]);
        writer.writeStringValue("versionNumber", this.getVersionNumber());
    }

    public void setApplicableDeviceType(@Nullable IosDeviceType value) {
        this.backingStore.set("applicableDeviceType", (Object)value);
    }

    public void setBuildNumber(@Nullable String value) {
        this.backingStore.set("buildNumber", (Object)value);
    }

    public void setBundleId(@Nullable String value) {
        this.backingStore.set("bundleId", (Object)value);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setMinimumSupportedOperatingSystem(@Nullable IosMinimumOperatingSystem value) {
        this.backingStore.set("minimumSupportedOperatingSystem", (Object)value);
    }

    public void setVersionNumber(@Nullable String value) {
        this.backingStore.set("versionNumber", (Object)value);
    }
}

