/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class FileEncryptionInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public FileEncryptionInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static FileEncryptionInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new FileEncryptionInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public byte[] getEncryptionKey() {
        return (byte[])this.backingStore.get("encryptionKey");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("encryptionKey", n -> this.setEncryptionKey(n.getByteArrayValue()));
        deserializerMap.put("fileDigest", n -> this.setFileDigest(n.getByteArrayValue()));
        deserializerMap.put("fileDigestAlgorithm", n -> this.setFileDigestAlgorithm(n.getStringValue()));
        deserializerMap.put("initializationVector", n -> this.setInitializationVector(n.getByteArrayValue()));
        deserializerMap.put("mac", n -> this.setMac(n.getByteArrayValue()));
        deserializerMap.put("macKey", n -> this.setMacKey(n.getByteArrayValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("profileIdentifier", n -> this.setProfileIdentifier(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public byte[] getFileDigest() {
        return (byte[])this.backingStore.get("fileDigest");
    }

    @Nullable
    public String getFileDigestAlgorithm() {
        return (String)this.backingStore.get("fileDigestAlgorithm");
    }

    @Nullable
    public byte[] getInitializationVector() {
        return (byte[])this.backingStore.get("initializationVector");
    }

    @Nullable
    public byte[] getMac() {
        return (byte[])this.backingStore.get("mac");
    }

    @Nullable
    public byte[] getMacKey() {
        return (byte[])this.backingStore.get("macKey");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getProfileIdentifier() {
        return (String)this.backingStore.get("profileIdentifier");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeByteArrayValue("encryptionKey", this.getEncryptionKey());
        writer.writeByteArrayValue("fileDigest", this.getFileDigest());
        writer.writeStringValue("fileDigestAlgorithm", this.getFileDigestAlgorithm());
        writer.writeByteArrayValue("initializationVector", this.getInitializationVector());
        writer.writeByteArrayValue("mac", this.getMac());
        writer.writeByteArrayValue("macKey", this.getMacKey());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("profileIdentifier", this.getProfileIdentifier());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEncryptionKey(@Nullable byte[] value) {
        this.backingStore.set("encryptionKey", (Object)value);
    }

    public void setFileDigest(@Nullable byte[] value) {
        this.backingStore.set("fileDigest", (Object)value);
    }

    public void setFileDigestAlgorithm(@Nullable String value) {
        this.backingStore.set("fileDigestAlgorithm", (Object)value);
    }

    public void setInitializationVector(@Nullable byte[] value) {
        this.backingStore.set("initializationVector", (Object)value);
    }

    public void setMac(@Nullable byte[] value) {
        this.backingStore.set("mac", (Object)value);
    }

    public void setMacKey(@Nullable byte[] value) {
        this.backingStore.set("macKey", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProfileIdentifier(@Nullable String value) {
        this.backingStore.set("profileIdentifier", (Object)value);
    }
}

