/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ExtensionProperty
extends DirectoryObject
implements Parsable {
    public ExtensionProperty() {
        this.setOdataType("#microsoft.graph.extensionProperty");
    }

    @Nonnull
    public static ExtensionProperty createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ExtensionProperty();
    }

    @Nullable
    public String getAppDisplayName() {
        return (String)this.backingStore.get("appDisplayName");
    }

    @Nullable
    public String getDataType() {
        return (String)this.backingStore.get("dataType");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appDisplayName", n -> this.setAppDisplayName(n.getStringValue()));
        deserializerMap.put("dataType", n -> this.setDataType(n.getStringValue()));
        deserializerMap.put("isMultiValued", n -> this.setIsMultiValued(n.getBooleanValue()));
        deserializerMap.put("isSyncedFromOnPremises", n -> this.setIsSyncedFromOnPremises(n.getBooleanValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("targetObjects", n -> this.setTargetObjects(n.getCollectionOfPrimitiveValues(String.class)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsMultiValued() {
        return (Boolean)this.backingStore.get("isMultiValued");
    }

    @Nullable
    public Boolean getIsSyncedFromOnPremises() {
        return (Boolean)this.backingStore.get("isSyncedFromOnPremises");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public List<String> getTargetObjects() {
        return (List)this.backingStore.get("targetObjects");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("appDisplayName", this.getAppDisplayName());
        writer.writeStringValue("dataType", this.getDataType());
        writer.writeBooleanValue("isMultiValued", this.getIsMultiValued());
        writer.writeBooleanValue("isSyncedFromOnPremises", this.getIsSyncedFromOnPremises());
        writer.writeStringValue("name", this.getName());
        writer.writeCollectionOfPrimitiveValues("targetObjects", this.getTargetObjects());
    }

    public void setAppDisplayName(@Nullable String value) {
        this.backingStore.set("appDisplayName", (Object)value);
    }

    public void setDataType(@Nullable String value) {
        this.backingStore.set("dataType", (Object)value);
    }

    public void setIsMultiValued(@Nullable Boolean value) {
        this.backingStore.set("isMultiValued", (Object)value);
    }

    public void setIsSyncedFromOnPremises(@Nullable Boolean value) {
        this.backingStore.set("isSyncedFromOnPremises", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setTargetObjects(@Nullable List<String> value) {
        this.backingStore.set("targetObjects", value);
    }
}

