/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessReviewApplyAction;
import com.microsoft.graph.models.AccessReviewRecommendationInsightSetting;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessReviewScheduleSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AccessReviewScheduleSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AccessReviewScheduleSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AccessReviewScheduleSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<AccessReviewApplyAction> getApplyActions() {
        return (List)this.backingStore.get("applyActions");
    }

    @Nullable
    public Boolean getAutoApplyDecisionsEnabled() {
        return (Boolean)this.backingStore.get("autoApplyDecisionsEnabled");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getDecisionHistoriesForReviewersEnabled() {
        return (Boolean)this.backingStore.get("decisionHistoriesForReviewersEnabled");
    }

    @Nullable
    public String getDefaultDecision() {
        return (String)this.backingStore.get("defaultDecision");
    }

    @Nullable
    public Boolean getDefaultDecisionEnabled() {
        return (Boolean)this.backingStore.get("defaultDecisionEnabled");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(14);
        deserializerMap.put("applyActions", n -> this.setApplyActions(n.getCollectionOfObjectValues(AccessReviewApplyAction::createFromDiscriminatorValue)));
        deserializerMap.put("autoApplyDecisionsEnabled", n -> this.setAutoApplyDecisionsEnabled(n.getBooleanValue()));
        deserializerMap.put("decisionHistoriesForReviewersEnabled", n -> this.setDecisionHistoriesForReviewersEnabled(n.getBooleanValue()));
        deserializerMap.put("defaultDecision", n -> this.setDefaultDecision(n.getStringValue()));
        deserializerMap.put("defaultDecisionEnabled", n -> this.setDefaultDecisionEnabled(n.getBooleanValue()));
        deserializerMap.put("instanceDurationInDays", n -> this.setInstanceDurationInDays(n.getIntegerValue()));
        deserializerMap.put("justificationRequiredOnApproval", n -> this.setJustificationRequiredOnApproval(n.getBooleanValue()));
        deserializerMap.put("mailNotificationsEnabled", n -> this.setMailNotificationsEnabled(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("recommendationInsightSettings", n -> this.setRecommendationInsightSettings(n.getCollectionOfObjectValues(AccessReviewRecommendationInsightSetting::createFromDiscriminatorValue)));
        deserializerMap.put("recommendationLookBackDuration", n -> this.setRecommendationLookBackDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("recommendationsEnabled", n -> this.setRecommendationsEnabled(n.getBooleanValue()));
        deserializerMap.put("recurrence", n -> this.setRecurrence((PatternedRecurrence)n.getObjectValue(PatternedRecurrence::createFromDiscriminatorValue)));
        deserializerMap.put("reminderNotificationsEnabled", n -> this.setReminderNotificationsEnabled(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getInstanceDurationInDays() {
        return (Integer)this.backingStore.get("instanceDurationInDays");
    }

    @Nullable
    public Boolean getJustificationRequiredOnApproval() {
        return (Boolean)this.backingStore.get("justificationRequiredOnApproval");
    }

    @Nullable
    public Boolean getMailNotificationsEnabled() {
        return (Boolean)this.backingStore.get("mailNotificationsEnabled");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<AccessReviewRecommendationInsightSetting> getRecommendationInsightSettings() {
        return (List)this.backingStore.get("recommendationInsightSettings");
    }

    @Nullable
    public PeriodAndDuration getRecommendationLookBackDuration() {
        return (PeriodAndDuration)this.backingStore.get("recommendationLookBackDuration");
    }

    @Nullable
    public Boolean getRecommendationsEnabled() {
        return (Boolean)this.backingStore.get("recommendationsEnabled");
    }

    @Nullable
    public PatternedRecurrence getRecurrence() {
        return (PatternedRecurrence)this.backingStore.get("recurrence");
    }

    @Nullable
    public Boolean getReminderNotificationsEnabled() {
        return (Boolean)this.backingStore.get("reminderNotificationsEnabled");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("applyActions", this.getApplyActions());
        writer.writeBooleanValue("autoApplyDecisionsEnabled", this.getAutoApplyDecisionsEnabled());
        writer.writeBooleanValue("decisionHistoriesForReviewersEnabled", this.getDecisionHistoriesForReviewersEnabled());
        writer.writeStringValue("defaultDecision", this.getDefaultDecision());
        writer.writeBooleanValue("defaultDecisionEnabled", this.getDefaultDecisionEnabled());
        writer.writeIntegerValue("instanceDurationInDays", this.getInstanceDurationInDays());
        writer.writeBooleanValue("justificationRequiredOnApproval", this.getJustificationRequiredOnApproval());
        writer.writeBooleanValue("mailNotificationsEnabled", this.getMailNotificationsEnabled());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("recommendationInsightSettings", this.getRecommendationInsightSettings());
        writer.writePeriodAndDurationValue("recommendationLookBackDuration", this.getRecommendationLookBackDuration());
        writer.writeBooleanValue("recommendationsEnabled", this.getRecommendationsEnabled());
        writer.writeObjectValue("recurrence", (Parsable)this.getRecurrence(), new Parsable[0]);
        writer.writeBooleanValue("reminderNotificationsEnabled", this.getReminderNotificationsEnabled());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApplyActions(@Nullable List<AccessReviewApplyAction> value) {
        this.backingStore.set("applyActions", value);
    }

    public void setAutoApplyDecisionsEnabled(@Nullable Boolean value) {
        this.backingStore.set("autoApplyDecisionsEnabled", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDecisionHistoriesForReviewersEnabled(@Nullable Boolean value) {
        this.backingStore.set("decisionHistoriesForReviewersEnabled", (Object)value);
    }

    public void setDefaultDecision(@Nullable String value) {
        this.backingStore.set("defaultDecision", (Object)value);
    }

    public void setDefaultDecisionEnabled(@Nullable Boolean value) {
        this.backingStore.set("defaultDecisionEnabled", (Object)value);
    }

    public void setInstanceDurationInDays(@Nullable Integer value) {
        this.backingStore.set("instanceDurationInDays", (Object)value);
    }

    public void setJustificationRequiredOnApproval(@Nullable Boolean value) {
        this.backingStore.set("justificationRequiredOnApproval", (Object)value);
    }

    public void setMailNotificationsEnabled(@Nullable Boolean value) {
        this.backingStore.set("mailNotificationsEnabled", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRecommendationInsightSettings(@Nullable List<AccessReviewRecommendationInsightSetting> value) {
        this.backingStore.set("recommendationInsightSettings", value);
    }

    public void setRecommendationLookBackDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("recommendationLookBackDuration", (Object)value);
    }

    public void setRecommendationsEnabled(@Nullable Boolean value) {
        this.backingStore.set("recommendationsEnabled", (Object)value);
    }

    public void setRecurrence(@Nullable PatternedRecurrence value) {
        this.backingStore.set("recurrence", (Object)value);
    }

    public void setReminderNotificationsEnabled(@Nullable Boolean value) {
        this.backingStore.set("reminderNotificationsEnabled", (Object)value);
    }
}

